/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ans.AnsCardPortRenderer;
import cerent.cms.ui.ans.AnsConnDataSource;
import cerent.cms.ui.ans.AnsConnTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class AnsPathCreateDialog
extends JDialog
implements ActionListener,
ItemListener,
Observer {
    private static final String TITLE = "Create Optical Link";
    private static final String TITLE_EDIT = "Edit Optical Link";
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final String CHECK = "Bidirectional";
    public static final int MARGIN = 5;
    private static final String SHELF = "ShelfId: ";
    private static final String SLOT = "Slot: ";
    private static final String PORT = "Port: ";
    private static String ALL = "All";
    private static String NA = "N/A";
    private static final int FROM = 0;
    private static final int TO = 1;
    private static final int CHASSIS_FROM = 2;
    private static final int CHASSIS_TO = 3;
    private static final SDebug db = new SDebug("OnsPathCreateDialog");
    private ArrayList onsTypeList;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox bidiCheck;
    private AnsConnTableModel dataModel;
    private NodeModelDelegate nodeModel;
    private JComboBox[] shelfCB = null;
    private JComboBox[] slotCB = new JComboBox[2];
    private JComboBox[] portCB = new JComboBox[2];
    private ArrayList westModelList = new ArrayList(0);
    private ArrayList eastModelList = new ArrayList(0);
    private TDMTerminology terms = null;
    private boolean isedit = false;
    private boolean isMultishelf = false;
    private int from_edit = 0;
    private int to_edit = 0;
    private int item = 0;
    private StringBuffer warningMessage = null;

    public AnsPathCreateDialog(Frame frame, IModel iModel, AnsConnTableModel ansConnTableModel) {
        super(frame, TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AnsPathCreateDialog.this.dispose();
            }
        });
        if (iModel instanceof ChassisModel || iModel instanceof NodeModelDelegate) {
            this.nodeModel = (NodeModelDelegate)iModel.getNodeModel();
            this.terms = this.nodeModel.getTDMTerminology();
        } else if (iModel instanceof ChassisModel) {
            this.nodeModel = (NodeModelDelegate)((ChassisModel)iModel).getNodeModel();
            this.terms = this.nodeModel.getTDMTerminology();
        } else {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_BAROLO_CARD);
            return;
        }
        this.isMultishelf = this.nodeModel.isMultishelf();
        if (this.isMultishelf) {
            this.shelfCB = new JComboBox[2];
        }
        this.dataModel = ansConnTableModel;
        this.setSize(300, this.isMultishelf ? 350 : 250);
        this.initMainPane(frame);
        this.handleWarnings(frame);
        this.setVisible(true);
    }

    public AnsPathCreateDialog(Frame frame, IModel iModel, AnsConnTableModel ansConnTableModel, int n, int n2) {
        super(frame, TITLE_EDIT, true);
        this.isedit = true;
        this.from_edit = n;
        this.to_edit = n2;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AnsPathCreateDialog.this.dispose();
            }
        });
        if (iModel instanceof ChassisModel || iModel instanceof NodeModelDelegate) {
            this.nodeModel = (NodeModelDelegate)iModel.getNodeModel();
            this.terms = this.nodeModel.getTDMTerminology();
        } else if (iModel instanceof ChassisModel) {
            this.nodeModel = (NodeModelDelegate)((ChassisModel)iModel).getNodeModel();
            this.terms = this.nodeModel.getTDMTerminology();
        } else {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_BAROLO_CARD);
            return;
        }
        this.isMultishelf = this.nodeModel.isMultishelf();
        if (this.isMultishelf) {
            this.shelfCB = new JComboBox[2];
        }
        this.dataModel = ansConnTableModel;
        this.setSize(300, this.isMultishelf ? 350 : 250);
        this.setResizable(false);
        this.initMainPane(frame);
        this.initCombosEdit(n, n2);
        this.bidiCheck.setSelected(false);
        this.bidiCheck.setEnabled(false);
        this.setVisible(true);
    }

    private void initCombosEdit(int n, int n2) {
        try {
            OpticsPortModel opticsPortModel = (OpticsPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(n);
            ModuleModel moduleModel = (ModuleModel)opticsPortModel.getParent();
            if (this.isMultishelf) {
                this.shelfCB[0].setSelectedItem((ChassisModel)moduleModel.getChassis());
            }
            this.slotCB[0].setSelectedItem(moduleModel);
            this.portCB[0].setSelectedItem(opticsPortModel);
            OpticsPortModel opticsPortModel2 = (OpticsPortModel)this.nodeModel.getEntityTable().getEntityModelByIndex(n2);
            ModuleModel moduleModel2 = (ModuleModel)opticsPortModel2.getParent();
            if (this.isMultishelf) {
                this.shelfCB[1].setSelectedItem((ChassisModel)moduleModel2.getChassis());
            }
            this.slotCB[1].setSelectedItem(moduleModel2);
            this.portCB[1].setSelectedItem(opticsPortModel2);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMainPane(Frame frame) {
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(0, 1));
        container.add(this.initCBPane(0, "From"));
        container.add(this.initCBPane(1, "To"));
        container.add(this.initButtonPanel());
        this.setLocationRelativeTo(frame);
        this.updatePortCombo(0);
        this.updatePortCombo(1);
        this.slotCB[0].setSelectedIndex(-1);
        this.slotCB[1].setSelectedIndex(-1);
        if (this.slotCB[0].getModel().getSize() > 0) {
            this.slotCB[0].setSelectedIndex(0);
        }
        if (this.slotCB[1].getModel().getSize() > 0) {
            this.slotCB[1].setSelectedIndex(0);
        }
        if (this.isMultishelf) {
            if (this.shelfCB[0].getModel().getSize() > 0) {
                this.shelfCB[0].setSelectedIndex(0);
            }
            if (this.shelfCB[1].getModel().getSize() > 0) {
                this.shelfCB[1].setSelectedIndex(0);
            }
        }
        this.enableComboslistener();
    }

    private void enableComboslistener() {
        if (this.isMultishelf) {
            this.shelfCB[0].addItemListener(this);
            this.shelfCB[1].addItemListener(this);
        }
        this.slotCB[0].addItemListener(this);
        this.slotCB[1].addItemListener(this);
        this.portCB[0].addItemListener(this);
        this.portCB[1].addItemListener(this);
    }

    private JPanel initCBPane(int n, String string) {
        JPanel jPanel = new JPanel();
        if (this.isMultishelf) {
            jPanel.setLayout(new GridLayout(3, 1));
            jPanel.add(new JLabel(SHELF));
        } else {
            jPanel.setLayout(new GridLayout(0, 1));
        }
        jPanel.add(new JLabel(SLOT));
        jPanel.add(new JLabel(PORT));
        if (this.isMultishelf) {
            this.shelfCB[n] = this.initShelfCombo();
            this.shelfCB[n].setRenderer(new OnsCardRenderer());
        }
        this.slotCB[n] = this.initSlotCombo(this.getActualChassismodel(n));
        this.slotCB[n].setRenderer(new OnsCardRenderer());
        this.portCB[n] = new JComboBox();
        this.portCB[n].setRenderer(new AnsCardPortRenderer());
        this.portCB[n].setEnabled(false);
        JPanel jPanel2 = new JPanel();
        if (this.isMultishelf) {
            jPanel2.setLayout(new GridLayout(3, 1));
            jPanel2.add(this.shelfCB[n]);
        } else {
            jPanel2.setLayout(new GridLayout(0, 1));
        }
        jPanel2.add(this.slotCB[n]);
        jPanel2.add(this.portCB[n]);
        JPanel jPanel3 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        jPanel3.setBorder(titledBorder);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "Center");
        return jPanel3;
    }

    private JPanel initButtonPanel() {
        this.okButton = new JButton(OK);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(CANCEL);
        this.cancelButton.addActionListener(this);
        this.bidiCheck = new JCheckBox(CHECK);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add((Component)this.bidiCheck, 0);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JComboBox initShelfCombo() {
        JComboBox<IChassisModel> jComboBox = new JComboBox<IChassisModel>();
        ChassisModels chassisModels = this.nodeModel.getChassisModelsInstance();
        IChassisModel[] iChassisModelArray = chassisModels.getChassisModelsArray();
        Arrays.sort(iChassisModelArray, new Comparator(){

            public int compare(Object object, Object object2) {
                IChassisModel iChassisModel = (IChassisModel)object;
                IChassisModel iChassisModel2 = (IChassisModel)object2;
                return iChassisModel.getShelfId() - iChassisModel2.getShelfId();
            }
        });
        for (int i = 0; i < iChassisModelArray.length; ++i) {
            jComboBox.addItem(iChassisModelArray[i]);
        }
        return jComboBox;
    }

    public void dispose() {
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.test(false) && this.apply()) {
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (AnsPathCreateDialog.db.on) {
            db.println("------------------------------------");
            db.println(itemEvent.paramString());
            db.println("------------------------------------");
        }
        if (this.isMultishelf) {
            if (object == this.shelfCB[0] && itemEvent.getStateChange() == 2) {
                this.initLater(2);
            } else if (object == this.shelfCB[1] && itemEvent.getStateChange() == 2) {
                this.initLater(3);
            }
        }
        if (object == this.slotCB[0]) {
            this.initLater(0);
        } else if (object == this.slotCB[1]) {
            this.initLater(1);
        } else if (object == this.portCB[0] && itemEvent.getStateChange() == 2) {
            this.initLater(1);
        } else if (object == this.portCB[0] && itemEvent.getStateChange() == 1) {
            this.initLater(1);
        }
        this.okButton.setEnabled(this.test(true));
    }

    private void initLater(int n) {
        if (n == 0) {
            this.updatePortCombo(0);
            this.setbidiflag();
        } else if (n == 1) {
            this.updatePortCombo(1);
            this.setbidiflag();
        } else if (n == 2) {
            this.updateSlotCombo(0);
            this.setbidiflag();
        } else if (n == 3) {
            this.updateSlotCombo(1);
            this.setbidiflag();
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = (Integer)object;
            switch (n) {
                case 0: {
                    ((ModuleModel)((Object)observable)).deleteObserver(this);
                    this.slotCB[0] = this.initSlotCombo(this.getActualChassismodel(0));
                    this.handleWarnings(this);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    private void updateSlotCombo(int n) {
        if (AnsPathCreateDialog.db.on) {
            db.println("updateSlotCombo(int index)" + n);
        }
        if (this.isMultishelf) {
            if (this.shelfCB[n].getSelectedIndex() >= 0) {
                ChassisModel chassisModel = (ChassisModel)this.shelfCB[n].getSelectedItem();
                this.slotCB[n].removeAllItems();
                this.fillSlotCombo(this.slotCB[n], chassisModel);
                if (this.slotCB[n].getModel().getSize() > 0) {
                    this.slotCB[n].setSelectedIndex(0);
                }
            }
        } else {
            this.slotCB[n].removeAllItems();
            this.fillSlotCombo(this.slotCB[n], (ChassisModel)this.nodeModel.getNcChassis());
        }
        this.slotCB[n].setEnabled(this.slotCB[n].getModel().getSize() > 0);
    }

    private ChassisModel getActualChassismodel(int n) {
        ChassisModel chassisModel = null;
        chassisModel = this.isMultishelf ? (ChassisModel)this.shelfCB[n].getSelectedItem() : (ChassisModel)this.nodeModel.getNcChassis();
        return chassisModel;
    }

    private JComboBox initSlotCombo(ChassisModel chassisModel) {
        if (AnsPathCreateDialog.db.on) {
            db.println("initSlotCombo(ChassisModel chassis)");
        }
        this.warningMessage = new StringBuffer();
        JComboBox jComboBox = new JComboBox();
        if (chassisModel == null && !this.isMultishelf) {
            chassisModel = (ChassisModel)this.nodeModel.getNcChassis();
        }
        this.fillSlotCombo(jComboBox, chassisModel);
        return jComboBox;
    }

    private void fillSlotCombo(JComboBox jComboBox, ChassisModel chassisModel) {
        if (jComboBox == null || chassisModel == null) {
            return;
        }
        ChassisModel chassisModel2 = chassisModel;
        List list = chassisModel2.getChildrenOfType(eClass.BACKPLANE);
        List list2 = ((EntityModel)list.get(0)).getChildren();
        for (int i = 0; i < list2.size(); ++i) {
            int n;
            Object e;
            EntityModel entityModel = (EntityModel)list2.get(i);
            List list3 = entityModel.getChildren();
            if (list3.size() <= 0 || !((e = list3.get(0)) instanceof ModuleModel) || !this.isPatchcordCard(n = ((ModuleModel)e).getEqType())) continue;
            if (this.isITU_TCard(n)) {
                if (!this.isColoredLinecard((ModuleModel)e)) continue;
                jComboBox.addItem(e);
                continue;
            }
            jComboBox.addItem(e);
        }
    }

    private boolean isPatchcordCard(int n) {
        boolean bl = false;
        switch (n) {
            case 11: 
            case 60: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 191: 
            case 192: 
            case 196: 
            case 219: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 249: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean isColoredLinecard(ModuleModel moduleModel) {
        boolean bl = false;
        if (!moduleModel.isPreProvisioned()) {
            TdmModuleModel tdmModuleModel = (TdmModuleModel)moduleModel;
            TdmLineModel[] tdmLineModelArray = tdmModuleModel.getTdmLineModels();
            for (int i = 0; !bl && i < tdmLineModelArray.length; ++i) {
                TdmLineModel tdmLineModel = tdmLineModelArray[i];
                try {
                    bl = tdmLineModel.isWavelengthSupported();
                    continue;
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Cannot state if port " + tdmLineModel + " is colored");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        } else {
            if (this.warningMessage.length() > 0) {
                this.warningMessage.append("\n");
            }
            this.warningMessage.append(moduleModel.getEqTypeName() + "/Slot " + moduleModel.getSlot());
            bl = true;
        }
        return bl;
    }

    private void handleWarnings(Component component) {
        if (this.warningMessage != null && this.warningMessage.length() > 0) {
            String string = ErrorMsg.getString((EID)EMC.WID_OPTICAL_LINK_NON_EQUIPPED_OCN_PARAM_1, (Object)this.warningMessage);
            CerentDialog.warningDialog((Component)component, (String)string);
        }
    }

    private void updatePortCombo(int n) {
        if (AnsPathCreateDialog.db.on) {
            db.println("updatePortCombo(int index) " + n);
        }
        if (this.portCB[n].getItemCount() > 0) {
            this.portCB[n].removeAllItems();
        }
        if (this.slotCB[n].getSelectedIndex() >= 0) {
            ModuleModel moduleModel = (ModuleModel)this.slotCB[n].getSelectedItem();
            PortModel[] portModelArray = moduleModel.getPortModels();
            switch (n) {
                case 0: {
                    if (this.portCB[1].getItemCount() > 0) {
                        this.portCB[1].removeAllItems();
                    }
                    if (!(this.slotCB[1].getSelectedItem() instanceof ModuleModel)) break;
                    ModuleModel moduleModel2 = (ModuleModel)this.slotCB[1].getSelectedItem();
                    for (int i = 0; i < portModelArray.length; ++i) {
                        PortModel portModel = portModelArray[i];
                        if (portModel instanceof OpticsPortModel) {
                            if (moduleModel2 instanceof OpticsModuleModel) {
                                if (!this.isPortTX(portModel) || !this.testFilterPort(portModel)) continue;
                                this.portCB[n].addItem(portModel);
                                continue;
                            }
                            if (!this.isPortTX(portModel) || !this.isPortCHAN(portModel)) continue;
                            this.portCB[n].addItem(portModel);
                            continue;
                        }
                        if (portModel instanceof DwdmPortModel) {
                            if (((DwdmPortModel)portModel).isClientPort()) continue;
                            this.portCB[n].addItem(portModel);
                            continue;
                        }
                        if (moduleModel instanceof OpticsModuleModel || moduleModel instanceof DwdmModuleModel) continue;
                        if (portModel instanceof TdmPortModel) {
                            if (!this.isOC48_oc192Port(portModel.getEqType())) continue;
                            this.portCB[n].addItem(portModel);
                            continue;
                        }
                        this.portCB[n].addItem(portModel);
                    }
                    break;
                }
                case 1: {
                    ModuleModel moduleModel3;
                    PortModel portModel;
                    if (!(this.portCB[0].getSelectedItem() instanceof PortModel) || (portModel = (PortModel)this.portCB[0].getSelectedItem()) == null || (moduleModel3 = (ModuleModel)this.slotCB[0].getSelectedItem()).getEntityIndex() == moduleModel.getEntityIndex()) break;
                    int n2 = this.getPortDir(portModel);
                    int n3 = this.getOptIfType(portModel);
                    for (int i = 0; i < portModelArray.length; ++i) {
                        PortModel portModel2 = portModelArray[i];
                        if (portModel2 instanceof OpticsPortModel) {
                            int n4 = this.getPortDir(portModel2);
                            int n5 = this.getOptIfType(portModel2);
                            if (moduleModel3 instanceof OpticsModuleModel) {
                                if (n4 == n2 || n5 != n3 && (n5 != 18 || n3 != 19) && (n5 != 19 || n3 != 18)) continue;
                                AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)portModel2.getInterfaceModel();
                                try {
                                    if (abstractOpticsLineModel.getPortType().value() == 14) {
                                    }
                                }
                                catch (Exception exception) {}
                                continue;
                                this.portCB[n].addItem(portModel2);
                                continue;
                            }
                            if (n4 != 1 || !this.isPortCHAN(portModel2)) continue;
                            this.portCB[n].addItem(portModel2);
                            continue;
                        }
                        if (portModel2 instanceof DwdmPortModel) {
                            if (((DwdmPortModel)portModel2).isClientPort() || moduleModel3 instanceof DwdmModuleModel || moduleModel3 instanceof TdmModuleModel || !this.isPortCHAN(portModel)) continue;
                            this.portCB[n].addItem(portModel2);
                            continue;
                        }
                        if (moduleModel instanceof OpticsModuleModel || moduleModel instanceof DwdmModuleModel || moduleModel3 instanceof TdmModuleModel || moduleModel3 instanceof DwdmModuleModel) continue;
                        this.portCB[n].addItem(portModel2);
                    }
                    break;
                }
            }
            this.portCB[n].setEnabled(this.portCB[n].getItemCount() > 0);
        }
        if (this.portCB[n].getItemCount() > 0) {
            this.portCB[n].setSelectedIndex(0);
        } else {
            this.portCB[n].addItem(NA);
            this.portCB[n].setEnabled(false);
        }
    }

    private void setbidiflag() {
        boolean bl = false;
        ModuleModel moduleModel = null;
        EntityModel entityModel = null;
        try {
            moduleModel = (ModuleModel)this.slotCB[0].getSelectedItem();
            entityModel = (ModuleModel)this.slotCB[1].getSelectedItem();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (moduleModel != null && entityModel != null) {
            int n = moduleModel.getEqType();
            int n2 = entityModel.getEqType();
            bl = n != 129 && moduleModel.getEntityIndex() != entityModel.getEntityIndex();
            PortModel portModel = null;
            PortModel portModel2 = null;
            try {
                portModel = (PortModel)this.portCB[0].getSelectedItem();
                portModel2 = (PortModel)this.portCB[1].getSelectedItem();
            }
            catch (ClassCastException classCastException) {
                bl = false;
            }
            if (this.isTrunkCard(n) || this.isTrunkCard(n2)) {
                bl = bl;
            } else {
                EntityModel entityModel2 = null;
                EntityModel entityModel3 = null;
                try {
                    entityModel2 = (EntityModel)this.nodeModel.getEntityTableModel().getEntityModelByIndex(this.getOppositeDir(portModel.getIndex()));
                    entityModel3 = (EntityModel)this.nodeModel.getEntityTableModel().getEntityModelByIndex(this.getOppositeDir(portModel2.getIndex()));
                    bl = bl && entityModel2 != null && entityModel3 != null;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            bl = bl && portModel != null && portModel != null;
        }
        this.bidiCheck.setEnabled(bl);
        this.bidiCheck.setSelected(bl);
    }

    private boolean isTrunkCard(int n) {
        switch (n) {
            case 11: 
            case 60: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 219: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    private boolean isPortTX(PortModel portModel) {
        if (portModel instanceof OpticsPortModel) {
            return ((OpticsPortModel)portModel).getOpticsLineModel().isPortTypeTX();
        }
        return false;
    }

    private boolean testFilterPort(PortModel portModel) {
        boolean bl = true;
        if (portModel instanceof OpticsPortModel) {
            OpticsPortModel opticsPortModel = (OpticsPortModel)portModel;
            try {
                bl = opticsPortModel.getOpticsLineModel().getPortType().value() != 12 && opticsPortModel.getOpticsLineModel().getPortType().value() != 13;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isPortRX(PortModel portModel) {
        if (portModel instanceof OpticsPortModel) {
            return ((OpticsPortModel)portModel).getOpticsLineModel().isPortTypeRX();
        }
        return false;
    }

    private boolean isPortCHAN(PortModel portModel) {
        return this.getOptIfType(portModel) == 21;
    }

    private int getPortDir(PortModel portModel) {
        int n = 0;
        if (portModel instanceof OpticsPortModel) {
            try {
                n = ((OpticsPortModel)portModel).getOpticsLineModel().getPortTypeDir();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private int getOptIfType(PortModel portModel) {
        int n = 0;
        if (portModel instanceof OpticsPortModel) {
            try {
                n = ((OpticsPortModel)portModel).getOpticsLineModel().getOptIfType().value();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private boolean test(boolean bl) {
        boolean bl2 = false;
        boolean[] blArray = new boolean[4];
        String string = "";
        blArray[0] = this.slotCB[0].getSelectedIndex() >= 0 && this.slotCB[0].getSelectedItem() instanceof ModuleModel;
        blArray[1] = this.portCB[0].getSelectedIndex() >= 0 && this.portCB[0].getSelectedItem() instanceof PortModel;
        blArray[2] = this.slotCB[1].getSelectedIndex() >= 0 && this.slotCB[1].getSelectedItem() instanceof ModuleModel;
        boolean bl3 = blArray[3] = this.portCB[1].getSelectedIndex() >= 0 && this.portCB[1].getSelectedItem() instanceof PortModel;
        if (!blArray[0] || !blArray[2]) {
            if (!bl) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"slot");
            }
            return false;
        }
        if (!blArray[1] || !blArray[3]) {
            if (!bl) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"port");
            }
            return false;
        }
        return true;
    }

    private int getBoardIndex(int n) {
        if (this.portCB[n].getSelectedItem() instanceof PortModel) {
            PortModel portModel = (PortModel)this.portCB[n].getSelectedItem();
            return portModel.getEntityIndex();
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getBidiBoardIndex(int n) throws Exception {
        int n2 = 0;
        boolean bl = false;
        ModuleModel moduleModel = null;
        Object object = this.portCB[n].getSelectedItem();
        if (object instanceof OpticsPortModel) {
            OpticsPortModel opticsPortModel = (OpticsPortModel)object;
            moduleModel = (ModuleModel)opticsPortModel.getParent();
            if (moduleModel.getEqType() != 131 && moduleModel.getEqType() != 191 && moduleModel.getEqType() != 242 && moduleModel.getEqType() != 132 && moduleModel.getEqType() != 192) {
                if (moduleModel.getEqType() != 241) return this.getIdByDir(this.getPortDir(opticsPortModel), opticsPortModel.getEntityIndex());
            }
            Object object2 = this.portCB[n == 0 ? 1 : 0].getSelectedItem();
            if (!(object2 instanceof PortModel)) return n2;
            PortModel portModel = (PortModel)object2;
            ModuleModel moduleModel2 = (ModuleModel)portModel.getModuleModel();
            boolean bl2 = moduleModel2.getEqType() == 127 || moduleModel2.getEqType() == 128 || moduleModel2.getEqType() == 129 || moduleModel2.getEqType() == 240 || moduleModel2.getEqType() == 130 || moduleModel2.getEqType() == 239 || moduleModel2.getEqType() == 196 || moduleModel2.getEqType() == 249;
            Integer n3 = moduleModel2.getEqType() != moduleModel.getEqType() && !bl2 ? this.getNextMux(opticsPortModel, this.getNextOpticsCardPool(moduleModel, moduleModel2)) : new Integer(this.getIdByDir(this.getPortDir(opticsPortModel), opticsPortModel.getEntityIndex()));
            if (n3 == 0) throw new Exception("bidi board problem");
            return n3;
        }
        PortModel portModel = (PortModel)object;
        return portModel.getEntityIndex();
    }

    private int getIdByDir(int n, int n2) {
        if (n == 1) {
            ++n2;
        } else if (n == 2) {
            --n2;
        }
        return n2;
    }

    private int[] getNextOpticsCardPool(ModuleModel moduleModel, ModuleModel moduleModel2) {
        int n = moduleModel.getEqType();
        int n2 = moduleModel2.getEqType();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        bl = n == 131 || n == 191 || n == 242;
        bl2 = n == 132 || n == 192 || n == 241;
        bl3 = this.isTrunkCard(n);
        bl4 = n2 == 131 || n2 == 191 || n2 == 242;
        bl5 = n2 == 132 || n2 == 192 || n2 == 241;
        bl6 = this.isTrunkCard(n2);
        if (bl3 && bl4 || bl && bl6) {
            return new int[]{132, 192, 241};
        }
        if (bl && bl5) {
            return new int[]{132, 192, 241};
        }
        if (bl2 && bl4) {
            return new int[]{131, 191, 242};
        }
        if (bl2 && bl6) {
            return new int[]{131, 191, 242};
        }
        if (n != n2) {
            return new int[]{n};
        }
        return new int[0];
    }

    private Integer getNextMux(PortModel portModel, int[] nArray) {
        boolean bl = false;
        boolean bl2 = false;
        IEntityModel[] iEntityModelArray = this.nodeModel.getChassisModels();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        EntityModel entityModel = null;
        List list = null;
        List list2 = null;
        block2: for (int i = 0; i < iEntityModelArray.length; ++i) {
            entityModel = (EntityModel)iEntityModelArray[i];
            list = entityModel.getChildrenOfType(eClass.BACKPLANE);
            list2 = ((EntityModel)list.get(0)).getChildren();
            for (int j = 0; j < list2.size(); ++j) {
                Object e;
                EntityModel entityModel2 = (EntityModel)list2.get(j);
                List list3 = entityModel2.getChildren();
                if (list3.size() > 0 && (e = list3.get(0)) instanceof ModuleModel) {
                    int n = ((ModuleModel)e).getEqType();
                    for (int k = 0; k < nArray.length; ++k) {
                        if (n != nArray[k]) continue;
                        List list4 = ((ModuleModel)e).getChildren();
                        Iterator iterator = list4.iterator();
                        while (iterator.hasNext()) {
                            OpticsPortModel opticsPortModel = (OpticsPortModel)iterator.next();
                            try {
                                if (opticsPortModel.getOpticsLineModel().getOptDirection() == ((OpticsPortModel)portModel).getOpticsLineModel().getOptDirection()) {
                                    bl2 = true;
                                    break;
                                }
                                if (opticsPortModel.getPort() != portModel.getPort()) continue;
                                if (!this.haveSameDir(opticsPortModel.getEntityIndex(), portModel.getEntityIndex())) {
                                    arrayList.add(new Integer(opticsPortModel.getEntityIndex()));
                                } else {
                                    arrayList.add(new Integer(this.getOppositeDir(opticsPortModel.getEntityIndex())));
                                }
                                bl = true;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                        if (bl2) break;
                    }
                }
                if (bl) continue block2;
            }
        }
        if (arrayList.size() > 1 || arrayList.size() == 0) {
            return null;
        }
        return (Integer)arrayList.get(0);
    }

    private boolean haveSameDir(int n, int n2) {
        return n % 2 > 0 && n2 % 2 > 0;
    }

    private int getOppositeDir(int n) {
        if (n % 2 > 0) {
            return --n;
        }
        return ++n;
    }

    private int getMuxEntityId(OpticsPortModel opticsPortModel, EntityModel entityModel) {
        int n = ((PortModel)entityModel).getPort();
        List list = opticsPortModel.getChildren();
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                OpticsPortModel opticsPortModel2 = (OpticsPortModel)iterator.next();
                if (opticsPortModel2.getPort() != n) continue;
                return opticsPortModel2.getEntityIndex();
            }
        }
        return 0;
    }

    private boolean apply() {
        AnsConnDataSource ansConnDataSource = (AnsConnDataSource)this.dataModel.getDataSource();
        if (this.isedit) {
            ansConnDataSource.deleteLocalOptLink(this.from_edit, this.to_edit);
            ansConnDataSource.createDummyOptLink(this.getBoardIndex(1), this.getBoardIndex(0));
            return true;
        }
        if ((this.isWavelengthCard(0) || this.isWavelengthCard(1)) && this.testPreProv() && this.testWavelegth()) {
            CerentDialog.warningDialog((Component)this, (String)ErrorMsg.getString((EID)EMC.WID_OPTICAL_LINK_WAVE_NO_MATCH));
            return false;
        }
        ansConnDataSource.createDummyOptLink(this.getBoardIndex(1), this.getBoardIndex(0));
        if (this.bidiCheck.isSelected()) {
            try {
                ansConnDataSource.createDummyOptLink(this.getBidiBoardIndex(0), this.getBidiBoardIndex(1));
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_CREATE_BIDI_OPTICAL_LINK);
            }
        }
        return true;
    }

    private boolean testWavelegth() {
        int n;
        PortModel[] portModelArray = new PortModel[2];
        Object[] objectArray = new Object[2];
        for (n = 0; n <= 1; ++n) {
            objectArray[n] = this.portCB[n].getSelectedItem();
            if (!(objectArray[n] instanceof PortModel)) continue;
            portModelArray[n] = (PortModel)objectArray[n];
        }
        if (portModelArray[0] != null && portModelArray[1] != null) {
            try {
                n = AnsPathCreateDialog.getWlen(portModelArray[0]);
                int n2 = AnsPathCreateDialog.getWlen(portModelArray[1]);
                if (n == 173 || n2 == 173) {
                    return true;
                }
                if (n == 0 && n2 == 0) {
                    return true;
                }
                return n != 0 && n2 != 0 && n != n2;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private boolean testPreProv() {
        ModuleModel moduleModel = (ModuleModel)this.slotCB[0].getSelectedItem();
        ModuleModel moduleModel2 = (ModuleModel)this.slotCB[0].getSelectedItem();
        if (moduleModel != null && moduleModel2 != null) {
            return (!this.isITU_TCard(moduleModel.getEqType()) || !moduleModel.isPreProvisioned()) && (!this.isITU_TCard(moduleModel2.getEqType()) || !moduleModel2.isPreProvisioned());
        }
        return false;
    }

    private static int getWlen(PortModel portModel) throws NoSuchInterface, WrongInterfaceType {
        IOpticsChannelModel iOpticsChannelModel = (IOpticsChannelModel)portModel.getInterfaceModel();
        int n = iOpticsChannelModel.getActualWaveLength();
        if (n == 0) {
            if (db.on()) {
                db.println("Using expected wlen for local port");
            }
            n = iOpticsChannelModel.getExpectedWaveLength();
        } else if (db.on()) {
            db.println("Using expected wlen for local port");
        }
        return n;
    }

    private boolean isWavelengthCard(int n) {
        Object object = this.slotCB[n].getSelectedItem();
        if (object != null) {
            if (object instanceof ModuleModel) {
                switch (((ModuleModel)object).getEqType()) {
                    case 11: 
                    case 60: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 191: 
                    case 219: 
                    case 242: 
                    case 243: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean isOC48_oc192Port(int n) {
        switch (n) {
            case 30: 
            case 61: {
                return true;
            }
        }
        return false;
    }

    private boolean isITU_TCard(int n) {
        switch (n) {
            case 11: 
            case 60: {
                return true;
            }
        }
        return false;
    }

    private boolean isBidiWSS() {
        boolean bl = false;
        boolean bl2 = false;
        ModuleModel moduleModel = null;
        Object object = this.slotCB[0].getSelectedItem();
        Object object2 = this.slotCB[1].getSelectedItem();
        if (object instanceof ModuleModel && object2 instanceof ModuleModel) {
            moduleModel = (ModuleModel)object;
            bl = moduleModel.getEqType() == 191 || moduleModel.getEqType() == 242;
            moduleModel = (ModuleModel)object2;
            bl2 = moduleModel.getEqType() == 191 || moduleModel.getEqType() == 242;
        }
        return bl && bl2;
    }

    class OnsCardRenderer
    extends JLabel
    implements ListCellRenderer {
        public OnsCardRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ModuleModel moduleModel = null;
            ChassisModel chassisModel = null;
            String string = NA;
            if (object instanceof ModuleModel) {
                moduleModel = (ModuleModel)object;
                string = moduleModel.getSlot() + " " + EntityModel.eqType2Name(AnsPathCreateDialog.this.terms, moduleModel.getEqType());
            } else if (object instanceof ChassisModel) {
                chassisModel = (ChassisModel)object;
                string = new Integer(chassisModel.getShelfId()).toString();
            } else if (object instanceof String) {
                string = (String)object;
            }
            try {
                this.setText(string);
            }
            catch (Exception exception) {
                db.println("getListCellRendererComponent");
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

