/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.bbe;

import cerent.cms.model.BbeModuleModel;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MutablePortsProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.UnimplementedPane;
import cerent.cms.ui.ds3e.Ds3eProvPane;
import cerent.cms.ui.ec1.Ec1ProvPane;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.awt.Component;

public class BbeProvPane
extends AbstractSubTabbedPane
implements ITabName {
    public String DS3_E3_TAB_NAME = "DS3/E3";
    protected Ds123LineModel[] ds3Lines;
    protected Ds123LineModel[] ds3xmLines;
    protected TdmLineModel[] ec1Lines;
    private static final SDebug dbg = new SDebug("BbeProvPane");

    public BbeProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.ds3Lines = ds123LineModelArray;
        this.ds3xmLines = ds123LineModelArray2;
        this.ec1Lines = tdmLineModelArray;
        this.registerWithModel();
    }

    protected void createSubTabs() {
        boolean bl;
        BbeModuleModel bbeModuleModel;
        block4: {
            if (dbg.on()) {
                dbg.info("Creating SubTabs");
            }
            bbeModuleModel = (BbeModuleModel)this.getUiModel();
            bl = true;
            try {
                bl = Model.getFramingType(bbeModuleModel.getNodeModel()).isSonet();
                this.DS3_E3_TAB_NAME = bl ? "DS3" : "E3";
            }
            catch (AnnotatedException annotatedException) {
                dbg.println("Could not determine framingType for BbeProvPane!");
                if (!dbg.on()) break block4;
                SDebug.printStackTrace((Throwable)annotatedException);
            }
        }
        this.subTabs.addTab("Broadband Ports", (Component)this.getBbeTab(bbeModuleModel));
        this.subTabs.addTab(this.DS3_E3_TAB_NAME, (Component)this.getDs3Tab(this.ds3Lines));
        this.subTabs.addTab("DS3XM", (Component)this.getDs3xmTab(this.ds3xmLines));
        if (bl) {
            this.subTabs.addTab("EC1", (Component)this.getEc1Tab(bbeModuleModel, this.ec1Lines));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
    }

    private Pane getBbeTab(BbeModuleModel bbeModuleModel) {
        BbeSlot bbeSlot;
        IPortContainer[] iPortContainerArray;
        block2: {
            iPortContainerArray = null;
            bbeSlot = null;
            try {
                bbeSlot = bbeModuleModel.getBbeSlot();
                iPortContainerArray = new IPortContainer[]{bbeSlot};
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                iPortContainerArray = new IPortContainer[]{};
                if (!dbg.on()) break block2;
                dbg.println("Failed to retrieve BbeSlot");
            }
        }
        return new ProtCardDualPane(this.subTabs, bbeModuleModel, new MutablePortsProvPane("Broadband Ports", this.subTabs, iPortContainerArray, bbeSlot.getEqType(), false, CSHelpConst.BbePortProvPane, dbg));
    }

    private Pane getEc1Tab(BbeModuleModel bbeModuleModel, TdmLineModel[] tdmLineModelArray) {
        return new Ec1ProvPane("EC1", this.subTabs, tdmLineModelArray, false, true);
    }

    private Pane getDs3Tab(Ds123LineModel[] ds123LineModelArray) {
        return new Ds3eProvPane(this.DS3_E3_TAB_NAME, this.subTabs, ds123LineModelArray, false);
    }

    private Pane getDs3xmTab(Ds123LineModel[] ds123LineModelArray) {
        return new UnimplementedPane("DS3XM", this.subTabs);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ds3LineUpdate..");
            }
            this.ds3Lines = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else if (object instanceof Ec1LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ec1LineUpdate...");
            }
            this.ec1Lines = (TdmLineModel[])((Ec1LineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

