/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ctx;

import cerent.cms.model.BbeSlot;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CtxClModuleModel;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.ComboCardPmPane;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ctx.AbstractCtxCardTabbedView;
import cerent.cms.ui.ctx.CtxMaintPane;
import cerent.cms.ui.ctx.CtxProvPane;
import cerent.cms.ui.event.IEventPanelController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;

public class CtxClCardTabbedView
extends AbstractCtxCardTabbedView {
    private ArrayList ds3LinesList;
    private ArrayList ec1LinesList;
    private BbeSlot bbeSlot;
    private Ds123LineModel[] ds1Lines;
    private EnvAlarmModel[] alarmInputs;
    private EnvControlModel[] controlOutputs;

    public CtxClCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
    }

    protected void init() {
        super.init();
        CtxClModuleModel ctxClModuleModel = (CtxClModuleModel)this.getUiModel();
        Ds123LineModel[] ds123LineModelArray = ctxClModuleModel.getDs3Lines();
        this.ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(ds123LineModelArray));
        this.getOM().addObservable((Observable[])ds123LineModelArray);
        TdmLineModel[] tdmLineModelArray = ctxClModuleModel.getEc1Lines();
        this.ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray));
        this.getOM().addObservable((Observable[])tdmLineModelArray);
        try {
            this.bbeSlot = ctxClModuleModel.getBbeSlot();
            this.getOM().addObservable((Observable)((Object)this.bbeSlot));
            this.addContainers(new IPortContainer[]{this.bbeSlot});
        }
        catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
            this.bbeSlot = null;
        }
        this.ds1Lines = ctxClModuleModel.getDs1Lines();
        this.alarmInputs = ctxClModuleModel.getAlarmInput();
        this.controlOutputs = ctxClModuleModel.getControlOutput();
    }

    private Ds123LineModel[] getDs3LinesArray() {
        return this.ds3LinesList.toArray(new Ds123LineModel[this.ds3LinesList.size()]);
    }

    private TdmLineModel[] getEc1LinesArray() {
        return this.ec1LinesList.toArray(new TdmLineModel[this.ec1LinesList.size()]);
    }

    protected List addModel(Observable observable) {
        List list = super.addModel(observable);
        if (observable instanceof BbeSlot) {
            if (this.bbeSlot != null) {
                this.addContainers(new IPortContainer[]{this.bbeSlot});
            }
            CtxClModuleModel ctxClModuleModel = (CtxClModuleModel)this.getUiModel();
            IPortContainer iPortContainer = (IPortContainer)((Object)observable);
            Model[] modelArray = ctxClModuleModel.getDs3Lines();
            Model[] modelArray2 = ctxClModuleModel.getEc1Lines();
            if (modelArray.length > this.ds3LinesList.size()) {
                this.ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(modelArray));
                this.getOM().addObservable((Observable[])modelArray);
                list.add(new Ds3LineUpdate(modelArray, iPortContainer));
            } else if (modelArray2.length > this.ec1LinesList.size()) {
                this.ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(modelArray2));
                this.getOM().addObservable((Observable[])modelArray2);
                list.add(new Ec1LineUpdate(modelArray2, iPortContainer));
            }
        }
        return list;
    }

    protected List removeModel(Observable observable) {
        List list = super.removeModel(observable);
        if (observable instanceof IInterfaceModel) {
            IPortContainer iPortContainer = this.removeContainer((IInterfaceModel)observable);
            if (iPortContainer == null) {
                db.println("Could not get parent for removed model!");
            }
            if (this.ds3LinesList.remove(observable)) {
                list.add(new Ds3LineUpdate(this.getDs3LinesArray(), iPortContainer));
            } else if (this.ec1LinesList.remove(observable)) {
                list.add(new Ec1LineUpdate(this.getEc1LinesArray(), iPortContainer));
            } else if (this.ocnLinesList.remove(observable)) {
                list.add(new OcnLineUpdate(this.getOcnLinesArray(), iPortContainer));
            }
        }
        return list;
    }

    public Pane getMaintenanceTab() {
        return new CtxMaintPane("Maintenance", this, this.ds1Lines, this.getDs3LinesArray(), this.getEc1LinesArray(), this.getOcnLinesArray(), this.alarmInputs, this.controlOutputs);
    }

    public Pane getProvTab() {
        return new CtxProvPane("Provisioning", this, this.ds1Lines, this.getDs3LinesArray(), this.getEc1LinesArray(), this.getOcnLinesArray(), this.alarmInputs, this.controlOutputs);
    }

    public Pane getPerformanceTab() {
        return new ComboCardPmPane("Performance", this, this.ds1Lines, this.getDs3LinesArray(), this.getEc1LinesArray(), this.getOcnLinesArray());
    }

    public void destroy() {
        this.ds3LinesList.clear();
        this.ec1LinesList.clear();
        this.ds1Lines = null;
        this.alarmInputs = null;
        this.controlOutputs = null;
        super.destroy();
    }
}

