/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Ds123Media.sNetworkPmPathThresholds;
import cerent.cms.idl.Ds123Media.sThresholds;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ds123.Ds123PathThresholdsTableModel;
import cerent.util.SDebug;

public class Ds1FePathPmThresholdsTableModel
extends Ds123PathThresholdsTableModel {
    protected sNetworkPmPathThresholds[] nthresholdsVal;
    public static final int ESNE_INDEX = 14;
    public static final int ESFE_INDEX = 15;
    public static final int SESNE_INDEX = 16;
    public static final int SESFE_INDEX = 17;
    public static final int UASNE_INDEX = 18;
    public static final int UASFE_INDEX = 19;
    private static final SDebug db = new SDebug("Ds1FePmPathThresholdsTableModel");

    public Ds1FePathPmThresholdsTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray, eThresholdType eThresholdType2, boolean bl) {
        super(iNodeModel, ds123LineModelArray, 10, eThresholdType2, bl);
    }

    protected String[] getCompleteColumns(String[] stringArray) {
        String[] stringArray2 = new String[]{"ESNE", "ESFE", "SESNE", "SESFE", "UASNE", "UASFE"};
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    protected void init() {
        this.myPortRenderer = new EntityCellRenderer(true);
        this.numLines = this.model.length;
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sThresholds[this.numLines];
        this.nthresholdsVal = new sNetworkPmPathThresholds[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
            this.thresholdsVal[i] = null;
            this.nthresholdsVal[i] = null;
        }
    }

    protected void refreshPmThresholds(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.nthresholdsVal[n] == null) {
            this.nthresholdsVal[n] = this.model[n].getNetworkPmPathThresholds(this.thresholdType);
        }
        super.refreshPmThresholds(n);
    }

    protected int getEsne(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.nthresholdsVal[n].esne;
    }

    protected int getSesne(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.nthresholdsVal[n].sesne;
    }

    protected int getUasne(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.nthresholdsVal[n].uasne;
    }

    protected int getEsfe(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.nthresholdsVal[n].esfe;
    }

    protected int getSesfe(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.nthresholdsVal[n].sesfe;
    }

    protected int getUasfe(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.nthresholdsVal[n].uasfe;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                Exception exception = new Exception();
                db.println("Error in setValueAt");
                SDebug.printStackTrace((Throwable)exception);
                return;
            }
            switch (n2) {
                case 1: {
                    this.thresholdsVal[n].cv = n3;
                    break;
                }
                case 2: {
                    this.thresholdsVal[n].es = n3;
                    break;
                }
                case 3: {
                    this.thresholdsVal[n].ses = n3;
                    break;
                }
                case 4: {
                    this.thresholdsVal[n].loss = n3;
                    break;
                }
                case 5: {
                    this.thresholdsVal[n].sas = n3;
                    break;
                }
                case 6: {
                    this.thresholdsVal[n].ais = n3;
                    break;
                }
                case 7: {
                    this.thresholdsVal[n].uas = n3;
                    break;
                }
                case 8: {
                    this.thresholdsVal[n].bbe = n3;
                    break;
                }
                case 9: {
                    this.thresholdsVal[n].css = n3;
                    break;
                }
                case 10: {
                    this.thresholdsVal[n].esa = n3;
                    break;
                }
                case 11: {
                    this.thresholdsVal[n].esb = n3;
                    break;
                }
                case 12: {
                    this.thresholdsVal[n].sefs = n3;
                    break;
                }
                case 13: {
                    this.thresholdsVal[n].fc = n3;
                    break;
                }
                case 14: {
                    this.nthresholdsVal[n].esne = n3;
                    break;
                }
                case 15: {
                    this.nthresholdsVal[n].esfe = n3;
                    break;
                }
                case 16: {
                    this.nthresholdsVal[n].sesne = n3;
                    break;
                }
                case 17: {
                    this.nthresholdsVal[n].sesfe = n3;
                    break;
                }
                case 18: {
                    this.nthresholdsVal[n].uasne = n3;
                    break;
                }
                case 19: {
                    this.nthresholdsVal[n].uasfe = n3;
                    break;
                }
            }
            if (db.on()) {
                db.println("marking row dirty");
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            db.println("NumberFormatException caught in setValueAt");
            SDebug.printStackTrace((Throwable)numberFormatException);
        }
    }

    public sNetworkPmPathThresholds getNetworkPmPathThresholdsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.nthresholdsVal[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 14: {
                    return new Integer(this.getEsne(n));
                }
                case 15: {
                    return new Integer(this.getEsfe(n));
                }
                case 16: {
                    return new Integer(this.getSesne(n));
                }
                case 17: {
                    return new Integer(this.getSesfe(n));
                }
                case 18: {
                    return new Integer(this.getUasne(n));
                }
                case 19: {
                    return new Integer(this.getUasfe(n));
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            db.println("Error in getValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void refreshLineFromModel(int n) {
        this.nthresholdsVal[n] = null;
        super.refreshLineFromModel(n);
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.nthresholdsVal[i] = null;
        }
        super.refreshFromModel();
    }
}

