/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1;

import cerent.cms.IPlatform;
import cerent.cms.idl.Ds123Media.eDs1Mapping;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1LineTableModel;
import cerent.cms.ui.ds123.Ds123LineProvPane;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import java.util.NoSuchElementException;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableColumn;

public class Ds1LineProvPane
extends Ds123LineProvPane {
    public Ds1LineProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, CSHelpID cSHelpID) {
        super(string, tabbedView, ds123LineModelArray, cSHelpID);
        IPlatform iPlatform = ((ModuleModel)this.getUiModel()).getNodeModelDelegate().getPlatform();
        int n = ((ModuleModel)this.getUiModel()).getEqType();
        Attribute[] attributeArray = null;
        TableColumn tableColumn = null;
        if (!iPlatform.supportsDs1Timing(n)) {
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[16]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[17]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[18]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[19]);
            this.table.removeColumn(tableColumn);
        } else if (n == 234) {
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[19]);
            this.table.removeColumn(tableColumn);
        }
        tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[20]);
        if (!iPlatform.supportsDs1SyncAsync(n)) {
            this.table.removeColumn(tableColumn);
        } else {
            try {
                attributeArray = this.getAttributeArray(eDs1Mapping.class);
            }
            catch (NoSuchElementException noSuchElementException) {
                attributeArray = null;
                this.table.removeColumn(tableColumn);
            }
            if (attributeArray != null) {
                tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
                tableColumn.sizeWidthToFit();
            }
        }
        if (!iPlatform.supportsCompleteDs1E1TimingOptions(n)) {
            block13: {
                tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[22]);
                if (!iPlatform.supportsCompleteDs1TimingOptions(n)) {
                    this.table.removeColumn(tableColumn);
                } else {
                    try {
                        attributeArray = this.getSelectableSSMAttributes();
                        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        attributeArray = null;
                        this.table.removeColumn(tableColumn);
                        if (!db.on()) break block13;
                        db.println("No Such Element Exception when getting Slectable SSM attributes" + noSuchElementException);
                    }
                }
            }
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[21]);
            this.table.removeColumn(tableColumn);
        }
    }

    protected Ds123LineTableModel getDataModel(Ds123LineModel[] ds123LineModelArray) {
        return new Ds1LineTableModel(this.node, ds123LineModelArray);
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        String string = "DS1_LINE_CARD";
        return this.getAttributeMap().getAttributeArray(string + "." + clazz.getName());
    }

    protected Attribute[] getAttributeArray(String string) {
        String string2 = "DS1_LINE_CARD";
        return this.getAttributeMap().getAttributeArray(string2 + "." + string);
    }

    private void handleSyncConfig(int n) throws Exception {
        if (this.dataModel.isDirty(n, 17) || this.dataModel.isDirty(n, 18) || this.dataModel.isDirty(n, 22)) {
            ((Ds1LineModel)this.lineModels[n]).setSyncConfig(((Ds1LineTableModel)this.dataModel).getSyncConfig(n));
        }
    }

    protected void applyToLine(int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = this.dataModel.isDirty(n, 17) && !((Ds1LineTableModel)this.dataModel).getSyncConfig((int)n).syncMessageIn;
        if (bl) {
            this.handleSyncConfig(n);
            super.applyToLine(n);
        } else {
            super.applyToLine(n);
            this.handleSyncConfig(n);
        }
        if (this.dataModel.isDirty(n, 19)) {
            ((Ds1LineModel)this.lineModels[n]).setDs1RetimingEnabled(((Ds1LineTableModel)this.dataModel).getRetimingEnabled(n));
        }
        if (this.dataModel.isDirty(n, 20)) {
            ((Ds1LineModel)this.lineModels[n]).setDs1Mapping(eDs1Mapping.from_int(((Ds1LineTableModel)this.dataModel).getDs1Mapping(n).getValue()));
        }
        if (this.dataModel.isDirty(n, 21)) {
            ((Ds1LineModel)this.lineModels[n]).setE1SaBit(eSaBit.from_int(((Ds1LineTableModel)this.dataModel).getE1SaBit(n).getValue()));
        }
    }

    protected boolean needToRemoveAutoProvision() {
        return !this.pci.supportsDs1AutoProvision();
    }

    protected boolean needToRemoveDetectedLineType() {
        return !this.pci.supportsDs1DetectedLineType();
    }

    protected Attribute[] getDetectedAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS1_LINE_CARD." + clazz.getName() + ".detected");
    }

    protected Attribute[] getDetectedAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray("DS1_LINE_CARD." + string + ".detected");
    }

    protected Attribute[] getSelectableSSMAttributes() {
        return this.getAttributeMap().getAttributeArray("timingSonetSsmQuality");
    }
}

