/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds123;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Ds123Media.sThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractValidatingTableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class Ds123PmThresholdsTableModel
extends AbstractValidatingTableModel {
    protected TDMTerminology terms;
    protected Ds123LineModel[] model;
    protected boolean[] rowDirty;
    protected sThresholds[] thresholdsVal;
    protected eThresholdType thresholdType;
    protected int numLines;
    protected int numCols;
    protected boolean nearEnd;
    protected EntityCellRenderer myPortRenderer;
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int ES_INDEX = 2;
    public static final int SES_INDEX = 3;
    public static final int LOSS_INDEX = 4;
    public static final int SAS_INDEX = 5;
    public static final int AIS_INDEX = 6;
    public static final int UAS_INDEX = 7;
    public static final int BBE_INDEX = 8;
    public static final int CSS_INDEX = 9;
    public static final int ESA_INDEX = 10;
    public static final int ESB_INDEX = 11;
    public static final int SEFS_INDEX = 12;
    public static final int FC_INDEX = 13;
    public String[] columnNames;
    protected int pmType;
    private static final SDebug db = new SDebug("Ds123PmThresholdsTableModel");

    public Ds123PmThresholdsTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray, int n, eThresholdType eThresholdType2, boolean bl) {
        super((NodeModelDelegate)iNodeModel, db);
        this.terms = iNodeModel.getTDMTerminology();
        String[] stringArray = new String[]{"Port ", this.terms.getPmStat(1), "ES", "SES", "LOSS", "SAS", "AISS", "UAS", "BBE", "CSS", "ESA", "ESB", "SEFS", "FC"};
        this.columnNames = this.getCompleteColumns(stringArray);
        this.numCols = this.columnNames.length;
        this.model = ds123LineModelArray;
        this.pmType = n;
        this.nearEnd = bl;
        this.thresholdType = eThresholdType2;
        if (this.model == null) {
            if (db.on()) {
                db.println("Model null");
            }
            this.numLines = 0;
            return;
        }
        this.numLines = this.model.length;
        this.init();
    }

    public Ds123PmThresholdsTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray, eThresholdType eThresholdType2, boolean bl) {
        this(iNodeModel, ds123LineModelArray, -1, eThresholdType2, false);
    }

    public Ds123PmThresholdsTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray, eThresholdType eThresholdType2) {
        this(iNodeModel, ds123LineModelArray, eThresholdType2, true);
    }

    protected String[] getCompleteColumns(String[] stringArray) {
        return stringArray;
    }

    protected void init() {
        this.myPortRenderer = new EntityCellRenderer(true);
        this.numLines = this.model.length;
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sThresholds[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
            this.thresholdsVal[i] = null;
        }
    }

    protected void refreshPmThresholds(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.thresholdsVal[n] == null) {
            this.thresholdsVal[n] = this.model[n].getPmThresholds(this.nearEnd, this.thresholdType);
        }
    }

    protected int getEs(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].es;
    }

    protected int getCv(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].cv;
    }

    protected int getSes(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].ses;
    }

    protected int getLoss(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].loss;
    }

    protected int getSas(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].sas;
    }

    protected int getAis(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].ais;
    }

    protected int getUas(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].uas;
    }

    protected int getBbe(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].bbe;
    }

    protected int getCss(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].css;
    }

    protected int getEsa(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].esa;
    }

    protected int getEsb(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].esb;
    }

    protected int getSefs(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].sefs;
    }

    protected int getFc(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].fc;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Integer.class;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            this.validatePmThresholds(this.pmType, (InterfaceModel)this.model[n], this.thresholdType, this.nearEnd, this.getColumnName(n2), object.toString());
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                Exception exception = new Exception();
                db.println("Error in setValueAt");
                SDebug.printStackTrace((Throwable)exception);
                return;
            }
            switch (n2) {
                case 1: {
                    this.thresholdsVal[n].cv = n3;
                    break;
                }
                case 2: {
                    this.thresholdsVal[n].es = n3;
                    break;
                }
                case 3: {
                    this.thresholdsVal[n].ses = n3;
                    break;
                }
                case 4: {
                    this.thresholdsVal[n].loss = n3;
                    break;
                }
                case 5: {
                    this.thresholdsVal[n].sas = n3;
                    break;
                }
                case 6: {
                    this.thresholdsVal[n].ais = n3;
                    break;
                }
                case 7: {
                    this.thresholdsVal[n].uas = n3;
                    break;
                }
                case 8: {
                    this.thresholdsVal[n].bbe = n3;
                    break;
                }
                case 9: {
                    this.thresholdsVal[n].css = n3;
                    break;
                }
                case 10: {
                    this.thresholdsVal[n].esa = n3;
                    break;
                }
                case 11: {
                    this.thresholdsVal[n].esb = n3;
                    break;
                }
                case 12: {
                    this.thresholdsVal[n].sefs = n3;
                    break;
                }
                case 13: {
                    this.thresholdsVal[n].fc = n3;
                    break;
                }
            }
            if (db.on()) {
                db.println("marking row dirty");
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            db.severe("NumberFormatException caught in setValueAt");
            SDebug.printStackTrace((Throwable)numberFormatException);
        }
        catch (ProvisionError provisionError) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
        catch (Exception exception) {
            db.severe("Error in setValueAt " + exception);
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.numCols;
    }

    public sThresholds getThresholdsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.thresholdsVal[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("isCellEditable caught: " + (Object)((Object)abstractCmsNoSuchEntityException));
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.getCv(n));
                }
                case 2: {
                    return new Integer(this.getEs(n));
                }
                case 3: {
                    return new Integer(this.getSes(n));
                }
                case 4: {
                    return new Integer(this.getLoss(n));
                }
                case 5: {
                    return new Integer(this.getSas(n));
                }
                case 6: {
                    return new Integer(this.getAis(n));
                }
                case 7: {
                    return new Integer(this.getUas(n));
                }
                case 8: {
                    return new Integer(this.getBbe(n));
                }
                case 9: {
                    return new Integer(this.getCss(n));
                }
                case 10: {
                    return new Integer(this.getEsa(n));
                }
                case 11: {
                    return new Integer(this.getEsb(n));
                }
                case 12: {
                    return new Integer(this.getSefs(n));
                }
                case 13: {
                    return new Integer(this.getFc(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void refreshMyLines(Ds123LineModel[] ds123LineModelArray) {
        this.model = ds123LineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void refreshLineFromModel(int n) {
        if (db.on()) {
            db.println("Refreshing line from model");
        }
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.thresholdsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        if (db.on()) {
            db.println("Row dirty for " + n + " is " + this.rowDirty[n]);
        }
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        if (db.on()) {
            db.println("resetting dirty bits");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }
}

