/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1e1;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eCardTransportMode;
import cerent.cms.idl.Equipment.ePortToVtMappingMode;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds1ModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModuleModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class Ds1E1CardProvTableModel
extends AbstractTableModel {
    public static final String[] columnNames = new String[]{"Transport Mode", "Operating Mode", "Retiming Enabled", "Port To VT Mapping"};
    public static final String SONET_TRANSPORT_MODE = "Sonet";
    public static final String AU4_TRANSPORT_MODE = "AU4";
    public static final String ALL_DS1_OPER_MODE = "All DS1";
    public static final String ALL_E1_OPER_MODE = "All E1";
    public static final String GR253_MODE = "GR 253";
    public static final String INDUSTRY_MODE = "INDUSTRY";
    public String[] transportModeStrings = new String[]{"Sonet", "AU4"};
    public String[] operModeStrings = new String[]{"All DS1", "All E1"};
    public String[] portToVtMappingStrings = new String[]{"GR 253", "INDUSTRY"};
    public static final int TRANSPORT_MODE_INDEX = 0;
    public static final int OPER_MODE_INDEX = 1;
    public static final int RETIMING_ENABLED_INDEX = 2;
    public static final int PORT_TO_VT_MAPPING_INDEX = 3;
    private int transportMode = 0;
    private int newTransportMode = 0;
    private int operMode = 0;
    private int newOperMode = 0;
    private int portToVtMappingMode = 0;
    private int newPortToVtMappingMode = 0;
    private boolean retimingEnabled = false;
    private boolean newRetimingEnabled = false;
    private boolean isDirtyTM;
    private boolean isDirtyOM;
    private boolean isDirtyRE;
    private boolean isDirtyPV;
    protected int numLines = 1;
    protected Ds1ModuleModel eqpmtModel;
    protected Ds1ModuleModel model;
    private static final SDebug db = new SDebug("Ds1E1CardProvTableModel");

    public Ds1E1CardProvTableModel(ModuleModel moduleModel, int n) {
        this.model = (Ds1ModuleModel)moduleModel;
        this.eqpmtModel = (Ds1ModuleModel)moduleModel;
        this.transportMode = 0;
        this.operMode = 0;
        this.retimingEnabled = false;
        this.isDirtyTM = false;
        this.isDirtyOM = false;
        this.isDirtyRE = false;
        this.isDirtyPV = false;
    }

    public int getRowCount() {
        return 1;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 0 && (n2 != 2 || this.model.getCardOperMode() != eCardOperMode.OPER_MODE_DS1E1_DS1_ONLY);
    }

    public boolean isDirty(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.isDirtyTM;
            }
            case 1: {
                return this.isDirtyOM;
            }
            case 2: {
                return this.isDirtyRE;
            }
            case 3: {
                return this.isDirtyPV;
            }
        }
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.isDirty();
    }

    public boolean isDirty() {
        return this.isDirtyTM || this.isDirtyOM || this.isDirtyRE || this.isDirtyPV;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    int n3 = this.getCardTransportMode();
                    return this.transportModeStrings[n3];
                }
                case 1: {
                    int n4 = this.getCardOperMode();
                    return this.operModeStrings[n4];
                }
                case 2: {
                    return new Boolean(this.getCardRetimingEnabled());
                }
                case 3: {
                    int n5 = this.getCardPortToVtMappingMode();
                    return this.portToVtMappingStrings[n5];
                }
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            SDebug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        try {
            switch (n2) {
                case 0: {
                    this.transportMode = this.newTransportMode = this.getIndexOf((String)object, this.transportModeStrings);
                    this.isDirtyTM = true;
                    break;
                }
                case 1: {
                    this.operMode = this.newOperMode = this.getIndexOf((String)object, this.operModeStrings);
                    this.isDirtyOM = true;
                    break;
                }
                case 2: {
                    this.retimingEnabled = this.newRetimingEnabled = ((Boolean)object).booleanValue();
                    this.isDirtyRE = true;
                    break;
                }
                case 3: {
                    this.portToVtMappingMode = this.newPortToVtMappingMode = this.getIndexOf((String)object, this.portToVtMappingStrings);
                    this.isDirtyPV = true;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.fireTableCellUpdated(n, n2);
    }

    public int getCardPortToVtMappingMode() {
        if (this.isDirtyPV) {
            return this.portToVtMappingMode;
        }
        ePortToVtMappingMode ePortToVtMappingMode2 = this.model.getPortToVtMappingMode();
        if (ePortToVtMappingMode2 == ePortToVtMappingMode.PORT_VT_MAPPING_INDUSTRY) {
            return 1;
        }
        return 0;
    }

    public int getCardTransportMode() {
        if (this.isDirtyTM) {
            return this.transportMode;
        }
        eCardTransportMode eCardTransportMode2 = this.model.getCardTransportMode();
        if (eCardTransportMode2 == eCardTransportMode.TRANSPORT_MODE_AU4) {
            return 1;
        }
        return 0;
    }

    public int getCardOperMode() {
        if (this.isDirtyOM) {
            return this.operMode;
        }
        eCardOperMode eCardOperMode2 = this.model.getCardOperMode();
        if (eCardOperMode2 == eCardOperMode.OPER_MODE_DS1E1_E1_ONLY) {
            return 1;
        }
        return 0;
    }

    public boolean getCardRetimingEnabled() {
        if (this.isDirtyRE) {
            return this.retimingEnabled;
        }
        return this.model.getCardRetimingEnabled();
    }

    public void setCardPortToVtMappingMode(ePortToVtMappingMode ePortToVtMappingMode2) {
        try {
            this.model.setPortToVtMappingMode(ePortToVtMappingMode2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCardOperMode(eCardOperMode eCardOperMode2) {
        try {
            this.model.setCardOperMode(eCardOperMode2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCardRetimingEnabled(boolean bl) {
        try {
            this.model.setCardRetimingEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCardTransportMode(eCardTransportMode eCardTransportMode2) {
        try {
            this.model.setCardTransportMode(eCardTransportMode2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private int unsignedShortToInt(short s) {
        int n = s & 0xFFFF;
        return n;
    }

    public void refreshFromModel() throws Exception {
        this.refreshLineFromModel(0);
    }

    public void refreshLineFromModel(int n) {
        this.portToVtMappingMode = -1;
        this.transportMode = -1;
        this.operMode = -1;
        this.retimingEnabled = false;
        this.isDirtyTM = false;
        this.isDirtyOM = false;
        this.isDirtyRE = false;
        this.isDirtyPV = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws Exception {
        if (db.on()) {
            db.println("applyToModel");
        }
        try {
            if (this.isDirtyTM) {
                if (this.transportMode == 1) {
                    this.model.setCardTransportMode(eCardTransportMode.TRANSPORT_MODE_AU4);
                } else {
                    this.model.setCardTransportMode(eCardTransportMode.TRANSPORT_MODE_SONET);
                }
                this.isDirtyTM = false;
            }
            if (this.isDirtyOM) {
                if (this.operMode == 1) {
                    this.model.setCardOperMode(eCardOperMode.OPER_MODE_DS1E1_E1_ONLY);
                } else {
                    this.model.setCardOperMode(eCardOperMode.OPER_MODE_DS1E1_DS1_ONLY);
                }
                this.isDirtyOM = false;
            }
            if (this.isDirtyRE) {
                this.model.setCardRetimingEnabled(this.retimingEnabled);
                this.isDirtyRE = false;
            }
            if (this.isDirtyPV) {
                if (this.portToVtMappingMode == 1) {
                    this.model.setPortToVtMappingMode(ePortToVtMappingMode.PORT_VT_MAPPING_INDUSTRY);
                } else {
                    this.model.setPortToVtMappingMode(ePortToVtMappingMode.PORT_VT_MAPPING_GR253);
                }
                this.isDirtyPV = false;
            }
            this.refreshLineFromModel(0);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("Error applying changes to row 1 ", exception);
        }
    }

    protected Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string, n);
    }
}

