/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1e1;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ds123.Ds123PathThresholdsPane;
import cerent.cms.ui.ds1e1.Ds1E1FePathThresholdsPane;
import cerent.cms.ui.ds1e1.Ds1E1PathThresholdsPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class Ds1E1PathPmThresholdsPane
extends AbstractPane {
    protected Ds123LineModel[] models = null;
    protected Ds1ThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected eCardOperMode operMode;
    public static final int FE_ONE_DAY = 3;
    public static final int FE_MIN_15 = 2;
    public static final int NE_ONE_DAY = 1;
    public static final int NE_MIN_15 = 0;
    public static final String FE_ONE_DAY_PANEL = "Far End 1Day";
    public static final String FE_MIN_15_PANEL = "Far End 15Min";
    public static final String NE_ONE_DAY_PANEL = "Near End 1Day";
    public static final String NE_MIN_15_PANEL = "Near End 15Min";
    private CSHelpID helpID = null;
    private static final SDebug db = new SDebug("Pane.Ds1PathPmThresholdPane");

    public Ds1E1PathPmThresholdsPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, CSHelpID cSHelpID) {
        super(string, tabbedView);
        this.models = ds123LineModelArray;
        this.helpID = cSHelpID;
        this.operMode = ((ModuleModel)this.getUiModel()).getCardOperMode();
        this.panes = new Pane[4];
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "North");
        this.add(this.getTablePanel(), "Center");
    }

    protected Ds1ThresholdButtonPanel getButtonPanel() {
        this.buttonPanel = new Ds1ThresholdButtonPanel(this.isDs1Mode());
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.panes[3] = this.getDs1PathPmThresholdsPane(FE_ONE_DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, false, this.helpID);
        this.tablePanel.add((Component)this.panes[3], FE_ONE_DAY_PANEL);
        this.panes[2] = this.getDs1PathPmThresholdsPane(FE_MIN_15_PANEL, eThresholdType.THRESHOLD_15_MIN, false, this.helpID);
        this.tablePanel.add((Component)this.panes[2], FE_MIN_15_PANEL);
        this.panes[1] = this.getDs1PathPmThresholdsPane(NE_ONE_DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, true, this.helpID);
        this.tablePanel.add((Component)this.panes[1], NE_ONE_DAY_PANEL);
        this.panes[0] = this.getDs1PathPmThresholdsPane(NE_MIN_15_PANEL, eThresholdType.THRESHOLD_15_MIN, true, this.helpID);
        this.tablePanel.add((Component)this.panes[0], NE_MIN_15_PANEL);
        this.cl.show(this.tablePanel, NE_MIN_15_PANEL);
        this.currentPane = this.panes[0];
        return this.tablePanel;
    }

    protected Ds123PathThresholdsPane getDs1PathPmThresholdsPane(String string, eThresholdType eThresholdType2, boolean bl, CSHelpID cSHelpID) {
        if (bl) {
            return new Ds1E1PathThresholdsPane(string, this.getParentView(), this.models, eThresholdType2, bl, cSHelpID);
        }
        return new Ds1E1FePathThresholdsPane(string, this.getParentView(), this.models, eThresholdType2, bl, cSHelpID);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        eCardOperMode eCardOperMode2 = ((ModuleModel)this.getUiModel()).getCardOperMode();
        if (eCardOperMode2 != this.operMode) {
            this.operMode = eCardOperMode2;
            boolean bl = this.isDs1Mode();
            this.buttonPanel.buttonNE.setSelected(!bl);
            this.buttonPanel.buttonFE.setEnabled(bl);
            this.buttonPanel.button15Min.setSelected(true);
            this.currentPane = this.panes[0];
            this.showPanel(this.currentPane);
        }
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        int n;
        for (n = 0; n < this.panes.length; ++n) {
            TablePropertyMgr.setColumnPrefs(this.panes[n].getTable(), ((Object)((Object)this)).getClass().getName() + this.panes[n].getName());
        }
        for (n = 0; n < this.panes.length; ++n) {
            TablePropertyMgr.setColumnPrefs(this.panes[n].getTable(), ((Object)((Object)this)).getClass().getName() + this.panes[n].getName());
            this.panes[n].destroy();
            this.panes[n] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    public CSHelpID getHelpID() {
        if (this.currentPane != null && this.currentPane instanceof AbstractPane) {
            return ((AbstractPane)this.currentPane).getHelpID();
        }
        return null;
    }

    private boolean isDs1Mode() {
        switch (((ModuleModel)this.getUiModel()).getEqType()) {
            case 233: 
            case 234: {
                return true;
            }
        }
        return this.operMode == eCardOperMode.OPER_MODE_DS1E1_DS1_ONLY;
    }

    protected class Ds1ThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JButton showButton = new JButton("Show Thresholds");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup nefeButtonGroup;
        public boolean isDs1;

        public Ds1ThresholdButtonPanel(boolean bl) {
            this.isDs1 = bl;
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.buttonFE.setEnabled(this.isDs1);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.nefeButtonGroup = new ButtonGroup();
            this.nefeButtonGroup.add(this.buttonNE);
            this.nefeButtonGroup.add(this.buttonFE);
            this.showButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ds1ThresholdButtonPanel.this.refreshAction();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buttonNE, "North");
            jPanel.add((Component)this.buttonFE, "South");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 50));
        }

        protected void refreshAction() {
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (this.nefeButtonGroup.getSelection() == this.buttonNE.getModel()) {
                    Ds1E1PathPmThresholdsPane.this.showPanel(Ds1E1PathPmThresholdsPane.this.panes[1]);
                } else {
                    Ds1E1PathPmThresholdsPane.this.showPanel(Ds1E1PathPmThresholdsPane.this.panes[3]);
                }
            } else if (this.nefeButtonGroup.getSelection() == this.buttonNE.getModel()) {
                Ds1E1PathPmThresholdsPane.this.showPanel(Ds1E1PathPmThresholdsPane.this.panes[0]);
            } else {
                Ds1E1PathPmThresholdsPane.this.showPanel(Ds1E1PathPmThresholdsPane.this.panes[2]);
            }
        }
    }
}

