/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1e1;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.LoInfo;
import cerent.cms.ui.MuxIndex;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.ds1.Ds1PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.cms.ui.pm.PmLayerDs1Complete;
import java.util.ArrayList;

public class Ds1E1PmTableModel
extends Ds1PmTableModel {
    private static int TOTAL_DS1_MODE_VT_IN_STS = 28;
    private static int TOTAL_E1_MODE_VT_IN_STS = 21;

    public Ds1E1PmTableModel(InterfaceModel[] interfaceModelArray, NodeModelDelegate nodeModelDelegate) {
        super(interfaceModelArray, nodeModelDelegate);
    }

    protected PmLayer createPmLayerDs1Path(Ds123LineModel ds123LineModel) {
        return new PmLayerDs1Complete((PmTableModel)this, ds123LineModel, this.numRegisters);
    }

    protected synchronized ArrayList getItemList(NodeModelDelegate nodeModelDelegate, int n, int n2) {
        ArrayList<PmTableModel.Item> arrayList = new ArrayList<PmTableModel.Item>(10);
        ModuleModel moduleModel = null;
        boolean bl = true;
        if (this.lineModels.length > 0 && this.lineModels[0] != null) {
            try {
                moduleModel = this.lineModels[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
        if (moduleModel != null) {
            bl = moduleModel.getCardOperMode() == eCardOperMode.OPER_MODE_DS1E1_DS1_ONLY;
        }
        for (int i = n; i < this.layerCount(); ++i) {
            int n3;
            PmTableModel.Item item = new PmTableModel.Item();
            int n4 = this.choiceCount(i);
            String string = this.layerLabel(i) + ":";
            int n5 = nodeModelDelegate.getFramingType();
            item.label = string;
            item.layer = i;
            if (i == 0) {
                for (n3 = 0; n3 < n4; ++n3) {
                    item.contents.add(this.lineModels[n3]);
                }
            } else if (string.indexOf("VT") != -1) {
                for (n3 = 0; n3 < n4; ++n3) {
                    short s = (short)this.layerMuxIndex(i, n3);
                    short s2 = 0;
                    s2 = bl ? (short)((s - 1) % TOTAL_DS1_MODE_VT_IN_STS + 1) : (short)((s - 1) % TOTAL_E1_MODE_VT_IN_STS + 1);
                    item.contents.add(new LoInfo(n5, s2));
                }
            } else if (string.indexOf("STS") != -1) {
                if (bl) {
                    item.contents.add(new Integer(this.getCurChoice() / TOTAL_DS1_MODE_VT_IN_STS + 1));
                } else {
                    item.contents.add(new Integer(this.getCurChoice() / TOTAL_E1_MODE_VT_IN_STS + 1));
                }
            } else {
                for (n3 = 0; n3 < n4; ++n3) {
                    MuxIndex muxIndex = this.layerMux(i, n3);
                    item.contents.add(muxIndex);
                }
            }
            arrayList.add(item);
        }
        return arrayList;
    }
}

