/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1i;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import cerent.util.SDebug;

public class Ds1iLineTableModel
extends Ds123LineTableModel {
    private static final SDebug db = new SDebug("Ds1iLineTableModel");

    public Ds1iLineTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        super(iNodeModel, ds123LineModelArray);
    }

    public int getRangeFor(int n) {
        if (Ds1iLineTableModel.between(0, 131, n)) {
            return 131;
        }
        if (Ds1iLineTableModel.between(131, 262, n)) {
            return 262;
        }
        if (Ds1iLineTableModel.between(262, 393, n)) {
            return 393;
        }
        if (Ds1iLineTableModel.between(393, 524, n)) {
            return 524;
        }
        if (Ds1iLineTableModel.between(524, 655, n)) {
            return 655;
        }
        return 131;
    }

    protected Attribute getLineLengthAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("DS1I_LINE_CARD.Line Length", n);
    }

    protected Attribute getAttributeFor(Object object, int n) {
        return this.getAttributeMap().getAttributeForVal("DS1I_LINE_CARD." + object.getClass().getName(), n);
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model == null || this.numLines == 0) {
            return false;
        }
        try {
            if (!AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) || this.model[0].getModuleModel().isProtectModule()) {
                return false;
            }
            return n2 != 0 && n2 != 8;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("isCellEditable");
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return false;
        }
    }
}

