/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3ec1;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3Ec1ModuleModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.ComboCardMaintPane;
import cerent.cms.ui.ComboCardPmPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.ds3ec1.Ds3Ec1ProvPane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;

public class Ds3Ec1CardTabbedView
extends PluggableCardTabbedView
implements ITabName {
    private ArrayList _ds3LinesList;
    private ArrayList _ec1LinesList;
    private IPortContainer _bbeSlot;

    public Ds3Ec1CardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
    }

    protected void init() {
        int n;
        Ds3Ec1ModuleModel ds3Ec1ModuleModel = (Ds3Ec1ModuleModel)this.getUiModel();
        Ds123LineModel[] ds123LineModelArray = ds3Ec1ModuleModel.getDs3Lines();
        this._ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(ds123LineModelArray));
        this.getOM().addObservable((Observable[])ds123LineModelArray);
        int n2 = ds123LineModelArray.length;
        TdmLineModel[] tdmLineModelArray = ds3Ec1ModuleModel.getEc1Lines();
        this._ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray));
        this.getOM().addObservable((Observable[])tdmLineModelArray);
        int n3 = tdmLineModelArray.length;
        this._interfaceContainers = Collections.synchronizedMap(new HashMap(n3 + n2));
        for (n = 0; n < n2; ++n) {
            try {
                this._interfaceContainers.put(ds123LineModelArray[n], ds123LineModelArray[n].getPortModel().getParent());
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught NoSuchEntity in init!");
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        for (n = 0; n < n3; ++n) {
            try {
                this._interfaceContainers.put(tdmLineModelArray[n], tdmLineModelArray[n].getPortModel().getParent());
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught NoSuchEntity in init!");
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        this._bbeSlot = ds3Ec1ModuleModel.getBbeSlot();
        this.getOM().addObservable((Observable)((Object)this._bbeSlot));
        super.init();
    }

    private Ds123LineModel[] getDs3LinesArray() {
        return this._ds3LinesList.toArray(new Ds123LineModel[this._ds3LinesList.size()]);
    }

    private TdmLineModel[] getEc1LinesArray() {
        return this._ec1LinesList.toArray(new TdmLineModel[this._ec1LinesList.size()]);
    }

    protected List addModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList;
        block2: {
            Model[] modelArray;
            block3: {
                Ds3Ec1ModuleModel ds3Ec1ModuleModel = (Ds3Ec1ModuleModel)this.getUiModel();
                arrayList = new ArrayList<ModuleModelUpdate>();
                if (!(observable instanceof IPortContainer)) break block2;
                Model[] modelArray2 = ds3Ec1ModuleModel.getDs3Lines();
                modelArray = ds3Ec1ModuleModel.getEc1Lines();
                if (modelArray2.length <= this._ds3LinesList.size()) break block3;
                this._ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(modelArray2));
                this.getOM().addObservable((Observable[])modelArray2);
                arrayList.add(new Ds3LineUpdate(modelArray2, (IPortContainer)((Object)observable)));
                for (int i = 0; i < modelArray2.length; ++i) {
                    this._interfaceContainers.put(modelArray2[i], observable);
                }
                break block2;
            }
            if (modelArray.length <= this._ec1LinesList.size()) break block2;
            this._ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(modelArray));
            this.getOM().addObservable((Observable[])modelArray);
            arrayList.add(new Ec1LineUpdate(modelArray, (IPortContainer)((Object)observable)));
            for (int i = 0; i < modelArray.length; ++i) {
                this._interfaceContainers.put(modelArray[i], observable);
            }
        }
        return arrayList.size() > 0 ? arrayList : super.addModel(observable);
    }

    protected List removeModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        IPortContainer iPortContainer = (IPortContainer)this._interfaceContainers.get(observable);
        this._interfaceContainers.remove(observable);
        this.getOM().removeObservable(observable);
        if (observable instanceof Ds123LineModel && this._ds3LinesList.remove(observable)) {
            arrayList.add(new Ds3LineUpdate(this.getDs3LinesArray(), iPortContainer));
        } else if (observable instanceof TdmLineModel && this._ec1LinesList.remove(observable)) {
            arrayList.add(new Ec1LineUpdate(this.getEc1LinesArray(), iPortContainer));
        }
        return arrayList.size() > 0 ? arrayList : super.removeModel(observable);
    }

    public Pane getMaintenanceTab() {
        return new ComboCardMaintPane("Maintenance", this, this.getDs3LinesArray(), this.getEc1LinesArray());
    }

    public Pane getProvTab() {
        return new Ds3Ec1ProvPane("Provisioning", this, this.getDs3LinesArray(), this.getEc1LinesArray());
    }

    public Pane getPerformanceTab() {
        return new ComboCardPmPane("Performance", this, this.getDs3LinesArray(), this.getEc1LinesArray());
    }

    public void destroy() {
        this._ds3LinesList.clear();
        this._ec1LinesList.clear();
        super.destroy();
    }
}

