/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3ec1;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.Ds3Ec1ModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Ds3Ec1CardView
extends CardView {
    private static final int MAX_PER_ROW = 4;
    protected static final SDebug db = new SDebug("Ds3Ec1CardView");
    protected IPortContainer bbeSlot;
    protected ArrayList bbePortObsList;

    public Ds3Ec1CardView(ModuleModel moduleModel) {
        super(moduleModel);
        this.bbeSlot = ((Ds3Ec1ModuleModel)moduleModel).getBbeSlot();
        this.bbePortObsList = new ArrayList();
        this.registerForLocalUpdates();
    }

    private JLabel formatLabel(String string) {
        return AbstractShelfLayout.formatLabel(new JLabel(string));
    }

    private int[] getBbeTypes() {
        return new int[]{32, 31};
    }

    private boolean isa(EntityModel entityModel, int[] nArray) {
        int n = entityModel.getEqType();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private void addBbePorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        JPanel[] jPanelArray = null;
        IPortContainer iPortContainer = ((Ds3Ec1ModuleModel)this.model).getBbeSlot();
        jPanelArray = new JPanel[iPortContainer.getMaxPorts()];
        if (jPanelArray != null) {
            int n;
            int n2 = jPanelArray.length / 4;
            for (n = 0; n < this.numPorts; ++n) {
                EntityModel entityModel;
                Object e = this.portModels.get(n);
                if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
                this.ports[n] = new GenericPortGraphic(this, entityModel, entityModel.getPort());
                int n3 = entityModel.getPositionInParent();
                jPanelArray[n3 - 1] = this.ports[n];
            }
            for (n = 0; n < jPanelArray.length; ++n) {
                if (jPanelArray[n] == null) {
                    jPanelArray[n] = this.getPortSlotGraphic();
                }
                gridBagConstraints.gridx = n / n2;
                gridBagConstraints.gridy = n % n2;
                this.add((Component)jPanelArray[n], gridBagConstraints);
            }
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
    }

    protected void addPorts(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.addBbePorts(this.getBbeTypes(), gridBagConstraints);
        this.invalidate();
    }

    private JPanel getPortSlotGraphic() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel.setBackground(Color.lightGray);
        jPanel.setPreferredSize(new Dimension(16, 16));
        return jPanel;
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof EntityModel && this.model != null && this.model.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            if (db.on()) {
                db.println("update(): Ds3Ec1CardView, From=" + observable + ", arg=" + n);
            }
            if (n.equals(ModelUpdateType.ADDED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port DELETED");
                }
            } else if (n.equals(ModelUpdateType.CHANGED) && db.on()) {
                db.println("Port CHANGED");
            }
        }
    }

    protected void registerForLocalUpdates() {
        if (this.bbeSlot != null) {
            this.bbeSlot.addObserver(this);
            if (db.on()) {
                db.println("Registered BBE slot: " + this.bbeSlot);
            }
            List list = this.bbeSlot.getChildren();
            this.bbePortObsList = new ArrayList(list.size());
            PortModel portModel = null;
            for (int i = 0; i < list.size(); ++i) {
                portModel = (PortModel)list.get(i);
                if (portModel == null) continue;
                portModel.addObserver(this);
                this.bbePortObsList.add(portModel);
                if (!db.on()) continue;
                db.println("Registered BBE port: " + portModel);
            }
        }
    }

    protected void deregisterFromLocalUpdates() {
        if (this.bbeSlot != null) {
            this.bbeSlot.deleteObserver(this);
            if (db.on()) {
                db.println("Deregistered parent: " + this.bbeSlot);
            }
        }
        if (this.bbePortObsList != null) {
            PortModel portModel = null;
            ListIterator listIterator = this.bbePortObsList.listIterator();
            while (listIterator.hasNext()) {
                portModel = (PortModel)listIterator.next();
                if (portModel == null) continue;
                portModel.deleteObserver(this);
                listIterator.remove();
                if (!db.on()) continue;
                db.println("Deregistered Child: " + portModel);
            }
        }
    }

    protected void localDispose() {
        this.deregisterFromLocalUpdates();
        if (this.ports != null) {
            for (int i = 0; i < this.ports.length; ++i) {
                if (this.ports[i] == null) continue;
                this.ports[i].dispose();
                this.ports[i] = null;
            }
            this.ports = null;
        }
        this.removeAll();
    }

    static /* synthetic */ AbstractPortGraphic[] access$502(Ds3Ec1CardView ds3Ec1CardView, AbstractPortGraphic[] abstractPortGraphicArray) {
        ds3Ec1CardView.ports = abstractPortGraphicArray;
        return abstractPortGraphicArray;
    }

    protected class ReplacePort
    implements Runnable {
        protected ReplacePort() {
        }

        public void run() {
            block4: {
                try {
                    Ds3Ec1CardView.this.localDispose();
                    if (Ds3Ec1CardView.this.model != null) {
                        Ds3Ec1CardView.this.portModels = Ds3Ec1CardView.this.getPorts();
                        Ds3Ec1CardView.this.numPorts = Ds3Ec1CardView.this.portModels.size();
                        Ds3Ec1CardView.access$502(Ds3Ec1CardView.this, new AbstractPortGraphic[Ds3Ec1CardView.this.numPorts]);
                        Ds3Ec1CardView.this.addPorts(true);
                        Ds3Ec1CardView.this.registerForLocalUpdates();
                    }
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    db.println("Error replacing port: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            Ds3Ec1CardView.this.validate();
            Ds3Ec1CardView.this.repaint();
        }
    }
}

