/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3ec1;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3Ec1ModuleModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MutablePortsProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds3e.Ds3eProvPane;
import cerent.cms.ui.ec1.Ec1ProvPane;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.awt.Component;

public class Ds3Ec1ProvPane
extends AbstractSubTabbedPane
implements ITabName {
    public String DS3_E3_TAB_NAME = "DS3/E3";
    protected Ds123LineModel[] ds3Lines;
    protected TdmLineModel[] ec1Lines;
    private static final SDebug dbg = new SDebug("Ds3Ec1ProvPane");

    public Ds3Ec1ProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.ds3Lines = ds123LineModelArray;
        this.ec1Lines = tdmLineModelArray;
        this.registerWithModel();
    }

    protected void createSubTabs() {
        boolean bl;
        Ds3Ec1ModuleModel ds3Ec1ModuleModel;
        block4: {
            if (dbg.on()) {
                dbg.info("Creating SubTabs");
            }
            ds3Ec1ModuleModel = (Ds3Ec1ModuleModel)this.getUiModel();
            bl = true;
            try {
                bl = Model.getFramingType(ds3Ec1ModuleModel.getNodeModel()).isSonet();
                this.DS3_E3_TAB_NAME = bl ? "DS3" : "E3";
            }
            catch (AnnotatedException annotatedException) {
                dbg.println("Could not determine framingType for Ds3Ec1ProvPane!");
                if (!dbg.on()) break block4;
                SDebug.printStackTrace((Throwable)annotatedException);
            }
        }
        this.subTabs.addTab("Broadband Ports", (Component)this.getBbeTab(ds3Ec1ModuleModel));
        this.subTabs.addTab(this.DS3_E3_TAB_NAME, (Component)this.getDs3Tab(this.ds3Lines));
        if (bl) {
            this.subTabs.addTab("EC1", (Component)this.getEc1Tab(ds3Ec1ModuleModel, this.ec1Lines));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
    }

    private Pane getBbeTab(Ds3Ec1ModuleModel ds3Ec1ModuleModel) {
        IPortContainer iPortContainer = ds3Ec1ModuleModel.getBbeSlot();
        int n = iPortContainer.getEqType();
        IPortContainer[] iPortContainerArray = new IPortContainer[]{iPortContainer};
        return new ProtCardDualPane(this.subTabs, ds3Ec1ModuleModel, new MutablePortsProvPane("Broadband Ports", this.subTabs, iPortContainerArray, n, false, CSHelpConst.BbePortProvPane, dbg));
    }

    private Pane getEc1Tab(Ds3Ec1ModuleModel ds3Ec1ModuleModel, TdmLineModel[] tdmLineModelArray) {
        return new Ec1ProvPane("EC1", this.subTabs, tdmLineModelArray, false, true);
    }

    private Pane getDs3Tab(Ds123LineModel[] ds123LineModelArray) {
        return new Ds3eProvPane(this.DS3_E3_TAB_NAME, this.subTabs, ds123LineModelArray, false);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ds3LineUpdate..");
            }
            this.ds3Lines = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else if (object instanceof Ec1LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ec1LineUpdate...");
            }
            this.ec1Lines = (TdmLineModel[])((Ec1LineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

