/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.DwdmLineTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DwdmG709LineProvPane
extends NodeProvPane
implements TableModelListener {
    protected DwdmLineTableModel dataModel;
    protected DwdmModuleModel eqpmtModel;
    protected AbstractDwdmLineModel[] lineModels;
    protected int numLines;
    protected static final SDebug db = new SDebug("DwdmLineProvPane");

    public DwdmG709LineProvPane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(string, tabbedView);
        this.lineModels = abstractDwdmLineModelArray;
    }

    protected void init() {
        this.eqpmtModel = (DwdmModuleModel)this.getUiModel();
        this.numLines = this.lineModels.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected void prepareColumns() {
        int n = this.eqpmtModel.getEqType();
        TableColumn tableColumn = this.table.getColumn(DwdmLineTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        String string = "EFec";
        String string2 = null;
        switch (this.eqpmtModel.getEqType()) {
            case 182: {
                string2 = "mxpMappingType";
                break;
            }
            case 243: {
                string2 = "mappingTypeSynch";
                break;
            }
            case 181: {
                string2 = "txpMappingType";
                break;
            }
            default: {
                string = "Fec";
            }
        }
        this.setAttrCellEditor(2, string);
        if (string2 == null) {
            this.removeColumn(5);
        } else {
            this.setAttrCellEditor(5, string2);
        }
        this.setAttrCellEditor(1, "G%7%0%9OTN");
        this.setAttrCellEditor(4, "declareSdBerLevel");
    }

    protected void setAttrCellEditor(int n, String string) {
        this.setAttrCellEditor(n, string, -1);
    }

    protected void setAttrCellEditor(int n, String string, int n2) {
        TableColumn tableColumn = this.table.getColumn(DwdmLineTableModel.columnNames[n]);
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            if (n2 == -1) {
                tableColumn.setPreferredWidth(tableColumn.getWidth());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            db.println("WARNING: cannot find attributes for " + string + "\nPlease edit ElementDefaults.java");
            this.table.removeColumn(tableColumn);
        }
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(DwdmLineTableModel.columnNames[n]);
        this.table.removeColumn(tableColumn);
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected JComboBox getPJMonitorCombo() {
        JComboBox jComboBox = new JComboBox();
        return jComboBox;
    }

    protected DwdmLineTableModel getDataModel() {
        return new DwdmLineTableModel(this.lineModels);
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.eqpmtModel.getEqType() == 181 && tableModelEvent.getColumn() == 1) {
            int n = this.table.getEditingRow();
            this.enableAySyMapColumn(n);
        }
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    private void enableAySyMapColumn(int n) {
        Attribute[] attributeArray;
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        TableColumn tableColumn = this.table.getColumn(DwdmLineTableModel.columnNames[5]);
        String string = this.dataModel.getValueAt(n, 1).toString();
        if (string == (attributeArray = this.getAttributeArray("G%7%0%9OTN"))[0].toString()) {
            defaultTableCellRenderer.setEnabled(false);
        } else {
            defaultTableCellRenderer.setEnabled(true);
        }
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        this.table.updateUI();
    }

    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                DwdmG709LineProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In DwdmLineProvPane changeMessage cannot find Model " + observable);
        }
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unregisterWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        db.info("Called dispose");
        this.unregisterWithModel();
        super.dispose();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        if (this.eqpmtModel.getEqType() == 181) {
            for (int i = 0; i < this.numLines; ++i) {
                this.enableAySyMapColumn(i);
            }
        }
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        if (this.dataModel == null) {
            this.init();
        }
        super.enteringPage();
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        this.unregisterWithModel();
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmG709LineProvPane;
    }
}

