/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.idl.Dwdm.eMappingType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.List;

public class DwdmLineTableModel
extends DwdmTableModel {
    public static final int LINENUMBER_INDEX = 0;
    public static final int OTN_INDEX = 1;
    public static final int FEC_INDEX = 2;
    public static final int SFBERLEVEL_INDEX = 3;
    public static final int SDBERLEVEL_INDEX = 4;
    public static final int AYSYMAP_INDEX = 5;
    public static final String[] columnNames = new String[]{"Port", "G.709 OTN", "FEC", "SF BER", "SD BER", "Asynch/Synch Mapping"};
    public static final int OUT_OF_SERVICE = 1;
    public static final int IN_SERVICE = 0;
    public static final String[] statusStrings = new String[]{"In Service", "Out of Service"};
    private Attribute[] sfBerLevel;
    private Attribute[] sdBerLevel;
    private Attribute[] AySyMapping;
    private Attribute[] fecStatus;
    private Attribute[] otnStatus;
    private boolean[][] isDirty;
    private int eqType;
    private String fecDataTypeKey;
    private String MappingTypeKey;
    private static final SDebug db = new SDebug("DwdmLineTableModel");

    public DwdmLineTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        block7: {
            super(db, abstractDwdmLineModelArray);
            this.refreshMyLines(abstractDwdmLineModelArray);
            try {
                this.eqType = abstractDwdmLineModelArray[0].getModuleModel().getEqType();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        switch (this.eqType) {
            case 243: {
                this.fecDataTypeKey = "EFec";
                this.MappingTypeKey = "mappingTypeSynch";
                break;
            }
            case 182: {
                this.fecDataTypeKey = "EFec";
                this.MappingTypeKey = "mxpMappingType";
                break;
            }
            case 181: {
                this.fecDataTypeKey = "EFec";
                this.MappingTypeKey = "txpMappingType";
                break;
            }
            default: {
                this.fecDataTypeKey = "Fec";
            }
        }
        this.resetDirtyBits();
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.otnStatus = new Attribute[this.numLines];
        this.sfBerLevel = new Attribute[this.numLines];
        this.sdBerLevel = new Attribute[this.numLines];
        this.AySyMapping = new Attribute[this.numLines];
        this.fecStatus = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.isUnframedISCPayload() && !this.isProtectedTrunkPort(n)) {
            switch (n2) {
                case 3: {
                    return false;
                }
                case 2: {
                    if (this.eqType != 182 && this.eqType != 181) break;
                    return this.otnStatus[n].getIntValue() != 0;
                }
                case 5: {
                    if (this.eqType == 182) {
                        return this.otnStatus[n].getIntValue() != 0;
                    }
                    if (this.eqType != 181) break;
                    try {
                        if (this.model[0].getDataRate() == 17 || this.model[0].getDataRate() == 9) {
                            return false;
                        }
                        return this.otnStatus[n].getIntValue() != 0;
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                        break;
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                }
            }
            return n2 > 0;
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getOTNStatus(n);
                }
                case 2: {
                    return this.getFECStatus(n);
                }
                case 3: {
                    return this.getOTNSfBerLevel(n);
                }
                case 4: {
                    return this.getOTNSdBerLevel(n);
                }
                case 5: {
                    return this.getAySyMappingStatus(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("DwdmLineTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    Attribute attribute = (Attribute)object;
                    if (attribute == this.otnStatus[n]) {
                        return;
                    }
                    this.otnStatus[n] = attribute;
                    bl = true;
                    break;
                }
                case 2: {
                    Attribute attribute = (Attribute)object;
                    if (attribute == this.fecStatus[n]) {
                        return;
                    }
                    this.fecStatus[n] = attribute;
                    break;
                }
                case 4: {
                    Attribute attribute = (Attribute)object;
                    if (attribute == this.sdBerLevel[n]) {
                        return;
                    }
                    this.sdBerLevel[n] = attribute;
                    break;
                }
                case 3: {
                    Attribute attribute = (Attribute)object;
                    if (attribute == this.sfBerLevel[n]) {
                        return;
                    }
                    this.sfBerLevel[n] = attribute;
                    break;
                }
                case 5: {
                    Attribute attribute = (Attribute)object;
                    if (attribute == this.AySyMapping[n]) {
                        return;
                    }
                    this.AySyMapping[n] = attribute;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private Attribute getOTNStatus(int n) {
        block5: {
            if (this.otnStatus[n] == null && this.model[n] != null && this.model[n] instanceof DwdmTrkLineModel) {
                DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                try {
                    this.otnStatus[n] = this.getAttributeFor("G%7%0%9OTN", dwdmTrkLineModel.getOTNStatus() ? 1 : 0);
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("NoSuchInterface Exception " + n);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block5;
                    db.println("WrongInterfaceType Exception " + n);
                }
            }
        }
        return this.otnStatus[n];
    }

    private Attribute getFECStatus(int n) {
        block5: {
            if (this.fecStatus[n] == null && this.model[n] != null && this.model[n] instanceof DwdmTrkLineModel) {
                DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                try {
                    this.fecStatus[n] = this.getAttributeFor(this.fecDataTypeKey, dwdmTrkLineModel.getFECMode().value());
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("NoSuchInterface Exception " + n);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block5;
                    db.println("WrongInterfaceType Exception " + n);
                }
            }
        }
        return this.fecStatus[n];
    }

    private Attribute getAySyMappingStatus(int n) {
        block5: {
            if (this.AySyMapping[n] == null && this.model[n] != null && this.model[n] instanceof DwdmTrkLineModel) {
                DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                try {
                    this.AySyMapping[n] = this.getAttributeFor(this.MappingTypeKey, dwdmTrkLineModel.getMappingType().value());
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("NoSuchInterface Exception " + n);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block5;
                    db.println("WrongInterfaceType Exception " + n);
                }
            }
        }
        return this.AySyMapping[n];
    }

    private Attribute getOTNSfBerLevel(int n) {
        block5: {
            if (this.sfBerLevel[n] == null && this.model[n] != null && this.model[n] instanceof DwdmTrkLineModel) {
                DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                try {
                    this.sfBerLevel[n] = this.getAttributeFor("declareSfBerLevel", dwdmTrkLineModel.getOTNSfBerLevel());
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("NoSuchInterface Exception " + n);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block5;
                    db.println("WrongInterfaceType Exception " + n);
                }
            }
        }
        return this.sfBerLevel[n];
    }

    private Attribute getOTNSdBerLevel(int n) {
        block5: {
            if (this.sdBerLevel[n] == null && this.model[n] != null && this.model[n] instanceof DwdmTrkLineModel) {
                DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                try {
                    this.sdBerLevel[n] = this.getAttributeFor("declareSdBerLevel", dwdmTrkLineModel.getOTNSdBerLevel());
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("SdBer: NoSuchInterface Exception " + n);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block5;
                    db.println("SdBer: WrongInterfaceType Exception " + n);
                }
            }
        }
        return this.sdBerLevel[n];
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.getOTNStatus(n);
        this.getFECStatus(n);
        this.sdBerLevel[n] = this.getOTNSdBerLevel(n);
        this.sfBerLevel[n] = this.getOTNSfBerLevel(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.otnStatus[n] = null;
        this.fecStatus[n] = null;
        this.sdBerLevel[n] = null;
        this.sfBerLevel[n] = null;
        this.AySyMapping[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void applyToModel() throws Exception {
        int n = 0;
        boolean bl = false;
        try {
            for (n = 0; n < this.numLines; ++n) {
                DwdmTrkLineModel dwdmTrkLineModel;
                if ((this.isDirty[n][1] || this.isDirty[n][2] || this.isDirty[n][5]) && this.model[n] instanceof DwdmTrkLineModel) {
                    boolean bl2;
                    dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                    boolean bl3 = bl2 = this.getOTNStatus(n).getIntValue() != 0;
                    if (this.eqType == 182 || this.eqType == 243 || this.eqType == 181) {
                        dwdmTrkLineModel.setOTNData(bl2, eDwdmFecMode.from_int(this.fecStatus[n].getIntValue()), eMappingType.from_int(this.AySyMapping[n].getIntValue()));
                    } else {
                        dwdmTrkLineModel.setOTNData(bl2, eDwdmFecMode.from_int(this.fecStatus[n].getIntValue()), eMappingType.MAP_NOTUSED);
                    }
                }
                if (!this.isDirty[n][4] || !(this.model[n] instanceof DwdmTrkLineModel)) continue;
                dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                dwdmTrkLineModel.setOTNSdBerLevel((short)this.getOTNSdBerLevel(n).getIntValue());
            }
            this.resetDirtyBits();
        }
        catch (DetailedConfigError detailedConfigError) {
            throw new ConfigError(detailedConfigError.getMessage());
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    private boolean isUnframedISCPayload() {
        try {
            return this.model[0] != null && (this.model[0].getPayloadType() == 4 || this.model[0].getDataRate() == 21);
        }
        catch (NoSuchInterface noSuchInterface) {
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            // empty catch block
        }
        return false;
    }
}

