/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TraceMode;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.DwdmLinePane;
import cerent.cms.ui.dwdm.DwdmSonetLineProvPane;
import cerent.cms.ui.dwdm.DwdmTrkWlPane;
import cerent.cms.ui.fcmr.FcmrPortDistExtensionPane;
import cerent.cms.ui.fcmr.FcmrPortEnhancedFCFiconPane;
import cerent.cms.ui.trace.GenericTraceProvPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class DwdmPayloadLinePane
extends AbstractSubTabbedPane
implements ITabName {
    private boolean isSDH = false;
    private boolean isMonvisoMxp = false;
    private AbstractPane dwdmLinePane;
    private AbstractPane fcDistExtPane;
    private AbstractPane fcPortEnhPane;
    private AbstractPane sonetLinePane;
    private AbstractPane monvisoTrkPane;
    private AbstractPane comboPane;
    private GenericTraceProvPane sonetTracePane;
    private AbstractPane currentPane;
    private AbstractPane trkPane;

    public DwdmPayloadLinePane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel) {
        super(string, tabbedView);
        this.registerWithModel();
        this.isSDH = dwdmModuleModel.getNodeModel().getFramingType() != 0;
        this.isMonvisoMxp = dwdmModuleModel.getEqType() == 182;
    }

    public void destroy() {
        Object object;
        int n = this.subTabs.getComponentCount();
        AbstractPane[] abstractPaneArray = new AbstractPane[]{this.dwdmLinePane, this.fcDistExtPane, this.fcPortEnhPane, this.sonetLinePane, this.sonetTracePane, this.monvisoTrkPane, this.comboPane, this.trkPane};
        ArrayList<AbstractPane> arrayList = new ArrayList<AbstractPane>(Arrays.asList(abstractPaneArray));
        for (int i = 0; i < n; ++i) {
            object = this.subTabs.getComponentAt(i);
            if (!arrayList.contains(object)) continue;
            arrayList.remove(object);
        }
        Iterator<AbstractPane> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ((AbstractPane)((Object)object)).destroy();
        }
        super.destroy();
    }

    protected void createSubTabs() {
        int n;
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.getDwdmCliLineModels();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray2 = dwdmModuleModel.getDwdmTrkLineModels();
        FcmrLineModel[] fcmrLineModelArray = FcmrLineModel.filterUndefinedMedia(DwdmModuleModel.getFcmrLineModels(abstractDwdmLineModelArray));
        ArrayList<TdmLineModel> arrayList = new ArrayList<TdmLineModel>();
        ArrayList<AbstractDwdmLineModel> arrayList2 = new ArrayList<AbstractDwdmLineModel>();
        for (n = 0; n < abstractDwdmLineModelArray.length; ++n) {
            try {
                if (!abstractDwdmLineModelArray[n].isSonetSdhPayload()) continue;
                arrayList.add(abstractDwdmLineModelArray[n].getTdmLineModel());
                arrayList2.add(abstractDwdmLineModelArray[n]);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        for (n = 0; n < abstractDwdmLineModelArray2.length; ++n) {
            try {
                if (!abstractDwdmLineModelArray2[n].isSonetSdhPayload()) continue;
                arrayList.add(abstractDwdmLineModelArray2[n].getTdmLineModel());
                arrayList2.add(abstractDwdmLineModelArray2[n]);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        AbstractDwdmLineModel[] abstractDwdmLineModelArray3 = arrayList2.toArray(new AbstractDwdmLineModel[0]);
        IGenericTraceLine[] iGenericTraceLineArray = arrayList.toArray(new TdmLineModel[0]);
        this.dwdmLinePane = new DwdmLinePane("Unframed", this.subTabs, dwdmModuleModel.getDwdmLineModels(), DwdmLinePane.PaneType.DEFAULT);
        this.fcDistExtPane = new FcmrPortDistExtensionPane("Distance Extension", this.subTabs, fcmrLineModelArray, !dwdmModuleModel.supportsDEParams());
        this.fcPortEnhPane = new FcmrPortEnhancedFCFiconPane("Enhanced FC/FICON ISL", this.subTabs, fcmrLineModelArray, true);
        this.sonetLinePane = new DwdmSonetLineProvPane(this.isSDH ? "SDH" : "SONET", this.subTabs, (TdmLineModel[])iGenericTraceLineArray, abstractDwdmLineModelArray3);
        this.sonetTracePane = new GenericTraceProvPane("Section Trace", this.subTabs, TraceMode.SECTION, iGenericTraceLineArray, 6);
        this.monvisoTrkPane = new DwdmLinePane("Trunk", this.subTabs, abstractDwdmLineModelArray2, DwdmLinePane.PaneType.TRUNK);
        this.comboPane = new DwdmLinePane("Client", this.subTabs, abstractDwdmLineModelArray, DwdmLinePane.PaneType.COMBO);
        this.trkPane = new DwdmTrkWlPane("Wavelength Trunk Settings", this.subTabs, (DwdmTrkLineModel[])abstractDwdmLineModelArray2);
        this.setupTabs(dwdmModuleModel.getDwdmLineModels(), (DwdmTrkLineModel[])abstractDwdmLineModelArray2, abstractDwdmLineModelArray3, (TdmLineModel[])iGenericTraceLineArray, fcmrLineModelArray);
    }

    protected void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        this.currentPane = (AbstractPane)((Object)this.subTabs.getSelectedComponent());
        this.setupTabs(dwdmLineUpdate.getDwdmLineModels(), dwdmLineUpdate.getDwdmTrkLineModels(), dwdmLineUpdate.getTdmDwdmLineModels(), dwdmLineUpdate.getTdmLineModels(), FcmrLineModel.filterUndefinedMedia(dwdmLineUpdate.getFcmrLineModels()));
        if (this.showing && this.currentPane != null) {
            try {
                this.subTabs.setSelectedComponent((Component)((Object)this.currentPane));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.subTabs.setSelectedIndex(0);
            }
            try {
                this.currentPane.setShowing(true);
                this.repaint();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (this.currentPane.getTable() != null) {
                TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
            }
        }
    }

    private void setupTabs(AbstractDwdmLineModel[] abstractDwdmLineModelArray, DwdmTrkLineModel[] dwdmTrkLineModelArray, AbstractDwdmLineModel[] abstractDwdmLineModelArray2, TdmLineModel[] tdmLineModelArray, FcmrLineModel[] fcmrLineModelArray) {
        try {
            this.subTabs.removeAll();
            int n = abstractDwdmLineModelArray[0].getFramingType();
            int n2 = dwdmTrkLineModelArray[0].getFramingType();
            DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
            if (n != n2) {
                this.subTabs.addTab("Client", (Component)((Object)this.comboPane));
                if (fcmrLineModelArray != null && fcmrLineModelArray.length > 0) {
                    this.subTabs.addTab("Distance Extension", (Component)((Object)this.fcDistExtPane));
                    if (dwdmModuleModel.supportsDEParams()) {
                        this.subTabs.addTab("Enhanced FC/FICON ISL", (Component)((Object)this.fcPortEnhPane));
                    }
                }
                if (tdmLineModelArray != null && tdmLineModelArray.length > 0) {
                    this.subTabs.addTab(this.isSDH ? "SDH" : "SONET", (Component)((Object)this.sonetLinePane));
                    this.sonetTracePane.refreshMyLines(tdmLineModelArray);
                    this.sonetTracePane.refreshFromModel();
                    this.subTabs.addTab("Section Trace", (Component)((Object)this.sonetTracePane));
                }
            } else {
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                String string = EntityCellRenderer.getPayloadTypeStr(abstractDwdmLineModelArray[0]);
                switch (n) {
                    case 0: 
                    case 1: {
                        if (tdmLineModelArray != null && tdmLineModelArray.length > 0) {
                            this.subTabs.addTab(this.isSDH ? "SDH" : "SONET", (Component)((Object)this.sonetLinePane));
                            this.sonetTracePane.refreshMyLines(tdmLineModelArray);
                            this.sonetTracePane.refreshFromModel();
                            this.subTabs.addTab("Section Trace", (Component)((Object)this.sonetTracePane));
                        }
                        if (!this.isMonvisoMxp) break;
                        this.subTabs.addTab("Trunk", (Component)((Object)this.monvisoTrkPane));
                        break;
                    }
                    case 2: {
                        this.subTabs.addTab("Ethernet", (Component)((Object)this.dwdmLinePane));
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.subTabs.addTab(string, (Component)((Object)this.dwdmLinePane));
                        break;
                    }
                    default: {
                        db.println("Unknown payload type " + n);
                    }
                }
            }
            this.subTabs.addTab("Wavelength Trunk Settings", (Component)((Object)this.trkPane));
        }
        catch (NoSuchInterface noSuchInterface) {
            noSuchInterface.printStackTrace();
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            wrongInterfaceType.printStackTrace();
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
    }
}

