/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmTdmPmPane;
import cerent.cms.ui.dwdm.NotApplicablePane;
import cerent.cms.ui.rmon.RmonPmHistPane;
import cerent.cms.ui.rmon.RmonPmStatPane;
import cerent.cms.ui.rmon.RmonPmUtilPane;
import java.awt.BorderLayout;
import java.awt.Component;

public class DwdmPayloadPmPane
extends AbstractSubTabbedPane
implements ITabName {
    private boolean isSDH;
    private boolean isCombo;
    private boolean supportsUtilization;
    private AbstractPane tdmTab;
    private AbstractPane rmonStatTab;
    private AbstractPane rmonUtilTab;
    private AbstractPane rmonHistTab;
    private AbstractPane unframedTab;
    private TdmLineModel[] _tdmLines = null;
    private IRmonModel[] _rmonLines = null;

    public DwdmPayloadPmPane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel, TdmLineModel[] tdmLineModelArray, IRmonModel[] iRmonModelArray) {
        super(string, tabbedView);
        this._tdmLines = tdmLineModelArray;
        this._rmonLines = iRmonModelArray;
        this.setLayout(new BorderLayout());
        this.registerWithModel();
        this.isSDH = dwdmModuleModel.getNodeModel().getFramingType() != 0;
        this.supportsUtilization = dwdmModuleModel.supportUtilization();
        this.isCombo = dwdmModuleModel.getEqType() == 183 || dwdmModuleModel.getEqType() == 184 || dwdmModuleModel.getEqType() == 243;
    }

    public void destroy() {
        AbstractPane[] abstractPaneArray = new AbstractPane[]{this.tdmTab, this.rmonStatTab, this.rmonUtilTab, this.rmonHistTab, this.unframedTab};
        this.subTabs.removeAll();
        for (int i = 0; i < abstractPaneArray.length; ++i) {
            if (abstractPaneArray[i] == null) continue;
            abstractPaneArray[i].destroy();
        }
        super.destroy();
    }

    protected void createSubTabs() {
        this.tdmTab = this.createDwdmTdmPane(this._tdmLines);
        this.rmonStatTab = this.createDwdmRmonStatPane(this._rmonLines);
        this.rmonUtilTab = this.createDwdmRmonUtilPane(this._rmonLines);
        this.rmonHistTab = this.createDwdmRmonHistPane(this._rmonLines);
        this.unframedTab = this.createDwdmUnframedPane(true);
        this.setupTabs(this._tdmLines, this._rmonLines);
    }

    protected void refreshMyLines(Object object) {
        block10: {
            Object object2;
            if (object instanceof RmonLineUpdate) {
                object2 = (RmonLineUpdate)object;
                this._rmonLines = object2.getRmonModels();
                if (!this.isCombo) {
                    this._tdmLines = new TdmLineModel[0];
                }
            } else if (object instanceof DwdmLineUpdate) {
                object2 = (DwdmLineUpdate)object;
                this._tdmLines = ((DwdmLineUpdate)object2).getTdmLineModels();
                if (!this.isCombo) {
                    this._rmonLines = new IRmonModel[0];
                }
            } else {
                return;
            }
            if (!this._inited) {
                return;
            }
            object2 = (AbstractPane)((Object)this.subTabs.getSelectedComponent());
            this.setupTabs(this._tdmLines, this._rmonLines);
            if (object2 != null) {
                try {
                    this.subTabs.setSelectedComponent((Component)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.subTabs.getTabCount() <= 0) break block10;
                    this.subTabs.setSelectedIndex(0);
                }
            }
        }
    }

    protected AbstractPane createDwdmTdmPane(TdmLineModel[] tdmLineModelArray) {
        return new DwdmTdmPmPane(this.isSDH ? "SDH" : "SONET", this.getParentView(), tdmLineModelArray);
    }

    protected AbstractPane createDwdmRmonStatPane(IRmonModel[] iRmonModelArray) {
        return new RmonPmStatPane("Statistics", this.subTabs, iRmonModelArray, false);
    }

    protected AbstractPane createDwdmRmonUtilPane(IRmonModel[] iRmonModelArray) {
        return new RmonPmUtilPane("Utilization", this.subTabs, iRmonModelArray);
    }

    protected AbstractPane createDwdmRmonHistPane(IRmonModel[] iRmonModelArray) {
        return new RmonPmHistPane("History", this.subTabs, iRmonModelArray);
    }

    private AbstractPane createDwdmUnframedPane(boolean bl) {
        return NotApplicablePane.createPane(this.getParentView(), bl);
    }

    private void setupTabs(TdmLineModel[] tdmLineModelArray, IRmonModel[] iRmonModelArray) {
        this.subTabs.removeAll();
        if (iRmonModelArray != null && iRmonModelArray.length > 0) {
            this.subTabs.add("Statistics", (Component)((Object)this.rmonStatTab));
            if (this.supportsUtilization) {
                this.subTabs.add("Utilization", (Component)((Object)this.rmonUtilTab));
            }
            this.subTabs.add("History", (Component)((Object)this.rmonHistTab));
        }
        if (tdmLineModelArray != null && tdmLineModelArray.length > 0) {
            this.subTabs.add(this.isSDH ? "SDH" : "SONET", (Component)((Object)this.tdmTab));
        }
        if (this.subTabs.getComponentCount() == 0) {
            this.subTabs.add((Component)((Object)this.unframedTab));
        }
    }
}

