/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.MrSlot;
import cerent.cms.model.TraceMode;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MutablePortsProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmCardDualPane;
import cerent.cms.ui.dwdm.DwdmCardProvPane;
import cerent.cms.ui.dwdm.DwdmG709LineProvPane;
import cerent.cms.ui.dwdm.DwdmLineThresholdPane;
import cerent.cms.ui.dwdm.DwdmPayloadLinePane;
import cerent.cms.ui.dwdm.FECThresholdPane;
import cerent.cms.ui.dwdm.OpticalThresholdPane;
import cerent.cms.ui.dwdm.OtnThresholdPane;
import cerent.cms.ui.ppm.PpmProvPane;
import cerent.cms.ui.trace.GenericTraceProvPane;
import java.awt.Component;

public class DwdmProvPane
extends AbstractSubTabbedPane
implements ITabName {
    private static final String OTN_LINE_PROV_TAB = "OTN Lines";
    private static final String OTN_PROVISIONING_TAB = "OTN";

    public DwdmProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void createSubTabs() {
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        this.subTabs.addTab("Line", (Component)((Object)new DwdmPayloadLinePane("Line", this.subTabs, dwdmModuleModel)));
        this.subTabs.addTab("Line Thresholds", (Component)((Object)new DwdmLineThresholdPane("Line Thresholds", this.subTabs, dwdmModuleModel)));
        this.subTabs.addTab("Optics Thresholds", (Component)((Object)new OpticalThresholdPane("Optics Thresholds", this.subTabs, dwdmModuleModel)));
        if (dwdmModuleModel.supportsOTN()) {
            this.subTabs.addTab(OTN_PROVISIONING_TAB, (Component)this.getOTNProvTab(this.subTabs));
        }
        if (dwdmModuleModel.supportPPM()) {
            this.subTabs.addTab("Pluggable Port Modules", (Component)((Object)new PpmProvPane("Pluggable Port Modules", this.subTabs, false)));
        } else {
            MrSlot mrSlot = dwdmModuleModel.getMrSlot();
            this.subTabs.addTab("Data Rate Selection", (Component)((Object)new MutablePortsProvPane("Data Rate Selection", this.subTabs, new IPortContainer[]{mrSlot}, mrSlot.getEqType(), false, CSHelpConst.MrPortProvPane, db)));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.addTab("Card", (Component)((Object)new DwdmCardProvPane("Card", this.subTabs)));
    }

    private Pane getOTNProvTab(TabbedView tabbedView) {
        return new AbstractSubTabbedPane(OTN_PROVISIONING_TAB, tabbedView){

            public void createSubTabs() {
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
                DwdmTrkLineModel[] dwdmTrkLineModelArray = dwdmModuleModel.getDwdmTrkLineModels();
                this.subTabs.addTab(DwdmProvPane.OTN_LINE_PROV_TAB, (Component)this.getOTNLineTab(dwdmTrkLineModelArray));
                this.subTabs.addTab("G.709 Thresholds", (Component)this.getOtnThresholdsTab(dwdmTrkLineModelArray));
                this.subTabs.addTab("FEC Thresholds", (Component)this.getFECThresholdsTab(dwdmTrkLineModelArray));
                this.subTabs.addTab("Trail Trace Identifier", (Component)this.getTTITab(dwdmTrkLineModelArray));
            }

            private Pane getOTNLineTab(DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmG709LineProvPane(DwdmProvPane.OTN_LINE_PROV_TAB, this.subTabs, dwdmTrkLineModelArray);
            }

            private Pane getOtnThresholdsTab(DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new OtnThresholdPane("G.709 Thresholds", this.subTabs, dwdmTrkLineModelArray), 4);
            }

            private Pane getFECThresholdsTab(DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new FECThresholdPane("FEC Thresholds", this.subTabs, dwdmTrkLineModelArray), 4);
            }

            private Pane getTTITab(DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new GenericTraceProvPane("Trail Trace Identifier", this.subTabs, TraceMode.TTI, dwdmTrkLineModelArray, 1);
            }
        };
    }
}

