/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.DwdmTrkWlProvTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DwdmTrkWlPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected static final SDebug db = new SDebug("DwdmTrkWlPane");
    protected DwdmTrkWlProvTableModel dataModel;
    protected DwdmModuleModel eqpmtModel;
    protected DwdmTrkLineModel[] lineModels;
    protected int numLines;
    private boolean notInited = true;
    private final int DEFAULT_WIDTH_VALUE = -1;
    private final int INVALID_INDEX = -1;

    public DwdmTrkWlPane(String string, TabbedView tabbedView, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
        super(string, tabbedView);
        this.lineModels = dwdmTrkLineModelArray;
        this.numLines = dwdmTrkLineModelArray.length;
        this.eqpmtModel = (DwdmModuleModel)this.getUiModel();
        this.dataModel = this.getDataModel();
    }

    protected void init() {
        this.dataModel.addTableModelListener(this);
        this.table = new UTableExt(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.notInited = false;
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setPreferredWidth(150);
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    private JComboBox getComboBoxFor(Object[] objectArray, boolean bl) {
        if (bl) {
            Arrays.sort(objectArray, 1, objectArray.length, new AttrSorter());
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected DwdmTrkWlProvTableModel getDataModel() {
        return new DwdmTrkWlProvTableModel(this.lineModels);
    }

    private int getFramingType() {
        return this.eqpmtModel.getNodeModel().getFramingType();
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected List getAttributeList(Class clazz) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeList("DWDM." + clazz.getName());
    }

    protected Attribute getAttribute(Class clazz, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal("DWDM." + clazz.getName(), n);
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1 && this.dataModel != null) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In DwdmTrkWlPane changeMessage cannot find Model " + observable);
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
        this.unRegisterWithModel();
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                DwdmTrkWlPane.this.refreshLine(observable);
            }
        };
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmTrkWlPane;
    }

    private class UTableExt
    extends UTable {
        private DwdmTrkWlProvTableModel tableModel;
        private DefaultCellEditor bandEditor;
        private DefaultCellEditor evenoddEditor;
        private DefaultCellEditor wl_C_OEditor;
        private DefaultCellEditor wl_C_EEditor;
        private DefaultCellEditor wl_L_OEditor;
        private DefaultCellEditor wl_L_EEditor;
        private DefaultCellEditor wlOldCardsEditor;
        private ListCellRenderer wlRenderer;

        public UTableExt(DwdmTrkWlProvTableModel dwdmTrkWlProvTableModel) {
            super((TableModel)dwdmTrkWlProvTableModel);
            this.tableModel = dwdmTrkWlProvTableModel;
            this.bandEditor = new DefaultCellEditor(DwdmTrkWlPane.this.getComboBoxFor(DwdmTrkWlPane.this.getAttributeArray("Band"), false));
            this.evenoddEditor = new DefaultCellEditor(DwdmTrkWlPane.this.getComboBoxFor(DwdmTrkWlPane.this.getAttributeArray("Even/Odd"), false));
            this.wlOldCardsEditor = new DefaultCellEditor(DwdmTrkWlPane.this.getComboBoxFor(DwdmTrkWlPane.this.getAttributeArray("declDwdmWavelength"), false));
            this.wl_C_EEditor = new DefaultCellEditor(DwdmTrkWlPane.this.getComboBoxFor(DwdmTrkWlPane.this.getAttributeArray("declDwdmCWlEven"), true));
            this.wl_C_OEditor = new DefaultCellEditor(DwdmTrkWlPane.this.getComboBoxFor(DwdmTrkWlPane.this.getAttributeArray("declDwdmCWlOdd"), true));
            this.wl_L_EEditor = new DefaultCellEditor(DwdmTrkWlPane.this.getComboBoxFor(DwdmTrkWlPane.this.getAttributeArray("declDwdmLWlEven"), true));
            this.wl_L_OEditor = new DefaultCellEditor(DwdmTrkWlPane.this.getComboBoxFor(DwdmTrkWlPane.this.getAttributeArray("declDwdmLWlOdd"), true));
            this.wlRenderer = new WavelengthListCellRenderer(dwdmTrkWlProvTableModel);
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            int n3 = this.convertColumnIndexToModel(n2);
            if (n3 == 1) {
                return this.bandEditor;
            }
            if (n3 == 2) {
                return this.evenoddEditor;
            }
            if (n3 == 3) {
                DefaultCellEditor defaultCellEditor = this.wlOldCardsEditor;
                if (DwdmTrkWlPane.this.eqpmtModel.supportsCLBand()) {
                    int n4 = this.tableModel.getLineEodd(n);
                    int n5 = this.tableModel.getLineBand(n);
                    defaultCellEditor = n4 == 0 && n5 == 0 ? this.wl_C_OEditor : (n4 == 0 && n5 == 1 ? this.wl_L_OEditor : (n4 == 1 && n5 == 0 ? this.wl_C_EEditor : this.wl_L_EEditor));
                }
                ((JComboBox)defaultCellEditor.getComponent()).setRenderer(this.wlRenderer);
                return defaultCellEditor;
            }
            return super.getCellEditor(n, n2);
        }

        private int getFramingType() {
            return DwdmTrkWlPane.this.eqpmtModel.getNodeModel().getFramingType();
        }
    }

    class WavelengthListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border noFocusBorder;
        private DwdmTrkWlProvTableModel tableModel;
        private String[] tunableWavelength;

        public WavelengthListCellRenderer(DwdmTrkWlProvTableModel dwdmTrkWlProvTableModel) {
            this.tableModel = dwdmTrkWlProvTableModel;
            this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            Color color = Color.lightGray;
            boolean bl3 = DwdmTrkWlPane.this.eqpmtModel.getState().value() != 0;
            boolean bl4 = false;
            this.tunableWavelength = this.tableModel.getTunableWlList(0);
            if (bl3 && this.tunableWavelength != null) {
                for (int i = 0; i < this.tunableWavelength.length; ++i) {
                    if (!string.equals(this.tunableWavelength[i])) continue;
                    bl4 = true;
                    break;
                }
            }
            if (bl4) {
                string = string + " **";
                color = Color.white;
            }
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setBackground(color);
            }
            this.setForeground(Color.black);
            this.setEnabled(jList.isEnabled() && DwdmTrkWlPane.this.isUserAuthorized());
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            return this;
        }
    }

    private class AttrSorter
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (!(object instanceof Attribute) || !(object2 instanceof Attribute)) {
                throw new ClassCastException("Cannot Cast to Attribute");
            }
            return ((Attribute)object).getKey().compareTo(((Attribute)object2).getKey());
        }
    }
}

