/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class DwdmTrkWlProvTableModel
extends DwdmTableModel {
    private static final SDebug db = new SDebug("DwdmTrkWlProvTableModel");
    private Attribute[] bands;
    private Attribute[] wls;
    private Attribute[] eodds;
    public static final int FIRST_ROW_INDEX = 0;
    private static final int MIN_NUM_LINES = 0;
    private static final int MIN_NUM_COL = 0;
    public static final int LINENUMBER_INDEX = 0;
    public static final int BAND_INDEX = 1;
    public static final int EVENODD_INDEX = 2;
    public static final int WL_INDEX = 3;
    public static final int NEXT_COLUMN_INDEX = 4;
    protected String[] columnNames = new String[]{"Port", "Band", "Even/Odd", "Wavelength"};
    protected boolean[][] isDirty;
    private Attribute C_BAND_ATTR = this.getAttributeFor("Band", 0);
    private Attribute L_BAND_ATTR = this.getAttributeFor("Band", 1);
    private Attribute EVEN_WL_ATTR = this.getAttributeFor("Even/Odd", 1);
    private Attribute ODD_WL_ATTR = this.getAttributeFor("Even/Odd", 0);
    private Object[][] ATTR_MAP = new Object[][]{{"declDwdmCWlOdd", this.C_BAND_ATTR, this.ODD_WL_ATTR}, {"declDwdmCWlEven", this.C_BAND_ATTR, this.EVEN_WL_ATTR}, {"declDwdmLWlEven", this.L_BAND_ATTR, this.EVEN_WL_ATTR}, {"declDwdmLWlOdd", this.L_BAND_ATTR, this.ODD_WL_ATTR}};

    public DwdmTrkWlProvTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(db, abstractDwdmLineModelArray);
        this.bands = new Attribute[this.numLines];
        this.wls = new Attribute[this.numLines];
        this.eodds = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.refreshMyLines(abstractDwdmLineModelArray);
    }

    private boolean isBandEditable() {
        return this.eqpmtModel.supportsCLBand() && this.eqpmtModel.getState() == eEqState.NOT_PRESENT;
    }

    public int getLineEodd(int n) {
        return this.eodds[n].getValue();
    }

    public int getLineBand(int n) {
        return this.bands[n].getValue();
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.isProtectedTrunkPort(n)) {
            switch (n2) {
                case 3: {
                    return true;
                }
                case 1: {
                    return this.isBandEditable();
                }
                case 2: {
                    return this.eqpmtModel.supportsCLBand();
                }
            }
        }
        return false;
    }

    private boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isDirty() {
        return this.isDirty(0, 3);
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getBand(n);
                }
                case 3: {
                    return this.getWL(n);
                }
                case 2: {
                    return this.getEvenOdd(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("DwdmTrkWlProvTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2 + " newVal=" + object);
        }
        try {
            switch (n2) {
                case 1: {
                    Attribute attribute;
                    this.bands[n] = attribute = (Attribute)object;
                    break;
                }
                case 3: {
                    Attribute attribute;
                    this.wls[n] = attribute = (Attribute)object;
                    this.isDirty[n][n2] = true;
                    this.fireTableCellUpdated(n, n2);
                    break;
                }
                case 2: {
                    Attribute attribute;
                    this.eodds[n] = attribute = (Attribute)object;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return;
        }
    }

    private void updateBandParityAndWavelength(int n, int n2) {
        Attribute attribute = null;
        for (int i = 0; i < this.ATTR_MAP.length; ++i) {
            attribute = this.getAttributeFor((String)this.ATTR_MAP[i][0], n);
            if (attribute == null) continue;
            this.wls[n2] = attribute;
            this.bands[n2] = (Attribute)this.ATTR_MAP[i][1];
            this.eodds[n2] = (Attribute)this.ATTR_MAP[i][2];
            break;
        }
        if (n == 0 && !this.isBandEditable()) {
            this.bands[n2] = this.eqpmtModel.isLBandCard() ? this.getAttributeFor("Band", 1) : this.getAttributeFor("Band", 0);
        }
    }

    private String remapWlToString(int n) {
        Attribute attribute = null;
        for (int i = 0; i < this.ATTR_MAP.length; ++i) {
            attribute = this.getAttributeFor((String)this.ATTR_MAP[i][0], n);
            if (attribute == null) continue;
            return attribute.toString();
        }
        return new String("Value not found!");
    }

    private Attribute getWL(int n) {
        if (this.wls[n] == null) {
            int n2;
            block5: {
                DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                n2 = 0;
                try {
                    n2 = dwdmTrkLineModel.getWavelength();
                }
                catch (NoSuchInterface noSuchInterface) {
                    db.println("Caught NoSuchInterface in getWL");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    db.println("Caught WrongInterfaceType in getWL");
                    if (!db.on()) break block5;
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            this.updateBandParityAndWavelength(n2, n);
        }
        return this.wls[n];
    }

    private Attribute getBand(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.bands[n] == null) {
            this.getWL(n);
        }
        return this.bands[n];
    }

    private Attribute getEvenOdd(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.eodds[n] == null) {
            this.getWL(n);
        }
        return this.eodds[n];
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        block4: {
            if (n > this.numLines || n < 0) {
                if (db.on()) {
                    db.println("Invalid lineNo for refresh " + n);
                }
                return;
            }
            this.resetLineCache(n);
            try {
                this.bands[n] = this.getBand(n);
                this.eodds[n] = this.getEvenOdd(n);
                this.wls[n] = this.getWL(n);
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("DwdmTrkWlProvTableModel: error in refreshLineFromModel, line: " + n + "\n" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.bands[n] = null;
        this.eodds[n] = null;
        this.wls[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.isDirty(n, 3)) continue;
                ((DwdmTrkLineModel)this.model[n]).setWaveLength(this.getWL(n).getIntValue());
                this.isDirty[n][3] = false;
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public String[] getTunableWlList(int n) {
        int[] nArray;
        block6: {
            nArray = null;
            try {
                nArray = ((DwdmTrkLineModel)this.model[n]).getTunableWavelengthList();
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Caught NoSuchInterface in getTunableWlList");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Caught WrongInterfaceType in getTunableWlList");
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        String[] stringArray = null;
        if (nArray != null && nArray.length != 0) {
            stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue;
                stringArray[i] = this.remapWlToString(nArray[i]);
                if (!db.on()) continue;
                db.print(i + 1 + ") " + stringArray[i] + "; ");
                if (i + 1 != nArray.length) continue;
                db.println(" ");
            }
        }
        return stringArray;
    }
}

