/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.SettingDisabled;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DwdmTypeAmpliProvPane
extends NodeProvPane
implements ActionListener {
    protected OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
    private JComboBox ampliRoleCB;
    private String cardAmpliModeKey = "dwdmLAmpliCardMode";
    protected static final SDebug db = new SDebug("DwdmTypeAmpliProvPane");

    public DwdmTypeAmpliProvPane(String string, TabbedView tabbedView, OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray) {
        super(string, tabbedView);
        this.initProvPane();
    }

    protected void initProvPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        jPanel.add(this.createCardInfoPanel());
        if (db.on()) {
            db.println("init: finish");
        }
    }

    protected Attribute[] getAttributeFor(String string) {
        return ElementDefaults.getAttributeMap(this.opticsModuleModel).getAttributeArray(string);
    }

    protected Attribute getAttributeValFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.opticsModuleModel).getAttributeForVal(string, n);
    }

    private JLabel createLabel(String string) {
        return this.createLabel(string, 175, 20);
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    private JPanel createCardInfoPanel() {
        JPanel jPanel = DwdmTypeAmpliProvPane.createVerticalPanel("Card Provisioning");
        Object[] objectArray = this.getAttributeFor(this.cardAmpliModeKey);
        this.ampliRoleCB = this.addComboBox(jPanel, "Card Working Mode: ", objectArray);
        return jPanel;
    }

    private JComboBox addComboBox(JPanel jPanel, String string, Object[] objectArray) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jPanel2.add(jComboBox);
        jComboBox.addActionListener(this);
        jPanel.add(jPanel2);
        this.enableComponent(jComboBox);
        return jComboBox;
    }

    private int getAmpliRoleFromCB() {
        return ((Attribute)this.ampliRoleCB.getSelectedItem()).getIntValue();
    }

    private eOpticalAmplifierRole getCardAmpliModeFromCB() {
        return eOpticalAmplifierRole.from_int(((Attribute)this.ampliRoleCB.getSelectedItem()).getIntValue());
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update from " + observable + "arg obj is " + object);
        }
        if (observable instanceof OpticsAmplifiedLineModel) {
            OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.opticsModuleModel.getOpticsAmplifiedLineModels();
            for (int i = 0; i < opticsAmplifiedLineModelArray.length; ++i) {
                if (observable != opticsAmplifiedLineModelArray[i] || !object.equals(ModelUpdateType.CHANGED)) continue;
                this.requestRefresh(observable, this.getRefreshThread(observable));
            }
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                DwdmTypeAmpliProvPane.this.refreshModule(observable);
            }
        };
    }

    protected void refreshModule(Observable observable) {
        if (observable instanceof OpticsAmplifiedLineModel) {
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
            }
        }
    }

    protected void registerWithModel() {
        this.opticsModuleModel.addObserver((Observer)((Object)this));
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.opticsModuleModel.getOpticsAmplifiedLineModels();
        for (int i = 0; i < opticsAmplifiedLineModelArray.length; ++i) {
            opticsAmplifiedLineModelArray[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        this.opticsModuleModel.deleteObserver((Observer)((Object)this));
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.opticsModuleModel.getOpticsAmplifiedLineModels();
        for (int i = 0; i < opticsAmplifiedLineModelArray.length; ++i) {
            opticsAmplifiedLineModelArray[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void destroy() {
        this.unRegisterWithModel();
        super.destroy();
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("calling applyChangesToModel");
        }
        try {
            this.setCursor(3);
            this.opticsModuleModel.setAmpliRole(this.getCardAmpliModeFromCB());
        }
        catch (ConfigError configError) {
            throw configError;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            throw new ConfigError(wrongInterfaceType.getMessage());
        }
        catch (NoSuchInterface noSuchInterface) {
            throw new ConfigError(noSuchInterface.getMessage());
        }
        catch (SettingDisabled settingDisabled) {
            throw new ConfigError(settingDisabled.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("calling refreshFromModel");
        }
        this.setAmpliRoleCB();
        this.resetDirty();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.setDirty();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.registerWithModel();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        this.unRegisterWithModel();
    }

    public boolean hasSubTabs() {
        return false;
    }

    private void setAmpliRoleCB() throws Exception {
        this.ampliRoleCB.setSelectedItem(this.getAttributeValFor(this.cardAmpliModeKey, this.opticsModuleModel.getAmpliRole().value()));
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmTypeAmpliProvPane;
    }
}

