/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.FECThresholdProvPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class FECThresholdPane
extends AbstractPane {
    protected DwdmTrkLineModel[] models;
    protected FECThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String FEC_1DAY_PANEL = "1DAY";
    protected static final String FEC_15MIN_PANEL = "15MIN";
    protected static final int FEC_1DAY = 1;
    protected static final int FEC_15MIN = 0;
    private JLabel tableLabel = new JLabel("TEST LABEL...");
    private String tableLabelString = new String();
    private JPanel labeledTablePanel = null;
    private static final SDebug db = new SDebug("Pane.FECThresholdPane");

    public FECThresholdPane(String string, TabbedView tabbedView, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
        super(string, tabbedView);
        this.models = dwdmTrkLineModelArray;
        this.panes = new Pane[2];
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "South");
        this.add(this.getTablePanel(), "Center");
    }

    protected FECThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new FECThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.panes[0] = this.getFECThresholdProvPane(FEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN);
        this.tablePanel.add((Component)this.panes[0], FEC_15MIN_PANEL);
        this.panes[1] = this.getFECThresholdProvPane(FEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY);
        this.tablePanel.add((Component)this.panes[1], FEC_1DAY_PANEL);
        this.cl.show(this.tablePanel, FEC_15MIN_PANEL);
        this.currentPane = this.panes[0];
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected FECThresholdProvPane getFECThresholdProvPane(String string, eIntervalType eIntervalType2) {
        return new FECThresholdProvPane(string, this.getParentView(), this.models, eIntervalType2);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        this.getButtonPanel().refreshAction();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (null == this.panes[i]) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.panes[i].getName());
            if (this.panes[i] instanceof FECThresholdProvPane) {
                ((FECThresholdProvPane)this.panes[i]).dispose();
            }
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected class FECThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JButton showButton = new JButton("Refresh");
        public ButtonGroup periodButtonGroup;
        protected int TCM2_MASK = 12;
        protected int TCM1_MASK = 8;
        protected int PATH_MASK = 4;
        protected int FE_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public FECThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.showButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FECThresholdButtonPanel.this.refreshAction();
                }
            });
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel.setPreferredSize(dimension);
            jPanel.add((Component)this.button15Min, "North");
            jPanel.add((Component)this.button1Day, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void refreshAction() {
            int n = 0;
            FECThresholdPane.this.tableLabelString = " ";
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (db.on()) {
                    db.println("1 Day");
                }
                n = 1;
                FECThresholdPane.this.tableLabelString = FECThresholdPane.this.tableLabelString + "FEC, 1 Day";
            } else {
                n = 0;
                FECThresholdPane.this.tableLabelString = FECThresholdPane.this.tableLabelString + "FEC, 15 Min";
            }
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("FEC 15MIN");
                    }
                    FECThresholdPane.this.showPanel(FECThresholdPane.this.panes[0]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("FEC 1DAY");
                    }
                    FECThresholdPane.this.showPanel(FECThresholdPane.this.panes[1]);
                }
            }
            FECThresholdPane.this.tableLabel.setText(FECThresholdPane.this.tableLabelString);
        }
    }
}

