/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.DwdmModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.OpticalThresholdProvPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class OpticalThresholdPane
extends AbstractPane {
    protected DwdmModuleModel mm;
    protected OpticalThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String WARNING_15MIN_TH_PANEL = "WARN_15MIN_TH";
    protected static final String WARNING_1DAY_TH_PANEL = "WARN_1DAY_TH";
    protected static final String ALARM_TH_PANEL = "ALARM_TH";
    protected static final int WARNING_15MIN_TH = 0;
    protected static final int WARNING_1DAY_TH = 1;
    protected static final int ALARM_TH = 2;
    private JLabel tableLabel = new JLabel("TEST LABEL...");
    private String tableLabelString = new String();
    private JPanel labeledTablePanel = null;
    private static final SDebug db = new SDebug("Pane.OpticalThresholdPane");

    public OpticalThresholdPane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel) {
        super(string, tabbedView);
        this.mm = dwdmModuleModel;
        this.panes = new Pane[4];
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "South");
        this.add(this.getTablePanel(), "Center");
    }

    protected OpticalThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new OpticalThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.panes[0] = this.getOpticalThresholdProvPane(WARNING_15MIN_TH_PANEL, 0);
        this.tablePanel.add((Component)this.panes[0], WARNING_15MIN_TH_PANEL);
        this.panes[1] = this.getOpticalThresholdProvPane(WARNING_1DAY_TH_PANEL, 1);
        this.tablePanel.add((Component)this.panes[1], WARNING_1DAY_TH_PANEL);
        this.panes[2] = this.getOpticalThresholdProvPane(ALARM_TH_PANEL, 2);
        this.tablePanel.add((Component)this.panes[2], ALARM_TH_PANEL);
        this.cl.show(this.tablePanel, WARNING_15MIN_TH_PANEL);
        this.currentPane = this.panes[0];
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected OpticalThresholdProvPane getOpticalThresholdProvPane(String string, int n) {
        return new OpticalThresholdProvPane(string, this.getParentView(), this.mm, n);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        this.getButtonPanel().refreshAction();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (null == this.panes[i]) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.panes[i].getName());
            if (this.panes[i] instanceof OpticalThresholdProvPane) {
                ((OpticalThresholdProvPane)this.panes[i]).dispose();
            }
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected class OpticalThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonWarning;
        public JRadioButton buttonAlarm;
        public JButton showButton = new JButton("Refresh");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup warningAlarmButtonGroup;
        protected int ALARM_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public OpticalThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.buttonWarning = new JRadioButton("TCA", true);
            this.buttonAlarm = new JRadioButton("Alarm");
            this.warningAlarmButtonGroup = new ButtonGroup();
            this.warningAlarmButtonGroup.add(this.buttonWarning);
            this.warningAlarmButtonGroup.add(this.buttonAlarm);
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.showButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OpticalThresholdButtonPanel.this.refreshAction();
                }
            });
            this.buttonWarning.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        OpticalThresholdButtonPanel.this.button15Min.setEnabled(true);
                        OpticalThresholdButtonPanel.this.button1Day.setEnabled(true);
                    } else {
                        OpticalThresholdButtonPanel.this.button15Min.setEnabled(false);
                        OpticalThresholdButtonPanel.this.button1Day.setEnabled(false);
                    }
                }
            });
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Types "));
            jPanel.setPreferredSize(dimension);
            jPanel.add((Component)this.buttonWarning, "North");
            jPanel.add((Component)this.buttonAlarm, "South");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(dimension);
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void refreshAction() {
            int n = 0;
            OpticalThresholdPane.this.tableLabelString = " ";
            if (this.warningAlarmButtonGroup.getSelection() == this.buttonAlarm.getModel()) {
                if (db.on()) {
                    db.println("Alarm Thresholds");
                }
                n = this.ALARM_MASK;
                OpticalThresholdPane.this.tableLabelString = OpticalThresholdPane.this.tableLabelString + "Alarm Thresholds";
            } else {
                OpticalThresholdPane.this.tableLabelString = OpticalThresholdPane.this.tableLabelString + "Warning Thresholds";
                if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                    if (db.on()) {
                        db.println("1 Day");
                    }
                    n |= this.ONE_DAY_MASK;
                    OpticalThresholdPane.this.tableLabelString = OpticalThresholdPane.this.tableLabelString + ", 1 Day";
                } else {
                    OpticalThresholdPane.this.tableLabelString = OpticalThresholdPane.this.tableLabelString + ", 15 Min";
                }
            }
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("WARNING 15MIN");
                    }
                    OpticalThresholdPane.this.showPanel(OpticalThresholdPane.this.panes[0]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("WARNING 1DAY");
                    }
                    OpticalThresholdPane.this.showPanel(OpticalThresholdPane.this.panes[1]);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("ALARM TH");
                    }
                    OpticalThresholdPane.this.showPanel(OpticalThresholdPane.this.panes[2]);
                }
            }
            OpticalThresholdPane.this.tableLabel.setText(OpticalThresholdPane.this.tableLabelString);
        }
    }
}

