/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Dwdm.sValThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.SDebug;

public class OpticalThresholdTableModel
extends DwdmTableModel {
    private static final int POWER_OFFSET = 400;
    public static final float[] scaleFactor = new float[]{1.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f};
    private static final int[] LOWER_BOUND = new int[]{0, 0, 0, 0, 0, 0};
    private static final int[] UPPER_BOUND = new int[]{0, 1000, 700, 700, 700, 700};
    public static final String[] columnNames = new String[]{"Port", "Laser Bias High (%)", "RX Power High (dBm)", "RX Power Low (dBm)", "TX Power High (dBm)", "TX Power Low (dBm)"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int LBIAS_HIGH_INDEX = 1;
    public static final int RXP_HIGH_INDEX = 2;
    public static final int RXP_LOW_INDEX = 3;
    public static final int TXP_HIGH_INDEX = 4;
    public static final int TXP_LOW_INDEX = 5;
    protected int thresholdLayer;
    protected sLaserThresholds[] thresholdsVal;
    private boolean[] isDirty;
    private static final SDebug db = new SDebug("OpticalThresholdTableModel");

    public OpticalThresholdTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray, int n) {
        super(db, abstractDwdmLineModelArray);
        this.thresholdLayer = n;
        this.refreshMyLines(abstractDwdmLineModelArray);
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.isDirty = new boolean[this.numLines];
        this.thresholdsVal = new sLaserThresholds[this.numLines];
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Float.class;
            }
        }
        return Object.class;
    }

    public boolean supportTxPower(int n, int n2) {
        if (n2 == 4 || n2 == 5) {
            return this.model[n].supportsTxPower();
        }
        return true;
    }

    public boolean supportOpticsMon(int n, int n2) {
        return this.model[n].supportOpticsMon();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule() && this.supportTxPower(n, n2) && this.supportOpticsMon(n, n2)) {
                    return n2 > 0;
                }
                return false;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("no such entity in isCellEditable");
                }
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i]) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            int n3 = 0;
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    n3 = this.getThreshold((int)n).laserBias.high;
                    break;
                }
                case 2: {
                    n3 = this.getThreshold((int)n).rxPower.high - 400;
                    break;
                }
                case 3: {
                    n3 = this.getThreshold((int)n).rxPower.low - 400;
                    break;
                }
                case 4: {
                    n3 = this.getThreshold((int)n).txPower.high - 400;
                    break;
                }
                case 5: {
                    n3 = this.getThreshold((int)n).txPower.low - 400;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new Float((float)n3 / scaleFactor[n2]);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OpticalThresholdTableModel: error in getValueAt" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        db.info("Change in value " + n + " " + n2);
        boolean bl = true;
        sValThresholds sValThresholds2 = null;
        int n3 = 0;
        try {
            switch (n2) {
                case 1: {
                    bl = false;
                    sValThresholds2 = this.getThreshold((int)n).laserBias;
                    break;
                }
                case 2: {
                    bl = false;
                }
                case 3: {
                    n3 = 400;
                    sValThresholds2 = this.getThreshold((int)n).rxPower;
                    break;
                }
                case 4: {
                    bl = false;
                }
                case 5: {
                    n3 = 400;
                    sValThresholds2 = this.getThreshold((int)n).txPower;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Fail to getThreshold" + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            return;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("Fail to getThreshold" + (Object)((Object)wrongInterfaceType));
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            return;
        }
        int n4 = sValThresholds2.low;
        int n5 = sValThresholds2.high;
        if (bl) {
            n4 = LOWER_BOUND[n2];
        } else {
            n5 = UPPER_BOUND[n2];
        }
        ProvisionError provisionError = new ProvisionError("value " + object + " out of range [" + (float)(n4 - n3) / scaleFactor[n2] + ".." + (float)(n5 - n3) / scaleFactor[n2] + "]");
        try {
            if (!(object instanceof Float)) {
                db.info("Value is not type of Float");
                return;
            }
            Float f = (Float)object;
            int n6 = Math.round(f.floatValue() * scaleFactor[n2]) + n3;
            if (n6 < n4 || n6 > n5) {
                throw provisionError;
            }
            if (bl) {
                if (sValThresholds2.low == n6) {
                    return;
                }
                sValThresholds2.low = n6;
            } else {
                if (sValThresholds2.high == n6) {
                    return;
                }
                sValThresholds2.high = n6;
            }
            this.isDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ProvisionError provisionError2) {
            this.presentProvisionError(this.getColumnName(n2), provisionError2);
        }
        catch (NumberFormatException numberFormatException) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.portNames[i] = null;
            this.thresholdsVal[i] = null;
            this.isDirty[i] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) throws Exception {
        this.portNames[n] = null;
        this.thresholdsVal[n] = null;
        this.isDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws NoSuchInterface, WrongInterfaceType, ConfigError {
        if (db.on()) {
            db.println("applyToModel");
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i]) continue;
            switch (this.thresholdLayer) {
                case 0: {
                    this.model[i].setOpticsTCAThresholds(this.getThreshold(i), eIntervalType.INTERVAL_15_MIN);
                    break;
                }
                case 1: {
                    this.model[i].setOpticsTCAThresholds(this.getThreshold(i), eIntervalType.INTERVAL_DAY);
                    break;
                }
                case 2: {
                    this.model[i].setOpticsAlmThresholds(this.getThreshold(i));
                }
            }
            this.isDirty[i] = false;
        }
    }

    private sLaserThresholds getThreshold(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.thresholdsVal[n] == null) {
            switch (this.thresholdLayer) {
                case 0: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                    break;
                }
                case 1: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    break;
                }
                case 2: {
                    this.thresholdsVal[n] = this.model[n].getOpticsAlmThresholds();
                }
            }
        }
        return this.thresholdsVal[n];
    }
}

