/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sTime;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ElementPmCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.OpticsPmHistTableModel;
import cerent.cms.ui.dwdm.OpticsPmPane;
import cerent.cms.ui.dwdm.OpticsPmTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IAsyncObserver;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class OpticsPmHistPane
extends OpticsPmPane
implements IAsyncObserver,
Runnable {
    private String intervalStr = "15-minute";
    private String statusString;
    private JobStatus jobStatus;
    private ElementPmCellRenderer pmCellRenderer;
    private static final SDebug db = new SDebug("OpticsPmHistPane");

    public OpticsPmHistPane(String string, TabbedView tabbedView, IOpticsPmModel[] iOpticsPmModelArray) {
        super(string, tabbedView, iOpticsPmModelArray);
    }

    protected void localInit() {
        this.setLayout(new BorderLayout());
        this.table = new UTable((TableModel)this.dataModel);
        this.pmCellRenderer = new ElementPmCellRenderer();
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(Long.class, this.pmCellRenderer);
        this.table.setDefaultRenderer(String.class, this.pmCellRenderer);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        UTable uTable = new UTable((TableModel)this.dataModel);
        uTable.setExportable(false);
        uTable.getTableHeader().setUpdateTableInRealTime(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        for (int i = 0; i < 1; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn(tableColumn);
            tableColumn.setPreferredWidth(this.widths[i]);
            tableColumn.setResizable(false);
            tableColumn.setMinWidth(this.widths[i]);
            tableColumn.setMaxWidth(this.widths[i]);
            defaultTableColumnModel.addColumn(tableColumn);
        }
        this.table.setColumnModel(tableColumnModel);
        uTable.setColumnModel(defaultTableColumnModel);
        uTable.setPreferredScrollableViewportSize(uTable.getPreferredSize());
        uTable.getTableHeader().setReorderingAllowed(false);
        uTable.setAutoCreateColumnsFromModel(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(false);
        uTable.setCellSelectionEnabled(false);
        uTable.setRowSelectionAllowed(false);
        uScrollPane.setRowHeaderView((Component)uTable);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)uTable.getTableHeader());
        JPanel jPanel = OpticsPmHistPane.createVerticalPanel(null);
        uScrollPane.setAlignmentX(0.0f);
        jPanel.add((Component)uScrollPane);
        this.add(jPanel, "Center");
        this.add(this.createButtonBar(true), "South");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected OpticsPmTableModel createDataModel() {
        return new OpticsPmHistTableModel(this, this.nmd);
    }

    public void fixedUpColumn() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < 1; ++i) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        this.table.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshPB) {
            this.refreshNow();
        } else if (object == this.clearPB) {
            try {
                this.setCursor(3);
                int n = this.portCB.getSelectedIndex();
                ((OpticsPmHistTableModel)this.dataModel).clear(this.opticsModels[n], this);
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_CLEAR_STATS);
            }
            finally {
                this.setCursor(0);
            }
        } else if (object == this.minuteRB) {
            ((OpticsPmHistTableModel)this.dataModel).setIntervalType(eIntervalType.INTERVAL_15_MIN);
            this.intervalStr = "15-minute";
            this.refreshNow();
        } else if (object == this.dayRB) {
            ((OpticsPmHistTableModel)this.dataModel).setIntervalType(eIntervalType.INTERVAL_DAY);
            this.intervalStr = "1-day";
            this.refreshNow();
        } else if (object == this.portCB) {
            this.refreshNow();
        } else if (db.on()) {
            db.println("actionPerformed by unknown component");
        }
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        int n = Preferences.instance().getInt(this.autoRefreshPrefPath, this.autoRefreshPrefKey, 0);
        if (null != this.refreshComboBox) {
            int n2 = this.getIndexForMillis(n);
            this.refreshComboBox.setSelectedIndex(n2);
            if (null != this.refreshTimer) {
                if (0 == n2) {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer.A");
                    }
                    this.refreshTimer.stop();
                } else if (!this.refreshTimer.isRunning()) {
                    if (db.on()) {
                        db.println("Starting auto-refresh timer.B delay = " + this.refreshTimer.getDelay());
                    }
                    this.refreshTimer.start();
                } else if (db.on()) {
                    db.println("refreshTimer was already running with delay = " + this.refreshTimer.getDelay());
                }
            }
        }
        this.refreshNow();
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (null != this.refreshComboBox) {
            this.saveAutoRefreshPref();
        }
        if (null != this.refreshTimer) {
            if (db.on()) {
                db.println("Stopping auto-refresh timer.B");
            }
            this.refreshTimer.stop();
        }
        super.leavingPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshNow() {
        try {
            this.setCursor(3);
            if (this.portCB.getSelectedIndex() != -1) {
                int n = this.portCB.getSelectedIndex();
                ((OpticsPmHistTableModel)this.dataModel).refresh(this.opticsModels[n], this);
                this.updateTimeLabel(n);
            } else {
                ((OpticsPmHistTableModel)this.dataModel).refresh(null, this);
                this.dateLB.setText("");
            }
        }
        catch (InternalCommError internalCommError) {
            if (db.on()) {
                db.println("Caught InternalCommError in refreshNow!");
                SDebug.printStackTrace((Throwable)internalCommError);
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Caught NoSuchInterface in refreshNow!");
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught " + exception + " in OpticsPmHistPane.refreshNow");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void updateTimeLabel() {
        this.updateTimeLabel(this.portCB.getSelectedIndex());
    }

    protected void updateTimeLabel(int n) {
        sTime sTime2;
        try {
            sTime2 = this.nmd.getTime();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            sTime2 = new sTime(0, 0, 0, 1, 1, 1970, false);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(sTime2.year, sTime2.month - 1, sTime2.day, sTime2.hour, sTime2.minute, sTime2.second);
        this.dateLB.setText(this.intervalStr + ", near-end registers for port #" + (n + 1) + " at " + DateFormat.getDateTimeInstance(1, 1).format(gregorianCalendar.getTime()));
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OpticsPmHistPane;
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void dispose() {
        if (this.dataModel != null) {
            ((OpticsPmHistTableModel)this.dataModel).dispose();
        }
        super.dispose();
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        this.statusString = (String)object;
        this.jobStatus = jobStatus;
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (this.jobStatus == JobStatus.JOB_COMPLETE) {
            if (this.portCB.getSelectedIndex() != -1) {
                this.updateTimeLabel(this.portCB.getSelectedIndex());
            }
        } else if (this.statusString != null) {
            this.dateLB.setText("Retrieving " + this.statusString + "...");
        }
    }
}

