/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e3;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.e3.E3LinePmThresholdsPane;
import cerent.cms.ui.e3.E3LineProvPane;
import cerent.cms.ui.e3.E3PathPmThresholdsPane;
import cerent.cms.ui.e3.E3SdhPmThresholdsPane;
import cerent.cms.ui.sonet.TdmHoProvPane;
import cerent.util.TDMTerminology;
import java.awt.Component;

public class E3ProvPane
extends NodeProvPane {
    private Ds123LineModel[] lineModels = null;

    public E3ProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView);
        INodeModel iNodeModel = tabbedView.getUiModel().getNodeModel();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        this.lineModels = ds123LineModelArray;
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Line", (Component)this.getLineProvTab());
        this.subTabs.addTab("Line Thresholds", (Component)this.getLineThreshold());
        this.subTabs.addTab("Elect Path Thresholds", (Component)this.getPathThreshold());
        String string2 = tDMTerminology.getGeneralTerms(4) + " Thrshold";
        boolean bl = FramingType.getFramingType((int)iNodeModel.getFramingType()).isSonet();
        if (bl) {
            this.subTabs.addTab("SONET Thresholds", (Component)this.getSonetThreshold());
        } else {
            this.subTabs.addTab("SDH Thresholds", (Component)this.getSonetThreshold());
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        this.add((Component)this.subTabs);
    }

    private Pane getLineProvTab() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E3LineProvPane("E3 Line", this.getParentView(), this.lineModels));
    }

    private Pane getLineThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E3LinePmThresholdsPane("Line Thresholds", this.getParentView(), this.lineModels));
    }

    private Pane getPathThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E3PathPmThresholdsPane("Path Thresholds", this.getParentView(), this.lineModels));
    }

    private Pane getSonetThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E3SdhPmThresholdsPane("SDH E13 Th", this.getParentView(), this.lineModels));
    }

    private Pane getStsProvTab() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new TdmHoProvPane("SDH STM prov", this.getParentView(), this.lineModels, 1));
    }

    public boolean hasSubTabs() {
        return true;
    }
}

