/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Epos.eCardMode;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.model.EtherModuleModel;
import cerent.cms.model.Feature;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.AnnotatedException;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class EtherCardProvPane
extends NodeProvPane
implements ActionListener {
    EtherModuleModel module;
    eCardMode etherCardMode = eCardMode.MULTI_CARD_SWITCH;
    JRadioButton stitchedButton;
    JRadioButton unstitchedButton;
    JRadioButton linearButton;
    public static final int MultiCardMode = 0;
    public static final int SingleCardMode = 1;
    public static final int LinearMode = 2;
    public static final String LEAVING_LINEARCARD_WARNING = "All ports will be disabled and assigned to VLAN 1.\nPlease verify VLAN provisioning before enabling ports.\n\nOK to continue?";
    public static final String LINEARCARD_WARNING = "All ports will be disabled and this card will no longer\ncarry EtherSwitch circuit traffic.\nYou must create new circuits to individual ports.\n\nOK to continue?";
    public static final String MODE_CHANGE_WARNING = "Changing the mode with ports enabled will affect traffic.\nOK to continue?";

    public EtherCardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.module = (EtherModuleModel)this.getUiModel();
        this.stitchedButton = new JRadioButton("Multi-card EtherSwitch Group", true);
        this.unstitchedButton = new JRadioButton("Single-card EtherSwitch");
        this.linearButton = new JRadioButton("Port-mapped");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.stitchedButton);
        buttonGroup.add(this.unstitchedButton);
        buttonGroup.add(this.linearButton);
        if (this.module.getNodeModelDelegate().provides(Feature.IDL_220) && this.isUserAuthorized()) {
            this.stitchedButton.addActionListener(this);
            this.unstitchedButton.addActionListener(this);
            this.linearButton.addActionListener(this);
        } else {
            this.stitchedButton.setEnabled(false);
            this.unstitchedButton.setEnabled(false);
            this.linearButton.setEnabled(false);
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new GridLayout(3, 0, 1, 5));
        jPanel2.add(this.stitchedButton);
        jPanel2.add(this.unstitchedButton);
        jPanel2.add(this.linearButton);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Card Mode"));
        jPanel.add(jPanel2);
        this.add(jPanel, "Center");
        this.registerWithModel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!(this.etherCardMode == eCardMode.LINEAR_NO_SWITCH && this.linearButton.isSelected() || this.etherCardMode == eCardMode.SINGLE_CARD_SWITCH && this.unstitchedButton.isSelected() || this.etherCardMode == eCardMode.MULTI_CARD_SWITCH && this.stitchedButton.isSelected())) {
            this.setDirty();
        }
    }

    public void applyChangesToModel() throws Exception {
        eCardMode eCardMode2 = this.module.getEtherCardMode();
        try {
            if (eCardMode2 == eCardMode.LINEAR_NO_SWITCH) {
                if (CerentDialog.yesNoDialog((Component)((Object)this), (String)LEAVING_LINEARCARD_WARNING, (String)"Confirm Mode Change")) {
                    if (this.stitchedButton.isSelected()) {
                        this.module.setEtherCardMode(eCardMode.MULTI_CARD_SWITCH);
                    } else if (this.unstitchedButton.isSelected()) {
                        this.module.setEtherCardMode(eCardMode.SINGLE_CARD_SWITCH);
                    }
                }
            } else if (this.linearButton.isSelected()) {
                if (CerentDialog.yesNoDialog((Component)((Object)this), (String)LINEARCARD_WARNING, (String)"Confirm Mode Change")) {
                    this.module.setEtherCardMode(eCardMode.LINEAR_NO_SWITCH);
                }
            } else if (CerentDialog.yesNoDialog((Component)((Object)this), (String)MODE_CHANGE_WARNING, (String)"Confirm Mode Change")) {
                if (this.stitchedButton.isSelected()) {
                    this.module.setEtherCardMode(eCardMode.MULTI_CARD_SWITCH);
                } else if (this.unstitchedButton.isSelected()) {
                    this.module.setEtherCardMode(eCardMode.SINGLE_CARD_SWITCH);
                }
            }
        }
        catch (xInUse xInUse2) {
            throw new AnnotatedException("Unable to change card mode:\ncheck if card is supporting circuits", (Exception)((Object)xInUse2));
        }
        super.refresh();
    }

    public void refreshFromModel() throws Exception {
        this.etherCardMode = this.module.getEtherCardMode();
        this.stitchedButton.setSelected(this.etherCardMode == eCardMode.MULTI_CARD_SWITCH);
        this.unstitchedButton.setSelected(this.etherCardMode == eCardMode.SINGLE_CARD_SWITCH);
        this.linearButton.setSelected(this.etherCardMode == eCardMode.LINEAR_NO_SWITCH);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.EtherCardProvPane;
    }
}

