/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import javax.swing.table.AbstractTableModel;

public class EtherPortPm {
    private String[] textRows;
    private long[] counters;
    private long[] baselines;
    private boolean[] valid;
    private boolean baselined;
    private Long[] counterObjects;
    private AbstractTableModel tm;
    private int col;
    private int rows;

    public EtherPortPm(AbstractTableModel abstractTableModel, int n, int n2, int n3) {
        this.tm = abstractTableModel;
        this.textRows = new String[n];
        this.counters = new long[n2];
        this.baselines = new long[n2];
        this.counterObjects = new Long[n2];
        this.valid = new boolean[n2];
        this.col = n3;
        this.rows = this.textRows.length + this.counters.length;
    }

    protected long getCounter(int n) {
        if (this.baselined) {
            return this.counters[n] - this.baselines[n];
        }
        return this.counters[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectAtRow(int n) {
        if (n < this.textRows.length) {
            return this.textRows[n];
        }
        int n2 = n - this.textRows.length;
        if (n2 < this.counters.length && this.valid[n2]) {
            Long[] longArray = this.counterObjects;
            synchronized (this.counterObjects) {
                if (this.counterObjects[n2] == null) {
                    this.counterObjects[n2] = new Long(this.getCounter(n2));
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.counterObjects[n2];
            }
        }
        return null;
    }

    public void setCounter(int n, long l) {
        this.counters[n] = l;
        this.counterObjects[n] = null;
        this.valid[n] = true;
        if (this.getCounter(n) < 0L) {
            this.setBaselined(false, true);
        } else {
            this.tm.fireTableCellUpdated(this.textRows.length + n, this.col);
        }
    }

    public void setText(int n, String string) {
        this.textRows[n] = string;
        this.tm.fireTableCellUpdated(n, this.col);
    }

    public void setBaselined(boolean bl, boolean bl2) {
        if (bl) {
            System.arraycopy(this.counters, 0, this.baselines, 0, this.counters.length);
            this.resetCounterObjects();
            this.baselined = true;
            if (bl2) {
                this.fireColumnChanged();
            }
        } else if (this.baselined) {
            this.resetCounterObjects();
            this.baselined = false;
            if (bl2) {
                this.fireColumnChanged();
            }
        }
    }

    public boolean isBaselined() {
        return this.baselined;
    }

    public void invalidate(boolean bl) {
        int n;
        for (n = 0; n < this.textRows.length; ++n) {
            this.textRows[n] = null;
        }
        for (n = 0; n < this.valid.length; ++n) {
            this.valid[n] = false;
        }
        if (bl) {
            this.fireColumnChanged();
        }
    }

    private void fireColumnChanged() {
        for (int i = 0; i < this.rows; ++i) {
            this.tm.fireTableCellUpdated(i, this.col);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounterObjects() {
        Long[] longArray = this.counterObjects;
        synchronized (this.counterObjects) {
            for (int i = 0; i < this.counterObjects.length; ++i) {
                this.counterObjects[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testFill(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.textRows.length; ++n3) {
            String string = "" + n + "-" + n3 + "-" + n2;
            this.setText(n3, string);
        }
        for (n3 = 0; n3 < this.counters.length; ++n3) {
            long l = n * 10000 + n3 * 100 + n2;
            this.setCounter(n3, l);
        }
    }
}

