/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherPortModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class EtherVlanTableModel
extends AbstractTableModel {
    private EtherPortModel[] models;
    private boolean[] columnDirty;
    private int numLines;
    private IVlanModel[] allVlans;
    private IVlanModel[][] portVlans;
    private IVlanModel[] vlanTagging;
    private Attribute[][] values;
    private IEtherBridgeModel bridgeModel;
    public static final int VLAN_INDEX = 0;
    public static final int NOT_PRESENT = 0;
    public static final int TAGGED = 1;
    public static final int UNTAGGED = 2;
    private static final String PREFIX = "ETHER.";
    public static SDebug db = new SDebug("VlanTableModel");

    public EtherVlanTableModel(EtherPortModel[] etherPortModelArray) {
        if (etherPortModelArray == null) {
            db.fine("Models are null");
            return;
        }
        this.numLines = etherPortModelArray.length;
        this.models = etherPortModelArray;
        this.bridgeModel = etherPortModelArray[0].getChassis().getEtherBridgeModel();
        this.init();
    }

    public void init() {
        this.allVlans = this.getAllVlans();
        int n = this.allVlans != null ? this.allVlans.length : 0;
        this.vlanTagging = new IVlanModel[this.numLines];
        this.portVlans = new IVlanModel[this.numLines][];
        this.values = new Attribute[n][this.numLines];
        this.columnDirty = new boolean[this.numLines + 1];
        this.resetColumnDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeVlans() {
        EtherVlanTableModel etherVlanTableModel = this;
        synchronized (etherVlanTableModel) {
            if (db.on()) {
                db.println("initializing ...");
            }
            this.allVlans = null;
            this.init();
        }
        this.fireTableDataChanged();
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "VLAN";
        }
        return "Port " + n;
    }

    public int getColumnCount() {
        return this.numLines + 1;
    }

    public IVlanModel[] getAllVlans() {
        if (this.allVlans == null) {
            try {
                this.allVlans = this.bridgeModel.getVlanList();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.finer("Exception in getAllVlans() " + (Object)((Object)abstractCmsIOException));
            }
        }
        return this.allVlans;
    }

    public IVlanModel[] getPortVlans(int n) {
        if (this.portVlans[n] == null) {
            try {
                this.portVlans[n] = this.models[n].getBridgePortVlans();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.finer("Exception in getPortVlans() " + (Object)((Object)abstractCmsIOException));
            }
        }
        return this.portVlans[n];
    }

    public IVlanModel getPortVlanTagging(int n) {
        if (this.vlanTagging[n] == null) {
            try {
                this.vlanTagging[n] = this.models[n].getPortVlanTagging();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.finer("Exception in getPortVlanTagging() " + (Object)((Object)abstractCmsIOException));
            }
        }
        return this.vlanTagging[n];
    }

    private Attribute getAttributeFor(int n, IVlanModel iVlanModel) {
        if (this.isTaggedVlan(n, iVlanModel)) {
            return this.getAttributeFor(2);
        }
        if (this.vlanBelongsToPort(n, iVlanModel)) {
            return this.getAttributeFor(1);
        }
        return this.getAttributeFor(0);
    }

    private boolean vlanBelongsToPort(int n, IVlanModel iVlanModel) {
        IVlanModel[] iVlanModelArray = this.getPortVlans(n);
        return iVlanModelArray != null && Arrays.asList(iVlanModelArray).indexOf(iVlanModel) > -1;
    }

    public IVlanModel[] getVlanArrayForPort(int n) {
        ArrayList<IVlanModel> arrayList = new ArrayList<IVlanModel>();
        if (this.getAllVlans() != null) {
            for (int i = 0; i < this.allVlans.length; ++i) {
                Attribute attribute = (Attribute)this.getValueAt(i, n + 1);
                if (attribute.getIntValue() != 2 && attribute.getIntValue() != 1) continue;
                arrayList.add(this.allVlans[i]);
            }
        }
        return arrayList.toArray(new IVlanModel[0]);
    }

    public IVlanModel getUntaggedVlanForPort(int n) {
        if (this.getAllVlans() != null) {
            for (int i = 0; i < this.allVlans.length; ++i) {
                Attribute attribute = (Attribute)this.getValueAt(i, n + 1);
                if (attribute.getIntValue() != 2) continue;
                return this.allVlans[i];
            }
        }
        return null;
    }

    public int getNumberOfUntagged(int n) {
        int n2 = 0;
        if (this.getAllVlans() != null) {
            for (int i = 0; i < this.allVlans.length; ++i) {
                Attribute attribute = (Attribute)this.getValueAt(i, n + 1);
                if (attribute.getIntValue() != 2) continue;
                ++n2;
            }
        }
        return n2;
    }

    private boolean isTaggedVlan(int n, IVlanModel iVlanModel) {
        return iVlanModel != null ? iVlanModel.equals(this.getPortVlanTagging(n)) : false;
    }

    public boolean isColumnDirty(int n) {
        return this.columnDirty[n + 1];
    }

    public Attribute getAttributeFor(int n) {
        return ElementDefaults.getAttributeMap((IModel)this.models[0].getNodeModel()).getAttributeForVal("ETHER.Vlan", n);
    }

    public int getRowCount() {
        if (this.allVlans != null) {
            return this.allVlans.length;
        }
        return 0;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.models != null && this.models.length > 0 && AbstractPane.isUserAuthorized(this.models[0], SecurityLevel.PROVISIONING)) {
            return n2 > 0;
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 > this.numLines + 1 || n > this.allVlans.length) {
            if (db.on()) {
                db.println("SOMETHING WRONG in getValue rowNo = " + n + "ColumnNo = " + n2);
            }
            return null;
        }
        if (n2 == 0) {
            return this.allVlans[n];
        }
        if (this.values[n][n2 - 1] == null) {
            if (EtherVlanTableModel.db.on) {
                db.println("getValueAt: refreshing row " + n + ", port " + (n2 - 1));
            }
            this.values[n][n2 - 1] = this.getAttributeFor(n2 - 1, this.allVlans[n]);
        }
        return this.values[n][n2 - 1];
    }

    public void setValueAt(Object object, int n, int n2) {
        if ((n2 > this.numLines + 1 || n > this.allVlans.length) && db.on()) {
            db.println("SOMETHING WRONG in getValue rowNo = " + n + "ColumnNo = " + n2);
        }
        if (n2 > 0) {
            this.values[n][n2 - 1] = (Attribute)object;
        }
        this.columnDirty[n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap((IModel)this.models[0].getNodeModel()).getAttributeForVal(PREFIX + string, n);
    }

    public void resetColumnDirty() {
        for (int i = 0; i <= this.numLines; ++i) {
            this.columnDirty[i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        this.portVlans[n] = null;
        this.vlanTagging[n] = null;
        for (int i = 0; i < this.allVlans.length; ++i) {
            this.values[i][n] = null;
        }
        this.fireTableDataChanged();
    }

    public void refresh() {
        this.allVlans = null;
        this.init();
        this.fireTableDataChanged();
    }

    private static void debug(String string) {
        if (EtherVlanTableModel.db.on) {
            db.println(string);
        }
    }
}

