/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.Epos.sLearnedAddress;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BridgePortAssociation;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EtherBackPlaneModel;
import cerent.cms.model.EtherModuleModel;
import cerent.cms.model.HoCircuitPartModel;
import cerent.cms.model.HoConnectionModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.VlanModel;
import cerent.cms.ui.ether.EtherMacAddrTableModel;
import cerent.cms.ui.ether.MacAddrColumnRenderer;
import cerent.cms.ui.ether.MacAddrSourceInfo;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class MacAddrDataSource
extends AbstractRowDataSource {
    private static SDebug db = new SDebug("MacAddrDataSource");
    private EtherModuleModel model = null;
    private HashMap vlanMap = new HashMap();
    private TreeMap portTreeMap = new TreeMap(new SlotPortHoComparator());
    private TreeMap vlanTreeMap = new TreeMap();
    private MacAddrSourceInfo[] macAddrInfoList = new MacAddrSourceInfo[0];

    public void setModel(EtherModuleModel etherModuleModel) {
        this.model = etherModuleModel;
    }

    public void getLearnedAddressList() {
        block6: {
            if (this.model == null) {
                return;
            }
            this.vlanTreeMap = new TreeMap();
            this.portTreeMap = new TreeMap(new SlotPortHoComparator());
            try {
                sLearnedAddress[] sLearnedAddressArray = this.model.getLearnedAddressList();
                this.vlanMap = this.getVlans();
                this.macAddrInfoList = new MacAddrSourceInfo[sLearnedAddressArray.length];
                for (int i = 0; i < sLearnedAddressArray.length; ++i) {
                    this.macAddrInfoList[i] = this.createMacAddrInfo(sLearnedAddressArray[i]);
                }
                this.fireDataSourceChanged();
            }
            catch (xNoSuchEquipment xNoSuchEquipment2) {
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_GET_LEARNED_ADDR);
                if (MacAddrDataSource.db.on) {
                    SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
                }
                this.macAddrInfoList = new MacAddrSourceInfo[0];
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_GET_LEARNED_ADDR);
                if (!MacAddrDataSource.db.on) break block6;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    private HashMap getVlans() {
        HashMap<Short, String> hashMap = new HashMap<Short, String>();
        IEtherBridgeModel iEtherBridgeModel = this.model.getChassis().getEtherBridgeModel();
        List<IVlanModel> list = Arrays.asList(iEtherBridgeModel.getVlanList());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VlanModel vlanModel = (VlanModel)iterator.next();
            short s = vlanModel.getId();
            hashMap.put(new Short(s), vlanModel.getName());
        }
        return hashMap;
    }

    public String getCircuitName(sCircuitId sCircuitId2) {
        ConnectionModelsDelegate connectionModelsDelegate = (ConnectionModelsDelegate)this.model.getChassis().getNodeModelDelegate().getConnectionModels();
        if (connectionModelsDelegate == null || sCircuitId2 == null) {
            if (db.on()) {
                db.println("getCircuitName( " + sCircuitId2 + " ) cannot get ConnectionModels");
            }
            return null;
        }
        return connectionModelsDelegate.getCircuitName(sCircuitId2);
    }

    public HashMap getVlanMap() {
        return this.vlanMap;
    }

    private MacAddrSourceInfo createMacAddrInfo(sLearnedAddress sLearnedAddress2) {
        Object object;
        Serializable serializable;
        Object object2;
        int n = -1;
        int[] nArray = null;
        IHoNum iHoNum = null;
        boolean bl = false;
        sCircuitId sCircuitId2 = null;
        try {
            this.model.getChassis().getEntityTableModel().getEntityModelByIndex(sLearnedAddress2.ifIndex);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            bl = true;
        }
        if (bl) {
            EtherBackPlaneModel etherBackPlaneModel;
            block26: {
                object2 = this.model.getChassis().getNodeModelDelegate();
                serializable = (ConnectionModelsDelegate)((NodeModelDelegate)object2).getConnectionModels();
                object = null;
                try {
                    etherBackPlaneModel = (EtherBackPlaneModel)((NodeModelDelegate)object2).getIfModels().getInterfaceModel(sLearnedAddress2.ifIndex);
                }
                catch (Exception exception) {
                    etherBackPlaneModel = null;
                    if (MacAddrDataSource.db.on) {
                        db.println("failed to getInterfaceModel in createMacAddrInfo");
                    }
                    if (!MacAddrDataSource.db.on) break block26;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (etherBackPlaneModel == null) {
                if (MacAddrDataSource.db.on) {
                    db.println("EtherBackPlaneModel is null");
                }
            } else {
                if (MacAddrDataSource.db.on) {
                    db.println("Learned by Ether backend port");
                }
                if ((object = etherBackPlaneModel.getHoConnection()) == null) {
                    if (MacAddrDataSource.db.on) {
                        db.println("HoConnection for " + etherBackPlaneModel.getIndex() + " is null");
                    }
                } else {
                    BridgePortAssociation[] bridgePortAssociationArray = ((HoConnectionModel)object).getBridgePortAssociations();
                    if (bridgePortAssociationArray != null && bridgePortAssociationArray.length > 0) {
                        for (int i = 0; i < bridgePortAssociationArray.length; ++i) {
                            BridgePortAssociation bridgePortAssociation = bridgePortAssociationArray[i];
                            if (bridgePortAssociation.getEtherBackPlane().getIndex() != etherBackPlaneModel.getIndex()) continue;
                            EntityModel entityModel = null;
                            try {
                                if (bridgePortAssociation.getPool() != null) {
                                    entityModel = (EntityModel)bridgePortAssociation.getPool().getEntityModel();
                                }
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                entityModel = null;
                            }
                            if (entityModel == null) {
                                if (MacAddrDataSource.db.on) {
                                    db.println("There is no OC counterpart to the Ether backend");
                                }
                                if (MacAddrDataSource.db.on) {
                                    db.println("The Ether backend port is " + etherBackPlaneModel.getIndex());
                                }
                            } else {
                                if (MacAddrDataSource.db.on) {
                                    db.println("Ether IfIndex " + etherBackPlaneModel.getIndex() + " maps to OC IfIndex " + entityModel.getIndex());
                                }
                                sCircuitId2 = CircuitIdFactory.getCircuitId(((HoCircuitPartModel)object).getCircuitId());
                                n = entityModel.getSlot();
                                nArray = ((PortModel)entityModel).getPortNum();
                                iHoNum = bridgePortAssociation.getStartingHo();
                            }
                            break;
                        }
                    }
                }
            }
        } else {
            if (MacAddrDataSource.db.on) {
                db.println("Learned by Ether frontport");
            }
            n = this.getSlotInt(sLearnedAddress2.ifIndex);
            nArray = this.getPortInt(sLearnedAddress2.ifIndex);
        }
        object2 = new MacAddrSourceInfo(sLearnedAddress2, sCircuitId2, n, nArray, iHoNum);
        this.portTreeMap.put(object2, new Integer(sLearnedAddress2.ifIndex));
        serializable = new Short(sLearnedAddress2.vlanId);
        object = (String)this.vlanMap.get(serializable);
        if (object != null) {
            this.vlanTreeMap.put((String)object + " (" + (Short)serializable + ")", serializable);
        }
        return object2;
    }

    public TreeMap getPortTreeMap() {
        return this.portTreeMap;
    }

    public TreeMap getVlanTreeMap() {
        return this.vlanTreeMap;
    }

    public void clearLearnedAddress() {
        if (this.model == null) {
            return;
        }
        try {
            this.model.clearLearnedAddress();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_CLEAR_LEARNED_ADDR);
            if (MacAddrDataSource.db.on) {
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            }
            return;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_CLEAR_LEARNED_ADDR);
            if (MacAddrDataSource.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            return;
        }
        this.macAddrInfoList = new MacAddrSourceInfo[0];
        this.fireDataSourceChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelectedRows(EtherMacAddrTableModel etherMacAddrTableModel, int[] nArray) {
        if (this.model == null) {
            return;
        }
        sLearnedAddress[] sLearnedAddressArray = new sLearnedAddress[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            MacAddrSourceInfo macAddrSourceInfo = (MacAddrSourceInfo)etherMacAddrTableModel.getValueAt(nArray[i], 0);
            sLearnedAddressArray[i] = macAddrSourceInfo.getLearnedAddress();
        }
        try {
            this.model.deleteLearnedAddressList(sLearnedAddressArray, true, true, false);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_CLEAR_SELECTED_ROWS);
            if (MacAddrDataSource.db.on) {
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_CLEAR_SELECTED_ROWS);
            if (MacAddrDataSource.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        finally {
            this.getLearnedAddressList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearByVlan(short s) {
        if (this.model == null) {
            return;
        }
        sLearnedAddress sLearnedAddress2 = new sLearnedAddress(new sEtherMacAddr(new byte[6]), s, 0);
        sLearnedAddress[] sLearnedAddressArray = new sLearnedAddress[]{sLearnedAddress2};
        try {
            this.model.deleteLearnedAddressList(sLearnedAddressArray, true, false, false);
            if (MacAddrDataSource.db.on) {
                db.println("deleting by VLAN " + s);
            }
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_CLEAR_BY_PARAM_1, (Object)"VLAN");
            if (MacAddrDataSource.db.on) {
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_CLEAR_BY_PARAM_1, (Object)"VLAN");
            if (MacAddrDataSource.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        finally {
            this.getLearnedAddressList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearByPort(int n) {
        if (this.model == null) {
            return;
        }
        sLearnedAddress sLearnedAddress2 = new sLearnedAddress(new sEtherMacAddr(new byte[6]), 0, n);
        sLearnedAddress[] sLearnedAddressArray = new sLearnedAddress[]{sLearnedAddress2};
        try {
            this.model.deleteLearnedAddressList(sLearnedAddressArray, false, false, true);
            if (MacAddrDataSource.db.on) {
                db.println("deleting by Port " + n);
            }
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_CLEAR_BY_PARAM_1, (Object)"Port");
            if (MacAddrDataSource.db.on) {
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_MAC_CLEAR_BY_PARAM_1, (Object)"Port");
            if (MacAddrDataSource.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        finally {
            this.getLearnedAddressList();
        }
    }

    private Frame getFrame() {
        return this.model.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    public int getRowCount() {
        return this.macAddrInfoList.length;
    }

    public Object getObjectAtRow(int n) {
        return this.macAddrInfoList[n];
    }

    public Collection getAllObjects() {
        return Arrays.asList(this.macAddrInfoList);
    }

    private int getSlotInt(int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)this.model.getChassis().getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return -1;
        }
        if (entityModel != null && entityModel instanceof PortModel) {
            return entityModel.getSlot();
        }
        return -1;
    }

    private int[] getPortInt(int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)this.model.getChassis().getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return null;
        }
        if (entityModel != null && entityModel instanceof PortModel) {
            return ((PortModel)entityModel).getPortNum();
        }
        return null;
    }

    class SlotPortHoComparator
    implements Comparator {
        SlotPortHoComparator() {
        }

        public int compare(Object object, Object object2) {
            return MacAddrColumnRenderer.compareSlotPortHo((MacAddrSourceInfo)object, (MacAddrSourceInfo)object2);
        }
    }
}

