/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Epos.sLearnedAddress;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.HoLoHelper;
import cerent.util.IHoNum;

class MacAddrSourceInfo {
    private sLearnedAddress learnedAddress;
    private sCircuitId circuitId;
    private String vlanName;
    private int slotNo;
    private int[] portNo;
    private IHoNum startingHo;

    public MacAddrSourceInfo(sLearnedAddress sLearnedAddress2, sCircuitId sCircuitId2, int n, int[] nArray, IHoNum iHoNum) {
        this.learnedAddress = sLearnedAddress2;
        this.circuitId = sCircuitId2;
        this.slotNo = n;
        this.portNo = nArray;
        this.startingHo = iHoNum;
    }

    public sLearnedAddress getLearnedAddress() {
        return this.learnedAddress;
    }

    public sCircuitId getCircuitId() {
        return this.circuitId;
    }

    public int getSlot() {
        return this.slotNo;
    }

    public int[] getPortNum() {
        return this.portNo;
    }

    public IHoNum getHo() {
        return this.startingHo;
    }

    public String getSlotPortHo() {
        if (this.slotNo == -1 || this.portNo == null) {
            return "unknown";
        }
        String string = "s" + this.slotNo + "/p" + PortHelper.getConcatenatedString((int[])this.portNo);
        if (this.startingHo != null) {
            String string2 = HoLoHelper.getDisplay(this.startingHo, true);
            string = string + "/" + string2;
        }
        return string;
    }

    public String toString() {
        return this.getSlotPortHo();
    }
}

