/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.AlarmPane;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.FilterDialog;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.row.RowDataSource;
import java.awt.Component;

public class NodeAlarmPane
extends AlarmPane {
    public NodeAlarmPane(String string, NodeModelDelegate nodeModelDelegate, TabbedView tabbedView, ElementAlarmStore elementAlarmStore, IEventPanelController iEventPanelController) {
        super(string, nodeModelDelegate, tabbedView, elementAlarmStore, iEventPanelController);
    }

    protected EventPanel createEventPanel(IEventPanelController iEventPanelController) {
        INodeModel iNodeModel = this.getUiModel().getNodeModel();
        int n = 16;
        if (!iNodeModel.isMultishelf()) {
            n |= 0x400;
        }
        return new EventPanel((RowDataSource)this.alarmStore, iEventPanelController, n);
    }

    protected void removeClearedAlarms() {
        try {
            this.alarmStore.removeClearedAlarms();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncAlarms() {
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.alarmStore;
        try {
            this.setCursor(3);
            elementAlarmStore.flushAlarmStore();
            elementAlarmStore.getPendingAlarms();
        }
        catch (Exception exception) {
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_COMMUNICATION_ERROR_PARAM_1, exception.getMessage(), exception.toString());
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void showFilterDialog() {
        try {
            INodeModel[] iNodeModelArray = new INodeModel[]{(INodeModel)this.uiModel};
            this.alarmStore.getEventFilter().setNodeModel(iNodeModelArray);
            new FilterDialog(this, this.alarmStore.getEventFilter(), "Alarm Filter").show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected INodeModel getAffectedNodeModel(EventInfo eventInfo) {
        INodeModel iNodeModel = this.getUiModel().getNodeModel();
        INodeModel iNodeModel2 = null;
        if (iNodeModel instanceof INodeModel) {
            iNodeModel2 = iNodeModel;
        }
        return iNodeModel2;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.AlarmPane;
    }
}

