/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.idl.FCMedia.eFCMediaType;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.FcmrPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.RmonModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.CardInventoryPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.fcmr.FcmrMaintenancePane;
import cerent.cms.ui.fcmr.FcmrPmPane;
import cerent.cms.ui.fcmr.FcmrProvPane;
import cerent.util.UObservable;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;

public class FcmrCardTabbedView
extends CardTabbedView
implements Observer {
    private LineObservable _myObs;
    private FcmrPortModel[] portModels;
    private FcmrLineModel[] lineModels;
    private eFCMediaType[] mediaTypes;

    public FcmrCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        this.init();
    }

    public void init() {
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        this.portModels = (FcmrPortModel[])moduleModel.getPortModels();
        this.lineModels = (FcmrLineModel[])moduleModel.getLineModels();
        this.mediaTypes = new eFCMediaType[this.lineModels.length];
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].addObserver(this);
            try {
                this.mediaTypes[i] = this.lineModels[i].getPortMediaTypeEnum();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.showTabs();
    }

    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Inventory", (Component)this.getInventoryTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    public Pane getMaintenanceTab() {
        return new FcmrMaintenancePane("FcmrMaintPane", this, (FcmrModuleModel)this.getUiModel(), this.portModels, this.lineModels);
    }

    public Pane getPerformanceTab() {
        return new FcmrPmPane("Performance ", this, FcmrLineModel.filterUndefinedMedia(this.lineModels));
    }

    public Pane getProvTab() {
        return new FcmrProvPane("FcmrProvPane", this, (FcmrModuleModel)this.getUiModel(), this.portModels, this.lineModels);
    }

    public Pane getInventoryTab() {
        return new CardInventoryPane("Inventory", this);
    }

    public void destroy() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
        super.destroy();
    }

    public Observable getObservable() {
        if (this._myObs == null) {
            this._myObs = new LineObservable();
        }
        return this._myObs;
    }

    public void update(Observable observable, Object object) {
        int n = -1;
        RmonLineUpdate rmonLineUpdate = null;
        n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
        if (db.on()) {
            db.println("FcmrCardTabbedView received an update for " + observable + " type: " + object);
        }
        if (n == 1 && observable instanceof FcmrLineModel) {
            for (int i = 0; i < this.lineModels.length; ++i) {
                if (this.lineModels[i] != observable) continue;
                try {
                    eFCMediaType eFCMediaType2 = this.lineModels[i].getPortMediaTypeEnum();
                    if (this.mediaTypes[i] != eFCMediaType2 && (this.mediaTypes[i] == eFCMediaType.FCMR_UNDEFINED || eFCMediaType2 == eFCMediaType.FCMR_UNDEFINED)) {
                        rmonLineUpdate = new RmonLineUpdate(RmonModel.getRmonModels(FcmrLineModel.filterUndefinedMedia(this.lineModels)));
                    }
                    this.mediaTypes[i] = eFCMediaType2;
                }
                catch (Exception exception) {}
                break;
            }
        }
        if (this._myObs != null && rmonLineUpdate != null) {
            this._myObs.changed();
            this._myObs.notifyObservers(rmonLineUpdate);
        }
    }

    private class LineObservable
    extends UObservable {
        private LineObservable() {
        }

        public void changed() {
            this.setChanged();
        }
    }
}

