/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.FcmrPortModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.MaintBandwidthPane;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SoakMaintenancePane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.fcmr.FcmrLineMaintPane;
import cerent.cms.ui.sonet.TdmInfoMaintenancePane;
import cerent.util.SDebug;
import java.awt.Component;
import javax.swing.JLabel;

public class FcmrMaintenancePane
extends NodeProvPane {
    private FcmrModuleModel fcmrModel;
    private FcmrPortModel[] portModels = null;
    private FcmrLineModel[] lineModels = null;
    private static final String BANDWIDTH_TAB = "Bandwidth";
    private static final SDebug db = new SDebug("FcmrMaintenancePane");

    public FcmrMaintenancePane(String string, CardTabbedView cardTabbedView, FcmrModuleModel fcmrModuleModel, FcmrPortModel[] fcmrPortModelArray, FcmrLineModel[] fcmrLineModelArray) {
        super(string, cardTabbedView);
        if (fcmrPortModelArray == null || fcmrLineModelArray == null) {
            db.println("ERROR: Line or Port Models are null!");
            this.add(new JLabel("This pane is unimplemented."));
            return;
        }
        this.fcmrModel = fcmrModuleModel;
        this.portModels = fcmrPortModelArray;
        this.lineModels = fcmrLineModelArray;
        this.subTabs = new SubTabbedView(this.getUiModel(), cardTabbedView);
        if (fcmrModuleModel.supportsJ1PathTrace(fcmrLineModelArray)) {
            this.subTabs.addTab("Path Trace", (Component)CardTabbedView.getPathTracePane(fcmrLineModelArray, this.subTabs));
        }
        this.subTabs.addTab("Loopback", (Component)this.getLoopbackTab());
        this.subTabs.addTab(BANDWIDTH_TAB, (Component)this.getBandwidthTab());
        if (this.pci.supportsTdmInfo()) {
            this.subTabs.addTab("Info", (Component)((Object)new TdmInfoMaintenancePane("Info", cardTabbedView)));
        }
        this.subTabs.addTab("AINS Soak", (Component)((Object)new SoakMaintenancePane("AINS Soak", cardTabbedView, fcmrLineModelArray, true)));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    private Pane getLoopbackTab() {
        return new FcmrLineMaintPane("FcmrLineMaintPane", this.getParentView(), this.portModels, this.lineModels);
    }

    private Pane getBandwidthTab() {
        return new MaintBandwidthPane("FcmrMaintBandwidthPane", this.getParentView(), this.fcmrModel);
    }

    public boolean hasSubTabs() {
        return true;
    }
}

