/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.FCMedia.sFCLineAdminInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.IgnorableDialog;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;

public class FcmrPortEnhancedFCFiconTableModel
extends AbstractTableModel {
    private JPanel parent = null;
    private FcmrLineModel[] lineModels = null;
    protected boolean[][] isDirty = null;
    protected int numLines = 0;
    private sFCLineAdminInfo[] lineAdminInfo = null;
    protected EntityCellRenderer myPortRenderer;
    public String[] columnNames;
    public static final String[] fcmrColumnNames = new String[]{"Port", "Ingress Idle Filtering", "Maximum Frame Size"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int INGRESS_FILTERING = 1;
    public static final int FRAME_SIZE = 2;
    public static final short MIN_FRAME_SIZE = 2148;
    public static final short MAX_FRAME_SIZE = 2172;
    public static final short FRAME_SIZE_INCREMENT = 4;
    private static final SDebug db = new SDebug("FcmrPortEnhancedFCFiconTableModel");

    public FcmrPortEnhancedFCFiconTableModel(JPanel jPanel, FcmrLineModel[] fcmrLineModelArray) {
        this.parent = jPanel;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.init(fcmrLineModelArray);
    }

    private void init(FcmrLineModel[] fcmrLineModelArray) {
        this.lineModels = fcmrLineModelArray;
        this.numLines = fcmrLineModelArray.length;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.columnNames = fcmrColumnNames;
        this.lineAdminInfo = new sFCLineAdminInfo[this.numLines];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            if (this.lineModels[n].isMediaUndefined()) {
                return false;
            }
            return n2 > 0;
        }
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private sFCLineAdminInfo getLineAdminInfo(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineAdminInfo[n] == null) {
            this.lineAdminInfo[n] = this.lineModels[n].getFcLineAdminInfo();
        }
        return this.lineAdminInfo[n];
    }

    public int getColumnCount() {
        return fcmrColumnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Boolean getIngressFiltering(int n) throws NoSuchInterface, WrongInterfaceType {
        return new Boolean(this.getLineAdminInfo((int)n).ingressFiltering);
    }

    public Short getMaxFrameSize(int n) throws NoSuchInterface, WrongInterfaceType {
        return new Short(this.getLineAdminInfo((int)n).maxFrameSize);
    }

    protected boolean setFrameSize(String string, int n) {
        short s = 2148;
        String string2 = Short.toString((short)2148);
        String string3 = Short.toString((short)2172);
        String string4 = Short.toString((short)4);
        try {
            s = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError(this.parent, EMC.EID_FCMR_INVALID_MAX_FRAMES_PARAM_3, string2, string3, string4);
            return false;
        }
        if (this.lineAdminInfo[n].maxFrameSize == s) {
            return false;
        }
        if (2148 > s || s > 2172 || s % 4 != 0) {
            ErrorMsg.displayError(this.parent, EMC.EID_FCMR_INVALID_MAX_FRAMES_PARAM_3, string2, string3, string4);
            return false;
        }
        this.lineAdminInfo[n].maxFrameSize = s;
        return true;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        if (n == 1) {
            return Boolean.class;
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block7: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getPortDescriptionFor(n);
                    }
                    case 1: {
                        return this.getIngressFiltering(n);
                    }
                    case 2: {
                        return this.getMaxFrameSize(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block7;
                db.println("Error in getValueAt in FcmrPortEnhancedFCFiconTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (!this.adminStateSanityCheck(n)) {
                    return;
                }
                boolean bl2 = (Boolean)object;
                if (!bl2) {
                    IgnorableDialog.warningDialog((String)ErrorMsg.getString((EID)EMC.WID_FCMR_INGRESS_FILTER_WARNING), (String)"IngressFilter", (String)"IngressFilter Disable Warning");
                }
                this.lineAdminInfo[n].ingressFiltering = bl2;
                bl = true;
                break;
            }
            case 2: {
                if (this.adminStateSanityCheck(n) && this.setFrameSize((String)object, n)) break;
                return;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            int n = this.getColumnCount();
            for (int j = 0; j < n; ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRowDirty(int n) {
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.isDirty[n][i]) continue;
            return true;
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void resetRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void destroy() {
        this.lineModels = null;
        this.isDirty = null;
        this.lineAdminInfo = null;
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            this.lineModels[i].setFcLineAdminInfo(this.getLineAdminInfo(i));
            this.resetRowDirty(i);
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) {
        this.lineAdminInfo[n] = null;
        this.resetRowDirty(n);
    }

    private boolean adminStateSanityCheck(int n) {
        try {
            if (this.getLineAdminInfo((int)n).portState != eAdminState.ADMIN_OOS_DSBLD) {
                ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_CURR_PORT_STATE_DISALLOWS_CHANGE_PARAM_1, (Object)("not " + AdminState.getAdminTermDSBLD(this.lineModels[n].getNodeModel().getTDMTerminology())));
                return false;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("No Such Interface");
            }
            return false;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("Wrong Interface Type");
            }
            return false;
        }
        return true;
    }

    public void refreshMyLines(FcmrLineModel[] fcmrLineModelArray) {
        this.init(fcmrLineModelArray);
        this.fireTableDataChanged();
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.lineModels[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }
}

