/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.FcmrPortModel;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.fcmr.FcmrPortDistExtensionPane;
import cerent.cms.ui.fcmr.FcmrPortEnhancedFCFiconPane;
import cerent.cms.ui.fcmr.FcmrPortProvPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Observer;
import javax.swing.JLabel;

public class FcmrPortPane
extends NodeProvPane {
    private FcmrModuleModel fcmrModel;
    private FcmrPortModel[] portModels = null;
    private FcmrLineModel[] lineModels = null;
    private eCardOperMode cardMode;
    private final int PORT_PANE = 0;
    private final int DIST_EXTN_PANE = 1;
    private final int ENHANCED_FC_FICON_PANE = 2;
    private static final SDebug db = new SDebug("FcmrPortPane");

    public FcmrPortPane(String string, TabbedView tabbedView, FcmrModuleModel fcmrModuleModel, FcmrPortModel[] fcmrPortModelArray, FcmrLineModel[] fcmrLineModelArray) {
        super(string, tabbedView);
        if (fcmrPortModelArray == null || fcmrLineModelArray == null) {
            db.println("ERROR: Line or Port Models are null!");
            this.add(new JLabel("This pane is unimplemented."));
            return;
        }
        this.fcmrModel = fcmrModuleModel;
        this.fcmrModel.addObserver((Observer)((Object)this));
        this.portModels = fcmrPortModelArray;
        this.lineModels = fcmrLineModelArray;
        this.cardMode = fcmrModuleModel.getCardOperMode();
        this.subTabs = new SubTabbedView(fcmrModuleModel, tabbedView);
        this.subTabs.addTab("General", (Component)this.getPortTab());
        if (fcmrModuleModel.getCardOperMode() == eCardOperMode.OPER_MODE_FCMR_DIST_EXTN) {
            this.addDistanceExtensionModeTabs();
        }
        this.subTabs.setTabPlacement(1);
        this.add((Component)this.subTabs);
    }

    private void addDistanceExtensionModeTabs() {
        this.subTabs.addTab("Distance Extension", (Component)this.getDistanceExtensionTab());
        this.subTabs.addTab("Enhanced FC/FICON ISL", (Component)this.getEnhancedFCFiconTab());
    }

    private Pane getPortTab() {
        return new FcmrPortProvPane("FcmrPortProvPane", this.getParentView(), this.lineModels);
    }

    private Pane getDistanceExtensionTab() {
        return new FcmrPortDistExtensionPane("FcmrPortDistExtensionPane", this.getParentView(), this.lineModels);
    }

    private Pane getEnhancedFCFiconTab() {
        return new FcmrPortEnhancedFCFiconPane("FcmrPortEnhancedFCFiconPane", this.getParentView(), this.lineModels);
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void refreshFromModel() throws Exception {
        eCardOperMode eCardOperMode2 = this.fcmrModel.getCardOperMode();
        if (this.subTabs.getComponents().length == 3) {
            int n = this.subTabs.indexOfTab("Distance Extension");
            this.subTabs.removeTabAt(n);
            n = this.subTabs.indexOfTab("Enhanced FC/FICON ISL");
            this.subTabs.removeTabAt(n);
        }
        if (eCardOperMode2 == eCardOperMode.OPER_MODE_FCMR_DIST_EXTN) {
            this.addDistanceExtensionModeTabs();
        }
    }
}

