/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.FCMedia.eFCMediaType;
import cerent.cms.idl.FCMedia.eLinkRate;
import cerent.cms.idl.FCMedia.sFCLineAdminInfo;
import cerent.cms.idl.FCMedia.sFCLineInfo;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;

public class FcmrPortTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    private JPanel parent = null;
    private ModuleModel eqpmtModel = null;
    private eCardOperMode cardMode;
    private FcmrLineModel[] lineModels = null;
    protected boolean[][] isDirty = null;
    protected int numLines = 0;
    private sFCLineAdminInfo[] lineAdminInfo = null;
    private sFCLineInfo[] lineInfo = null;
    private int[] soakTime;
    public String[] columnNames;
    public static final String[] fcmrColumnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "Media Type", "Link Rate", "Max GBIC Rate", "Link Recovery", "AINS Soak"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int PORT_MEDIA_TYPE = 4;
    public static final int GBIC_RATE_INDEX = 5;
    public static final int MAX_GBIC_RATE_INDEX = 6;
    public static final int LINK_RECOVERY = 7;
    public static final int SOAK_TIME_INDEX = 8;
    protected String[] portNames;
    private AdminState[] adminState;
    private IServiceState[] serviceState;
    private Boolean[] linkRecovery;
    private static final SDebug db = new SDebug("FcmrPortTableModel");

    public FcmrPortTableModel(JPanel jPanel, ModuleModel moduleModel, FcmrLineModel[] fcmrLineModelArray) {
        this.parent = jPanel;
        this.lineModels = fcmrLineModelArray;
        this.numLines = fcmrLineModelArray == null ? 0 : fcmrLineModelArray.length;
        this.eqpmtModel = moduleModel;
        this.cardMode = this.getCardOperMode();
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.columnNames = fcmrColumnNames;
        this.portNames = new String[this.numLines];
        this.lineInfo = new sFCLineInfo[this.numLines];
        this.lineAdminInfo = new sFCLineAdminInfo[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.linkRecovery = new Boolean[this.numLines];
        this.soakTime = new int[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.soakTime[i] = -1;
        }
    }

    protected eCardOperMode getCardOperMode() {
        eCardOperMode eCardOperMode2 = this.eqpmtModel.getCardOperMode();
        return eCardOperMode2;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            switch (n2) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
                case 7: {
                    if (this.getCardOperMode() == eCardOperMode.OPER_MODE_FCMR_DIST_EXTN && this.isPortDistExtensionEnabled(n)) {
                        ErrorMsg.displayError(this.parent, EMC.EID_FCMR_INVALID_MODE_CHANGE_PARAM_2, " Link Recovery", " Distance Extension");
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private sFCLineInfo getLineInfo(int n) {
        if (this.lineInfo[n] == null) {
            try {
                this.lineInfo[n] = this.lineModels[n].getFcLineInfo();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.lineInfo[n];
    }

    private sFCLineAdminInfo getLineAdminInfo(int n) {
        if (this.lineAdminInfo[n] == null) {
            try {
                this.lineAdminInfo[n] = this.lineModels[n].getFcLineAdminInfo();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.lineAdminInfo[n];
    }

    public int getColumnCount() {
        return fcmrColumnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected Integer getLineNumberFor(int n) {
        return new Integer(n + 1);
    }

    public eFCMediaType getMediaTypeAsEnum(int n) throws NoSuchInterface {
        return eFCMediaType.from_int(this.getPortMediaType(n).getIntValue());
    }

    public eAdminState getAdminStateAsEnum(int n) throws NoSuchInterface {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.getAdminStateFromModel(n);
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    public IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.lineModels[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    public Boolean getLinkRecovery(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.linkRecovery[n] == null) {
            this.linkRecovery[n] = new Boolean(this.lineModels[n].isLinkRecoveryEnabled());
        }
        return this.linkRecovery[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getPortMediaType(int n) {
        if (this.lineAdminInfo[n] == null) {
            this.getLineAdminInfo(n);
        }
        if (this.lineAdminInfo[n] != null) {
            int n2 = 0;
            sFCLineAdminInfo[] sFCLineAdminInfoArray = this.lineAdminInfo;
            synchronized (this.lineAdminInfo) {
                n2 = this.lineAdminInfo[n].portMediaType.value();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.getAttributeFor(eFCMediaType.class.getName(), n2);
            }
        }
        if (db.on()) {
            db.println("lineAdminInfo[" + n + "] is null");
        }
        return null;
    }

    public Attribute getGbicRateFor(int n) {
        if (this.lineInfo[n] == null) {
            this.getLineInfo(n);
        }
        if (this.lineInfo[n] != null) {
            return this.getAttributeFor(eLinkRate.class.getName(), this.lineInfo[n].linkRate.value());
        }
        if (db.on()) {
            db.println("lineInfo[" + n + "] is null");
        }
        return null;
    }

    public Attribute getMaxGbicRateFor(int n) {
        if (this.lineInfo[n] == null) {
            this.getLineInfo(n);
        }
        if (this.lineInfo[n] != null) {
            eLinkRate eLinkRate2 = this.lineInfo[n].maxGBICRate;
            Attribute attribute = this.getAttributeFor(eLinkRate.class.getName(), eLinkRate2.value());
            if (eLinkRate2 == eLinkRate.FC_RATE_UNKNOWN) {
                attribute = new Attribute("Contact GBIC vendor", attribute.getValue());
            }
            return attribute;
        }
        if (db.on()) {
            db.println("lineInfo is null " + n);
        }
        return null;
    }

    public String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.lineModels[n].getAlias();
        }
        return this.portNames[n];
    }

    protected Attribute getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n);
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        if (n == 7) {
            return Boolean.class;
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block13: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 2: {
                        return this.getAdminState(n).toString(this.getTerms());
                    }
                    case 3: {
                        return this.getServiceState(n).toString(this.getTerms());
                    }
                    case 4: {
                        return this.getPortMediaType(n);
                    }
                    case 5: {
                        return this.getGbicRateFor(n);
                    }
                    case 6: {
                        return this.getMaxGbicRateFor(n);
                    }
                    case 7: {
                        return this.getLinkRecovery(n);
                    }
                    case 8: {
                        return this.getSoakTimeAsHHMM(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block13;
                db.println("Error in getValueAt in FcmrPortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                this.portNames[n] = (String)object;
                break;
            }
            case 2: {
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 4: {
                if (!this.adminStateSanityCheck(n)) {
                    return;
                }
                if (!(object instanceof Attribute)) break;
                sFCLineAdminInfo[] sFCLineAdminInfoArray = this.lineAdminInfo;
                synchronized (this.lineAdminInfo) {
                    if (this.lineAdminInfo[n] == null) {
                        this.getLineAdminInfo(n);
                    }
                    int n3 = ((Attribute)object).getIntValue();
                    this.lineAdminInfo[n].portMediaType = eFCMediaType.from_int(n3);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    break;
                }
            }
            case 7: {
                if (!this.adminStateSanityCheck(n)) {
                    return;
                }
                this.linkRecovery[n] = (Boolean)object;
                this.lineAdminInfo[n].portLinkRecovery = this.linkRecovery[n];
                break;
            }
            case 8: {
                int n4 = this.soakTime[n];
                try {
                    n4 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n4) {
                    return;
                }
                this.soakTime[n] = n4;
                break;
            }
            default: {
                return;
            }
        }
        {
            this.isDirty[n][n2] = true;
            this.fireTableCellUpdated(n, n2);
            return;
        }
    }

    private boolean isPortDistExtensionEnabled(int n) {
        boolean bl;
        block4: {
            bl = false;
            try {
                bl = this.lineModels[n].isDistExtensionEnabled();
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("No Such Interface");
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) break block4;
                db.println("Wrong Interface Type");
            }
        }
        return this.getCardOperMode() == eCardOperMode.OPER_MODE_FCMR_DIST_EXTN && bl;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            int n = this.getColumnCount();
            for (int j = 0; j < n; ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty[n][2];
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void destroy() {
        int n;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.isDirty = null;
        for (n = 0; n < this.portNames.length; ++n) {
            this.portNames[n] = null;
            this.adminState[n] = null;
            this.linkRecovery[n] = null;
            this.serviceState[n] = null;
        }
        for (n = 0; n < this.lineAdminInfo.length; ++n) {
            this.lineAdminInfo[n] = null;
        }
        this.lineAdminInfo = null;
        for (n = 0; n < this.lineInfo.length; ++n) {
            this.lineInfo[n] = null;
        }
        this.lineInfo = null;
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.isDirty[i][1]) {
                this.lineModels[i].setAlias(this.getPortName(i));
            }
            if (this.isDirty[i][8]) {
                this.lineModels[i].setSoakTime(this.getSoakTime(i));
            }
            if (!this.isDirty[i][2] && !this.isDirty[i][7] && !this.isDirty[i][4]) continue;
            sFCLineAdminInfo sFCLineAdminInfo2 = this.lineModels[i].getFcLineAdminInfo();
            sFCLineAdminInfo2.portState = this.getAdminStateAsEnum(i);
            sFCLineAdminInfo2.portMediaType = this.getMediaTypeAsEnum(i);
            if (this.isDirty[i][7]) {
                sFCLineAdminInfo2.portLinkRecovery = this.getLinkRecovery(i);
            }
            this.lineModels[i].setFcLineAdminInfo(sFCLineAdminInfo2);
        }
        this.resetDirty();
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetLineCache(int n) {
        this.lineInfo[n] = null;
        sFCLineAdminInfo[] sFCLineAdminInfoArray = this.lineAdminInfo;
        synchronized (this.lineAdminInfo) {
            this.lineAdminInfo[n] = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.portNames[n] = null;
            this.adminState[n] = null;
            this.linkRecovery[n] = null;
            this.serviceState[n] = null;
            this.soakTime[n] = -1;
            int n2 = this.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                this.isDirty[n][i] = false;
            }
            return;
        }
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.lineModels[n].getAdminStateEnum();
    }

    private boolean adminStateSanityCheck(int n) {
        if (this.adminState[n].getAdminStateEnum() != eAdminState.ADMIN_OOS_DSBLD) {
            ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_CURR_PORT_STATE_DISALLOWS_CHANGE_PARAM_1, (Object)("not " + AdminState.getAdminTermDSBLD(this.lineModels[n].getNodeModel().getTDMTerminology())));
            return false;
        }
        return true;
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    private int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.lineModels[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
    }
}

