/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.hdge;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.EtherMedia.sGmacLineAdminInfo;
import cerent.cms.idl.EtherMedia.sGmacLineAdminInfo_4_01;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.HdGeModuleModel;
import cerent.cms.model.HdGePortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class HdGeLineMaintTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    private HdGeModuleModel eqpmtModel = null;
    private HdGePortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private boolean[] rowDirty = null;
    private int numLines = 0;
    private int numPorts = 0;
    private sGmacLineAdminInfo[] lineAdminInfo = null;
    private sGmacLineAdminInfo_4_01[] lineAdminInfo_4_01 = null;
    private AdminState[] adminState = null;
    private IServiceState[] serviceState = null;
    public String[] columnNames = new String[]{"Port", "Admin State", "Service State", "Loopback Type"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int ADMIN_STATE_INDEX = 1;
    public static final int SERVICE_STATE_INDEX = 2;
    public static final int LOOPBACK_INDEX = 3;
    private static final SDebug db = new SDebug("HdGeLineMaintTableModel");

    public HdGeLineMaintTableModel(HdGeModuleModel hdGeModuleModel, HdGePortModel[] hdGePortModelArray, EtherLineModel[] etherLineModelArray) {
        this.portModels = hdGePortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = hdGePortModelArray == null ? 0 : hdGePortModelArray.length;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.eqpmtModel = hdGeModuleModel;
        this.rowDirty = new boolean[this.numPorts];
        this.adminState = new AdminState[this.numPorts];
        this.serviceState = new IServiceState[this.numPorts];
        this.lineAdminInfo = new sGmacLineAdminInfo[this.numPorts];
        this.lineAdminInfo_4_01 = new sGmacLineAdminInfo_4_01[this.numPorts];
        this.resetRowDirty();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.portModels != null && this.numPorts > 0 && n < this.numLines && AbstractPane.isUserAuthorized(this.portModels[0], SecurityLevel.MAINTENANCE)) {
            try {
                return n2 == 1 || n2 == 3 && AdminState.admitsLoopback(this.getAdminStateFor(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public sGmacLineAdminInfo getLineAdminInfo(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineAdminInfo[n] == null) {
            this.lineAdminInfo[n] = this.lineModels[n].getGmacLineAdminInfo();
        }
        if (!AdminState.admitsLoopback(this.getAdminStateFor(n))) {
            this.lineAdminInfo[n].loopback = false;
        }
        return this.lineAdminInfo[n];
    }

    public sGmacLineAdminInfo_4_01 getLineAdminInfo_4_01(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineAdminInfo_4_01[n] == null) {
            this.lineAdminInfo_4_01[n] = this.lineModels[n].getGmacLineAdminInfo_4_01();
        }
        if (!AdminState.admitsLoopback(this.getAdminStateFor(n))) {
            this.lineAdminInfo_4_01[n].loopback = eLoopback.NO_LOOPBACK;
        }
        return this.lineAdminInfo_4_01[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private Integer getLineNumberFor(int n) {
        return new Integer(n + 1);
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.getAdminStateFromModel(n);
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.getServiceStateFromModel(n);
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        InterfaceModel interfaceModel = (InterfaceModel)this.portModels[n].getInterfaceModel();
        return interfaceModel.getAdminStateEnum();
    }

    protected sServiceState getServiceStateFromModel(int n) throws NoSuchInterface {
        InterfaceModel interfaceModel = (InterfaceModel)this.portModels[n].getInterfaceModel();
        return interfaceModel.getServiceState();
    }

    public eAdminState getAdminStateFor(int n) throws NoSuchInterface {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public int getLoopbackFor(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getLoopback(n).getIntValue();
    }

    private Attribute getLoopback(int n) throws NoSuchInterface, WrongInterfaceType {
        this.getLineAdminInfo(n);
        return this.getAttributeFor("G1000 Loopback Type", this.getLineAdminInfo_4_01((int)n).loopback.value());
    }

    private Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string, n);
    }

    public int getRowCount() {
        return this.numPorts;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block8: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 3: {
                        return this.getLoopback(n);
                    }
                    case 1: {
                        return this.getAdminState(n).toString(this.getTerms());
                    }
                    case 2: {
                        return this.getServiceState(n).toString(this.getTerms());
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block8;
                db.println("Error in getValueAt in HdGePortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 3: {
                if (!(object instanceof Attribute)) break;
                int n3 = ((Attribute)object).getIntValue();
                try {
                    this.getLineAdminInfo((int)n).loopback = n3 != 0;
                    this.getLineAdminInfo_4_01((int)n).loopback = eLoopback.from_int(n3);
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableRowsUpdated(n, n);
    }

    public void resetRowDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        this.lineAdminInfo[n] = null;
        this.lineAdminInfo_4_01[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.fireTableRowsUpdated(n, n);
    }

    public void refresh() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineAdminInfo[i] = null;
            this.lineAdminInfo_4_01[i] = null;
            this.adminState[i] = null;
            this.serviceState[i] = null;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void destroy() {
        this.portModels = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.rowDirty = null;
        for (int i = 0; i < this.lineAdminInfo.length; ++i) {
            this.lineAdminInfo[i] = null;
            this.lineAdminInfo_4_01[i] = null;
            this.adminState[i] = null;
            this.serviceState[i] = null;
        }
        this.lineAdminInfo = null;
        this.lineAdminInfo_4_01 = null;
        this.adminState = null;
        this.serviceState = null;
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    public boolean isAdminStateDirty(int n) {
        boolean bl = false;
        try {
            bl = this.isRowDirty(n) && this.getAdminStateFor(n) != this.getAdminStateFromModel(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

