/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.Attribute;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedCardOperMode;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class L2scCardProvPane
extends NodeProvPane
implements ActionListener {
    private JComboBox modeCB = null;
    private L2scModuleModel model = (L2scModuleModel)this.getParentView().getUiModel();
    private static final String errMsg = "Card is in use";
    private static final String warnMsg = "This action will reboot the card. Any unsaved configuration changes will be lost unless a write command is issued via CLI. Continue?";
    private static final String warnTitle = "Card will reboot.";

    public L2scCardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel(new FlowLayout(0, 10, 10));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(new JLabel("Mode: "));
        this.modeCB = new JComboBox<Attribute>(this.getAttributeFor("L2scCardMode"));
        Dimension dimension = new Dimension(100, 20);
        this.modeCB.setPreferredSize(dimension);
        this.modeCB.setMinimumSize(dimension);
        this.modeCB.setMaximumSize(dimension);
        this.modeCB.addActionListener(this);
        this.enableComponent(this.modeCB);
        jPanel.add(this.modeCB);
        this.add(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            db.severe("Null actionPerformed source");
            return;
        }
        this.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangesToModel() throws Exception {
        eCardOperMode eCardOperMode2 = this.getCardModeFromCB();
        if (eCardOperMode2 != this.model.getCardOperMode()) {
            boolean bl = true;
            if (this.model.getState() != eEqState.NOT_PRESENT) {
                bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)warnMsg, (String)warnTitle);
            }
            if (!bl) {
                this.refresh();
                return;
            }
            try {
                this.model.setCardOperMode(eCardOperMode2);
            }
            catch (ResourceInUse resourceInUse) {
                db.fine("Resoure in use " + resourceInUse.toString());
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_BLOCKED_BY_CKTS_PARAM_1, (Object)errMsg);
                this.refresh();
            }
            catch (EMCProvisionError eMCProvisionError) {
                db.fine("EMCProvisionError " + eMCProvisionError.toString());
                ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID(), (Object)eMCProvisionError.getEIDMsg());
                this.refresh();
            }
            catch (UnsupportedCardOperMode unsupportedCardOperMode) {
                Object object = this.modeCB.getSelectedItem();
                db.fine("UnsupportedCardOperMode " + unsupportedCardOperMode.toString());
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNSUPPORTED_CARD_OPER_MODE_PARAM_1, (Object)object.toString());
                this.refresh();
            }
            catch (CTCUserException cTCUserException) {
                db.fine("CTCUserException " + cTCUserException.toString());
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_APPLY_CHANGES);
                this.refresh();
            }
            finally {
                this.setDirty(false);
            }
        }
    }

    public void refreshFromModel() throws Exception {
        this.modeCB.setSelectedItem(this.getAttributeValFor("L2scCardMode", this.model.getCardOperMode().value()));
        this.resetDirty();
    }

    public CSHelpID getHelpID() {
        CSHelpID cSHelpID = CSHelpConst.L2scCardProvPane;
        if (this.model != null && this.model.getEqType() == 238) {
            cSHelpID = CSHelpConst.MSISC100TCardProvPane;
        }
        return cSHelpID;
    }

    protected Attribute[] getAttributeFor(String string) {
        return ElementDefaults.getAttributeMap(this.model).getAttributeArray(string);
    }

    protected Attribute getAttributeValFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.model).getAttributeForVal(string, n);
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.registerWithModel();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        this.unRegisterWithModel();
    }

    public void destroy() {
        this.unRegisterWithModel();
        super.destroy();
    }

    private void unRegisterWithModel() {
        this.model.deleteObserver((Observer)((Object)this));
    }

    private eCardOperMode getCardModeFromCB() {
        return eCardOperMode.from_int(((Attribute)this.modeCB.getSelectedItem()).getIntValue());
    }
}

