/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.model.EtherLineModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.l2sc.L2scPosPortInfoTableModel;
import cerent.cms.ui.l2sc.L2scRPRSpanInfoTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class L2scPosPortInfoPane
extends NodeProvPane
implements TableModelListener {
    private L2scPosPortInfoTableModel dataModel = null;
    private L2scRPRSpanInfoTableModel rprDataModel = null;
    private L2scPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private L2scModuleModel eqpmtModel = null;
    private int numLines = 0;
    private int numPorts = 0;
    private boolean rprMode = false;
    private JScrollPane scrollPane = null;
    private UTable table = null;
    private static final SDebug db = new SDebug("L2scPosPortInfoPane");

    public L2scPosPortInfoPane(String string, TabbedView tabbedView, L2scPortModel[] l2scPortModelArray, EtherLineModel[] etherLineModelArray) {
        super(string, tabbedView);
        Object var5_5 = null;
        this.portModels = l2scPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = l2scPortModelArray == null ? 0 : l2scPortModelArray.length;
        int n = this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        if (this.getParentView().getUiModel() instanceof L2scModuleModel) {
            this.eqpmtModel = (L2scModuleModel)this.getParentView().getUiModel();
        } else if (db.on()) {
            db.println("Equipment Model is not L2scModuleModel");
        }
        this.scrollPane = null;
        this.rprMode = this.eqpmtModel.isRPRMode();
        if (!this.rprMode) {
            this.createDataModel();
        } else {
            this.createRprDataModel();
        }
        this.setEditorAddPane();
        this.registerForUpdates();
    }

    private void setEditorAddPane() {
        TableColumn tableColumn = null;
        tableColumn = !this.rprMode ? this.table.getColumn((Object)this.dataModel.columnNames[1]) : this.table.getColumn((Object)this.rprDataModel.rprColumnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        this.table.sizeColumnsToFit(-1);
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane((Component)this.table);
        } else {
            this.validate();
        }
        this.scrollPane.setViewportView((Component)this.table);
        this.add(this.scrollPane);
    }

    private void createDataModel() {
        if (this.dataModel != null) {
            this.destroyDataModel();
        }
        this.dataModel = new L2scPosPortInfoTableModel(this.eqpmtModel, this.portModels, this.lineModels);
        this.dataModel.addTableModelListener(this);
        if (this.table == null) {
            this.table = new UTable((TableModel)this.dataModel);
        } else {
            this.table.setModel((TableModel)this.dataModel);
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
    }

    private void createRprDataModel() {
        if (this.rprDataModel != null) {
            this.destroyRprDataModel();
        }
        this.rprDataModel = new L2scRPRSpanInfoTableModel(this.eqpmtModel, this.portModels, this.lineModels);
        this.rprDataModel.addTableModelListener(this);
        if (this.table == null) {
            this.table = new UTable((TableModel)this.rprDataModel);
        } else {
            this.table.setModel((TableModel)this.rprDataModel);
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
    }

    private void registerForUpdates() {
        this.registerWithModel();
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (null != this.lineModels[i]) {
                this.lineModels[i].addObserver((Observer)((Object)this));
                if (!L2scPosPortInfoPane.db.on) continue;
                db.finest("L2scPosPortInfoPane added as observer for lineModel: " + this.lineModels[i]);
                continue;
            }
            db.println("Could not add observer for line=" + i + " because the lineModel is null!");
        }
    }

    public void update(Observable observable, Object object) {
        if (L2scPosPortInfoPane.db.on) {
            db.finest("ob:" + observable + ", o:" + object);
        }
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                L2scPosPortInfoPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        boolean bl = this.eqpmtModel.isRPRMode();
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            if (bl == this.rprMode) {
                if (this.rprMode) {
                    this.rprDataModel.refreshLineFromModel(n);
                } else {
                    this.dataModel.refreshLineFromModel(n);
                }
            } else {
                if (this.rprMode) {
                    this.destroyRprDataModel();
                    this.rprMode = bl;
                    this.createDataModel();
                } else {
                    this.destroyDataModel();
                    this.rprMode = bl;
                    this.createRprDataModel();
                }
                this.setEditorAddPane();
            }
        } else {
            if (bl == this.rprMode) {
                if (this.rprMode) {
                    this.rprDataModel.refresh();
                } else {
                    this.dataModel.refresh();
                }
            } else {
                if (this.rprMode) {
                    this.destroyRprDataModel();
                    this.rprMode = bl;
                    this.createDataModel();
                } else {
                    this.destroyDataModel();
                    this.rprMode = bl;
                    this.createRprDataModel();
                }
                this.setEditorAddPane();
            }
            if (db.on()) {
                db.println("Do full refresh on table");
            }
        }
    }

    private void destroyDataModel() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
    }

    private void destroyRprDataModel() {
        if (this.rprDataModel != null) {
            this.rprDataModel.removeTableModelListener(this);
            this.rprDataModel.destroy();
            this.rprDataModel = null;
        }
    }

    public void destroy() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
                if (!L2scPosPortInfoPane.db.on) continue;
                db.finest("L2scPosPortInfoPane deleted as observer for lineModel: " + this.lineModels[i]);
            }
            this.lineModels = null;
        }
        if (this.dataModel != null) {
            this.destroyDataModel();
        }
        if (this.rprDataModel != null) {
            this.destroyRprDataModel();
        }
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.numPorts == 0) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.numPorts ? this.numPorts - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.rprMode) {
                if (!this.dataModel.isRowDirty(i)) continue;
                this.setDirty();
                return;
            }
            if (!this.rprDataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws AnnotatedException {
        if (!this.rprMode) {
            this.dataModel.applyToModels();
            this.dataModel.resetRowDirty();
        } else {
            this.rprDataModel.applyToModels();
            this.rprDataModel.resetRowDirty();
        }
        this.setDirty(false);
    }

    public void refreshFromModel() throws Exception {
        if (!this.rprMode) {
            this.dataModel.refresh();
            this.dataModel.resetRowDirty();
        } else {
            this.rprDataModel.refresh();
            this.rprDataModel.resetRowDirty();
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.L2scPosPortInfoPane;
    }
}

