/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.RprHelper;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.l2sc.L2scCardProvPane;
import cerent.cms.ui.l2sc.L2scEtherPortInfoPane;
import cerent.cms.ui.l2sc.L2scPosPortInfoPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Observable;

public class L2scProvPane
extends NodeProvPane {
    L2scModuleModel model = null;
    String currentTitle = null;
    RprHelper rprHelper = null;
    private static final SDebug db = new SDebug("L2scProvPane");

    public L2scProvPane(String string, TabbedView tabbedView, L2scModuleModel l2scModuleModel) {
        super(string, tabbedView);
        this.model = l2scModuleModel;
        if (this.rprHelper == null) {
            this.rprHelper = RprHelper.instance();
        }
        this.setCurrentTitle();
        this.subTabs = new SubTabbedView(l2scModuleModel, tabbedView);
        this.subTabs.addTab("Ether Ports", (Component)((Object)new L2scEtherPortInfoPane("Ether Ports", this.subTabs, l2scModuleModel.getL2scEtherPorts(), l2scModuleModel.getL2scEtherLines())));
        this.subTabs.addTab(this.currentTitle, (Component)((Object)new L2scPosPortInfoPane(this.currentTitle, this.subTabs, l2scModuleModel.getL2scPosPorts(), l2scModuleModel.getL2scPosLines())));
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.addTab("Card", (Component)((Object)new L2scCardProvPane("Card", this.subTabs)));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
        this.registerWithModel();
    }

    private void setCurrentTitle() {
        this.currentTitle = this.rprHelper != null && this.model instanceof L2scModuleModel ? this.rprHelper.getRprPosTabName(this.model) : "POS Ports";
    }

    public void update(Observable observable, Object object) {
        SubTabbedView subTabbedView = null;
        String string = null;
        string = this.currentTitle;
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (this.getSubTabs() instanceof SubTabbedView) {
                this.setCurrentTitle();
                subTabbedView = (SubTabbedView)this.getSubTabs();
                subTabbedView.setTitle(string, this.currentTitle);
            } else if (db.on()) {
                db.println("Parent view is not subTabbedView");
            }
            if (db.on()) {
                db.println("Got an Update Message for " + observable + " arg: " + object);
            }
        }
    }

    public boolean hasSubTabs() {
        return true;
    }
}

