/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.idl.Epos.eRPRTopoEdge;
import cerent.cms.idl.Epos.sRPRSpanStateInfo;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.model.Attribute;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.L2scPosPortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.enum.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class L2scRPRSpanInfoTableModel
extends AbstractTableModel {
    private L2scModuleModel eqpmtModel = null;
    private L2scPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private boolean[] rowDirty = null;
    private int numLines = 0;
    private int numPorts = 0;
    private sRPRSpanStateInfo[] l2scRPRSpanInfo = null;
    private String[] portName = null;
    public String[] rprColumnNames = new String[]{"Interface", "Span Name", "Span", "Admin State", "Edge", "Jumbo", "Framing Type"};
    public static final int RPR_INTERFACE_NUMBER_INDEX = 0;
    public static final int RPR_SPAN_NAME_INDEX = 1;
    public static final int RPR_SPAN_INDEX = 2;
    public static final int RPR_ADMIN_STATE_INDEX = 3;
    public static final int RPR_EDGE_INDEX = 4;
    public static final int RPR_JUMBO_INDEX = 5;
    public static final int RPR_FRAMING_TYPE_INDEX = 6;
    private static final int RPR_SPAN_TYPE_NO_EDGE = 0;
    private boolean rprMode;
    private static final SDebug db = new SDebug("L2scRPRSpanInfoTableModel");

    public L2scRPRSpanInfoTableModel(L2scModuleModel l2scModuleModel, L2scPortModel[] l2scPortModelArray, EtherLineModel[] etherLineModelArray) {
        this.portModels = l2scPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = l2scPortModelArray == null ? 0 : l2scPortModelArray.length;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.eqpmtModel = l2scModuleModel;
        this.rowDirty = new boolean[this.numPorts];
        this.l2scRPRSpanInfo = new sRPRSpanStateInfo[this.numPorts];
        this.rprMode = l2scModuleModel.isRPRMode();
        this.portName = new String[this.numPorts];
        this.resetRowDirty();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1 && this.rprMode) {
            bl = AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public sRPRSpanStateInfo getRPRSpanStateInfo(int n) throws ProvisionError {
        if (this.l2scRPRSpanInfo[n] == null && this.portModels[n] instanceof L2scPosPortModel) {
            L2scPosPortModel l2scPosPortModel = (L2scPosPortModel)this.portModels[n];
            this.l2scRPRSpanInfo[n] = l2scPosPortModel.getRPRSpanStateInfo();
        }
        if (L2scRPRSpanInfoTableModel.db.on) {
            db.println("getL2scRPRSpanInfo(" + n + ") was called.");
            db.println("   rprStationIndex: " + this.l2scRPRSpanInfo[n].rprStationIndex);
            db.println("   adminState:" + this.l2scRPRSpanInfo[n].adminState);
            db.println("   Jumbo:" + this.l2scRPRSpanInfo[n].jumbo);
            db.println("   edge:" + this.l2scRPRSpanInfo[n].edge.value());
            db.println("   framing:" + this.l2scRPRSpanInfo[n].framingType);
        }
        return this.l2scRPRSpanInfo[n];
    }

    public int getColumnCount() {
        return this.rprColumnNames.length;
    }

    public String getColumnName(int n) {
        return this.rprColumnNames[n];
    }

    private String getLineNumberFor(int n) {
        String string = null;
        try {
            L2scPortModel l2scPortModel = this.portModels[n];
            string = String.valueOf(l2scPortModel.getPort());
            return string;
        }
        catch (Exception exception) {
            if (L2scRPRSpanInfoTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numPorts;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    private String getPortName(int n) {
        String string = "";
        if (this.portName[n] == null) {
            if (null == this.lineModels[n]) {
                string = "lineModels is null";
            } else {
                try {
                    this.portName[n] = string = this.lineModels[n].getAlias();
                }
                catch (Exception exception) {
                    if (L2scRPRSpanInfoTableModel.db.on) {
                        db.println("Exception caught accessing port name: " + exception);
                    }
                    string = exception.toString();
                }
            }
        }
        return this.portName[n];
    }

    private void setPortName(int n, String string) {
        this.getPortName(n);
        try {
            if (null != this.lineModels[n] && null != string) {
                this.portName[n] = string;
                this.rowDirty[n] = true;
            }
        }
        catch (Exception exception) {
            if (L2scRPRSpanInfoTableModel.db.on) {
                db.println("Exception caught setting port name: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private String getRPRStationIndex(int n) {
        String string = null;
        try {
            this.getRPRSpanStateInfo(n);
            int n2 = this.l2scRPRSpanInfo[n].rprStationIndex;
            string = String.valueOf(n2);
            return string;
        }
        catch (Exception exception) {
            if (L2scRPRSpanInfoTableModel.db.on) {
                db.println("Exception caught accessing RPR Station Index: " + exception);
            }
            return "unknown";
        }
    }

    private String getRPRSpanIndex(int n) {
        String string = null;
        if (this.rprMode) {
            if (n == 0) {
                string = "RPR East";
            } else if (n == 1) {
                string = "RPR West";
            }
        }
        return string;
    }

    private String getRPRAdminState(int n) {
        boolean bl;
        String string;
        block2: {
            string = "";
            bl = false;
            try {
                this.getRPRSpanStateInfo(n);
                bl = this.l2scRPRSpanInfo[n].adminState;
            }
            catch (Exception exception) {
                if (!L2scRPRSpanInfoTableModel.db.on) break block2;
                db.println("Exception caught accessing RPR admin state: " + exception);
            }
        }
        string = bl ? "Up" : "Down";
        return string;
    }

    private String getRPREdgeState(int n) {
        eRPRTopoEdge eRPRTopoEdge2;
        String string;
        block2: {
            string = "";
            eRPRTopoEdge2 = eRPRTopoEdge.NO_EDGE;
            try {
                this.getRPRSpanStateInfo(n);
                eRPRTopoEdge2 = this.l2scRPRSpanInfo[n].edge;
            }
            catch (Exception exception) {
                if (!L2scRPRSpanInfoTableModel.db.on) break block2;
                db.println("Exception caught accessing RPR Edge state: " + exception);
            }
        }
        string = eRPRTopoEdge2.value() == 0 ? "No" : "Yes";
        return string;
    }

    private String getRPRJumbo(int n) {
        boolean bl;
        String string;
        block2: {
            string = "";
            bl = false;
            try {
                this.getRPRSpanStateInfo(n);
                bl = this.l2scRPRSpanInfo[n].jumbo;
            }
            catch (Exception exception) {
                if (!L2scRPRSpanInfoTableModel.db.on) break block2;
                db.println("Exception caught accessing RPR jumbo: " + exception);
            }
        }
        string = bl ? "Yes" : "No";
        return string;
    }

    private Attribute getRPRFramingType(int n) {
        Attribute attribute;
        block2: {
            attribute = null;
            ePosFramingType ePosFramingType2 = ePosFramingType.X86;
            try {
                this.getRPRSpanStateInfo(n);
                ePosFramingType2 = this.l2scRPRSpanInfo[n].framingType;
                attribute = EtherEnumStrings.get(ePosFramingType.class, ePosFramingType2.value());
            }
            catch (Exception exception) {
                if (!L2scRPRSpanInfoTableModel.db.on) break block2;
                db.println("Exception caught accessing RPR framingType: " + exception);
            }
        }
        return attribute;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block11: {
            string = "";
            try {
                switch (n2) {
                    case 0: {
                        return this.getRPRStationIndex(n);
                    }
                    case 2: {
                        return this.getRPRSpanIndex(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 3: {
                        return this.getRPRAdminState(n);
                    }
                    case 4: {
                        return this.getRPREdgeState(n);
                    }
                    case 5: {
                        return this.getRPRJumbo(n);
                    }
                    case 6: {
                        return this.getRPRFramingType(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!L2scRPRSpanInfoTableModel.db.on) break block11;
                db.println("Error in getValueAt in L2scRPRSpanInfoTableModel " + exception + " rprMode: " + this.rprMode);
                SDebug.printStackTrace((Throwable)exception);
                string = exception.toString();
            }
        }
        return string;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return;
            }
            case 1: {
                if (!(object instanceof String)) break;
                String string = (String)object;
                this.setPortName(n, string);
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public void resetRowDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        this.l2scRPRSpanInfo[n] = null;
        this.portName[n] = null;
        this.resetRowDirty();
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModels() {
        for (int i = 0; i < this.portModels.length; ++i) {
            if (!this.rowDirty[i]) continue;
            try {
                this.lineModels[i].setAlias(this.portName[i]);
                continue;
            }
            catch (Exception exception) {
                if (L2scRPRSpanInfoTableModel.db.on) {
                    db.println("Exception caught trying to set port name : " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.resetRowDirty();
    }

    public void refresh() {
        for (int i = 0; i < this.numLines; ++i) {
            this.l2scRPRSpanInfo[i] = null;
            this.portName[i] = null;
        }
        this.resetRowDirty();
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void destroy() {
        this.portModels = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.rowDirty = null;
        for (int i = 0; i < this.l2scRPRSpanInfo.length; ++i) {
            this.l2scRPRSpanInfo[i] = null;
            this.portName[i] = null;
        }
        this.l2scRPRSpanInfo = null;
        this.portName = null;
    }
}

