/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.IModuleModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.RprHelper;
import cerent.cms.ui.ml2.MLPortGraphic;
import cerent.cms.ui.ml2.MLPosPortGraphic;
import cerent.cms.ui.shelf.CardView;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ML2CardView
extends CardView {
    private static final SDebug db = new SDebug("ML2CardView");
    private ModuleModel model = null;
    private PortModel[] etherPortModels = null;
    private PortModel[] posPortModels = null;
    private MLPortGraphic[] etherPorts = null;
    private MLPosPortGraphic[] posPorts = null;
    private boolean isMapper = false;
    private JLabel posLbl = null;

    public ML2CardView(ModuleModel moduleModel, PortModel[] portModelArray, PortModel[] portModelArray2) {
        this(moduleModel, portModelArray, portModelArray2, false);
    }

    public ML2CardView(ModuleModel moduleModel, PortModel[] portModelArray, PortModel[] portModelArray2, boolean bl) {
        super(moduleModel);
        this.model = moduleModel;
        this.etherPortModels = portModelArray;
        this.posPortModels = portModelArray2;
        this.isMapper = bl;
        if (moduleModel instanceof L2scModuleModel) {
            moduleModel.addObserver(this);
        }
        this.addPorts();
    }

    protected List getPorts() {
        return new ArrayList();
    }

    protected void addPorts(boolean bl) {
    }

    private JLabel rprPosLabel() {
        boolean bl = false;
        if (this.model instanceof L2scModuleModel) {
            bl = this.model.isRPRMode();
        }
        return new JLabel(bl ? "RPR" : "POS");
    }

    private void setGbc(GridBagConstraints gridBagConstraints, JPanel jPanel) {
        if (this.pci.positionPortsVertically()) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridy = 0;
            this.add((Component)jPanel, gridBagConstraints);
            ++gridBagConstraints.gridx;
        } else {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.add((Component)jPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
    }

    private void setPreferredFillerSize(JPanel jPanel) {
        if (this.pci.positionPortsVertically()) {
            jPanel.setPreferredSize(new Dimension(20, 0));
        } else {
            jPanel.setPreferredSize(new Dimension(0, 20));
        }
    }

    protected void addPorts() {
        this.etherPorts = new MLPortGraphic[this.etherPortModels.length];
        this.posPorts = new MLPosPortGraphic[this.posPortModels.length];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        this.setPreferredFillerSize(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 3, 2, 2);
        this.add((Component)new JLabel("ETHER"), gridBagConstraints);
        this.addPortsToCard(this.etherPortModels, this.etherPorts, gridBagConstraints);
        this.setGbc(gridBagConstraints, jPanel);
        this.posLbl = this.rprPosLabel();
        this.add((Component)this.posLbl, gridBagConstraints);
        this.addPosPortsToCard(this.posPortModels, this.posPorts, gridBagConstraints);
        this.repaint();
    }

    private void addPortsToCard(PortModel[] portModelArray, MLPortGraphic[] mLPortGraphicArray, GridBagConstraints gridBagConstraints) {
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel = portModelArray[i];
            mLPortGraphicArray[i] = new MLPortGraphic(this, portModel, portModel.getPort());
            if (this.pci.positionPortsVertically()) {
                gridBagConstraints.gridy = i + 1;
            } else {
                gridBagConstraints.gridx = i + 1;
            }
            this.add((Component)mLPortGraphicArray[i], gridBagConstraints);
        }
        this.updatePortAlarmColor(portModelArray, mLPortGraphicArray);
    }

    private void addPosPortsToCard(PortModel[] portModelArray, MLPosPortGraphic[] mLPosPortGraphicArray, GridBagConstraints gridBagConstraints) {
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel = portModelArray[i];
            mLPosPortGraphicArray[i] = new MLPosPortGraphic(this, portModel, portModel.getPort());
            if (this.pci.positionPortsVertically()) {
                gridBagConstraints.gridy = i + 1;
            } else {
                gridBagConstraints.gridx = i + 1;
            }
            this.add((Component)mLPosPortGraphicArray[i], gridBagConstraints);
        }
        this.updatePortAlarmColor(portModelArray, mLPosPortGraphicArray);
    }

    public boolean supportsRPR() {
        boolean bl = false;
        int n = this.model.getEqType();
        if (n == 102 || n == 103 || n == 221) {
            bl = true;
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof AlarmStatus) {
            AlarmStatus alarmStatus = (AlarmStatus)object;
            this.setAlarmColor(alarmStatus.getHighestSeverity());
            this.updatePortAlarmColor(this.etherPortModels, this.etherPorts);
            this.updatePortAlarmColor(this.posPortModels, this.posPorts);
        } else if (observable instanceof L2scModuleModel) {
            IModuleModel iModuleModel = (IModuleModel)observable;
            if (this.supportsRPR() && object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED) && this.posLbl != null && RprHelper.needsLabelChange(iModuleModel, this.posLbl.getText())) {
                this.posLbl.setText(RprHelper.getPosRPRLabel(iModuleModel));
            }
        }
    }

    private void updatePortAlarmColor(PortModel[] portModelArray, MLPortGraphic[] mLPortGraphicArray) {
        if (portModelArray == null || mLPortGraphicArray == null) {
            return;
        }
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel = portModelArray[i];
            IAlarmStatus iAlarmStatus = this.cardAlarmStore.getEntityAlarmStatus(portModel);
            if (iAlarmStatus != null) {
                mLPortGraphicArray[i].setAlarmState(iAlarmStatus.getHighestSeverity());
                continue;
            }
            db.severe("null portAlarmStatus for port " + portModel.getPort() + ", eqType " + portModel.getEqType());
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isMapper && this.etherPorts != null && this.posPorts != null && this.etherPorts.length == this.posPorts.length) {
            for (int i = 0; i < this.etherPorts.length; ++i) {
                Rectangle rectangle = this.etherPorts[i].getBounds();
                Rectangle rectangle2 = this.posPorts[i].getBounds();
                this.drawDoubleHeadedArrow(graphics, rectangle, rectangle2);
            }
        }
    }

    public void dispose() {
        int n;
        if (this.etherPorts != null) {
            for (n = 0; n < this.etherPorts.length; ++n) {
                if (this.etherPorts[n] == null) continue;
                this.etherPorts[n].dispose();
            }
        }
        if (this.posPorts != null) {
            for (n = 0; n < this.posPorts.length; ++n) {
                if (this.posPorts[n] == null) continue;
                this.posPorts[n].dispose();
            }
        }
        super.dispose();
    }
}

