/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InvalidCardMode;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enum.IfEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class ML2LineMaintTableModel
extends AbstractTableModel
implements Observer,
IAdminTableAccess {
    public static final int LINENUMBER_INDEX = 0;
    public static final int STATE_INDEX = 1;
    public static final int SERVICE_STATE_INDEX = 2;
    public static final int LOOPBACK_INDEX = 3;
    private String[] columnNames = new String[]{"Port", "Admin State", "Service State", "Loopback Type"};
    private ML2ModuleModel eqpmtModel = null;
    private ML2EtherPortModel[] portModels = null;
    private ML2EtherLineModel[] lineModels = null;
    private EntityCellRenderer myPortRenderer;
    private boolean[] rowDirty = null;
    private AdminState[] adminState;
    private IServiceState[] serviceState;
    private eLoopback[] loopbacks;
    private int numLines = 0;
    private boolean isPortOOSServiceAffecting;
    private TDMTerminology term;
    private static final SDebug db = new SDebug("ML2LineMaintTableModel");

    public ML2LineMaintTableModel(ML2ModuleModel mL2ModuleModel, ML2EtherPortModel[] mL2EtherPortModelArray, ML2EtherLineModel[] mL2EtherLineModelArray) {
        this.eqpmtModel = mL2ModuleModel;
        this.portModels = mL2EtherPortModelArray;
        this.lineModels = mL2EtherLineModelArray;
        if (mL2ModuleModel == null || mL2EtherPortModelArray == null || mL2EtherLineModelArray == null || mL2EtherPortModelArray.length != mL2EtherLineModelArray.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + mL2ModuleModel + " portModels=" + mL2EtherPortModelArray + " lineModels=" + mL2EtherLineModelArray);
            }
            return;
        }
        this.numLines = mL2EtherLineModelArray.length;
        this.myPortRenderer = new EntityCellRenderer();
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.loopbacks = new eLoopback[this.numLines];
        this.rowDirty = new boolean[this.numLines];
        this.term = this.getTerm();
        this.resetRowDirty();
        this.registerWithLineModels();
        this.isPortOOSServiceAffecting = this.eqpmtModel.getNodeModelDelegate().getPlatform().isPortOOSserviceAfecting();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.portModels != null && n < this.numLines && AbstractPane.isUserAuthorized(this.portModels[0], SecurityLevel.MAINTENANCE)) {
            try {
                return n2 == 1 || n2 == 3 && AdminState.admitsLoopback(this.getNewAdminState(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    private eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.lineModels[n].getAdminStateEnum();
    }

    private Attribute getLoopback(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        return IfEnumStrings.get(eLoopback.class, this.loopbacks[n].value());
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block8: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getPortDescription(n);
                    }
                    case 2: {
                        return this.serviceState[n].toString(this.term);
                    }
                    case 3: {
                        return this.getLoopback(n);
                    }
                    case 1: {
                        return this.adminState[n].toString(this.term);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block8;
                db.println("Error in getValueAt " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    protected String getPortDescription(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.lineModels[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                this.adminState[n] = (AdminState)object;
                this.setLoopbackBasedOnAdminState(this.loopbacks[n], this.adminState[n]);
                break;
            }
            case 3: {
                if (!(object instanceof Attribute)) break;
                int n3 = ((Attribute)object).getIntValue();
                try {
                    this.loopbacks[n] = eLoopback.from_int(n3);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableRowsUpdated(n, n);
    }

    public eAdminState getOldAdminState(int n) throws NoSuchInterface {
        return this.lineModels[n].getAdminStateEnum();
    }

    protected eAdminState getNewAdminState(int n) throws NoSuchInterface {
        return this.adminState[n].getAdminStateEnum();
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        return this.adminState[n];
    }

    public boolean isAdminStateDirty(int n) {
        boolean bl = false;
        try {
            bl = this.rowDirty[n] && this.getNewAdminState(n) != this.getAdminStateFromModel(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public eLoopback getOldLoopback(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        return this.lineModels[n].getLoopback();
    }

    public eLoopback getNewLoopback(int n) throws NoSuchInterface {
        return this.loopbacks[n];
    }

    public boolean changedToFormOfLoopback() throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            eLoopback eLoopback2 = this.getOldLoopback(i);
            eLoopback eLoopback3 = this.getNewLoopback(i);
            if (eLoopback3 != eLoopback.LINE_LOOPBACK && eLoopback3 != eLoopback.INWARD_LOOPBACK || eLoopback2 != eLoopback.NO_LOOPBACK) continue;
            return true;
        }
        return false;
    }

    public void applyToModel() throws Exception {
        block4: for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            eAdminState eAdminState2 = this.getNewAdminState(i);
            eLoopback eLoopback2 = this.getNewLoopback(i);
            switch (eAdminState2.value()) {
                case 0: 
                case 1: 
                case 3: {
                    if (this.getOldLoopback(i) != this.getNewLoopback(i)) {
                        this.lineModels[i].setLoopback(eLoopback2);
                    }
                    if (this.getOldAdminState(i) == this.getNewAdminState(i)) continue block4;
                    this.lineModels[i].setAdminState(eAdminState2);
                    continue block4;
                }
                case 2: {
                    if (this.getOldAdminState(i) != this.getNewAdminState(i)) {
                        this.lineModels[i].setAdminState(eAdminState2);
                    }
                    if (this.getOldLoopback(i) == this.getNewLoopback(i)) continue block4;
                    this.lineModels[i].setLoopback(eLoopback2);
                    continue block4;
                }
            }
        }
        this.resetRowDirty();
    }

    public void resetRowDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            return true;
        }
        return false;
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    private void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void resetLineCache(int n) throws Exception {
        this.loopbacks[n] = this.lineModels[n].getLoopback();
        this.adminState[n] = AdminState.enumToAdminState(this.getAdminStateFromModel(n));
        sServiceState sServiceState2 = this.lineModels[n].getServiceState();
        this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        this.rowDirty[n] = false;
    }

    private void setLoopbackBasedOnAdminState(eLoopback eLoopback2, AdminState adminState) {
        if (adminState != null && !AdminState.admitsLoopback(adminState.getAdminStateEnum())) {
            eLoopback2 = eLoopback.NO_LOOPBACK;
        }
    }

    public AdminState[] getAdminStateAttrs() {
        boolean bl = AdminState.isANSI(this.eqpmtModel.getNodeModel().getFramingType());
        return AdminState.getDefaultAdminStates(bl);
    }

    public Attribute[] getLoopbackAttrs() {
        return IfEnumStrings.get(eLoopback.class, IfEnumStrings.LOOPBACK_DEFAULTS);
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }

    private TDMTerminology getTerm() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }
}

