/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.Attribute;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ml2.ML2LxEtherPortTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ML2LxEtherPortProvPane
extends NodeProvPane
implements TableModelListener {
    private ML2LxEtherPortTableModel dataModel = null;
    private ML2EtherPortModel[] portModels = null;
    private ML2EtherLineModel[] lineModels = null;
    private int numLines = 0;
    private static final SDebug db = new SDebug("ML2LxEtherPortProvPane");

    public ML2LxEtherPortProvPane(String string, TabbedView tabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, tabbedView);
        this.portModels = mL2ModuleModel.getEtherPortModels();
        this.lineModels = mL2ModuleModel.getEtherLineModels();
        if (mL2ModuleModel == null || this.portModels == null || this.lineModels == null || this.portModels.length != this.lineModels.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + mL2ModuleModel + " portModels=" + this.portModels + " lineModels=" + this.lineModels);
            }
            return;
        }
        this.dataModel = new ML2LxEtherPortTableModel(mL2ModuleModel, this.portModels, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
    }

    private void customizedProvPane() {
        TableColumn tableColumn = null;
        Attribute[] attributeArray = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        attributeArray = this.dataModel.getAdminStateAttrs();
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        tableColumn.setPreferredWidth(75);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
        tableColumn.setPreferredWidth(105);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(5));
        tableColumn.setPreferredWidth(105);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
        attributeArray = this.dataModel.getFlowControlAttrs();
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        tableColumn.setPreferredWidth(100);
        this.table.sizeColumnsToFit(-1);
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("enteringPage");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("leavingPage");
        }
        super.leavingPage();
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        try {
            this.dataModel.applyToModels();
            this.resetDirty();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes", exception);
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.ML2LxEtherPortProvPane;
    }
}

