/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.mrc;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.MrcModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.mrc.MrcMaintenancePane;
import cerent.cms.ui.mrc.MrcProvPane;
import cerent.cms.ui.sonet.TdmPmPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;

public class MrcCardTabbedView
extends PluggableCardTabbedView {
    protected MrcModuleModel moduleModel;
    protected TdmLineModel[] lineModels;

    public MrcCardTabbedView(MrcModuleModel mrcModuleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(mrcModuleModel, iEventPanelController, iUiToolkit);
    }

    protected void init() {
        this.moduleModel = (MrcModuleModel)this.getUiModel();
        this.lineModels = this.moduleModel.getTdmLineModels();
        this.getOM().addObservable((Observable[])this.lineModels);
        this._interfaceContainers = Collections.synchronizedMap(new HashMap(this.moduleModel.getPpmSlots().length));
        Iterator<TdmLineModel> iterator = Arrays.asList(this.lineModels).iterator();
        while (iterator.hasNext()) {
            TdmLineModel tdmLineModel = iterator.next();
            try {
                PpmModel ppmModel = (PpmModel)tdmLineModel.getPortModel().getParent();
                this._interfaceContainers.put(tdmLineModel, ppmModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("MrcCardTabbedView.init(): Can't find corresponding PortModel from the TdmLineModel:" + tdmLineModel);
            }
        }
        super.init();
    }

    protected List addModel(Observable observable) {
        List<OcnLineUpdate> list = new ArrayList();
        if (observable instanceof PpmModel) {
            Iterator iterator = ((PpmModel)((Object)observable)).getContainedPorts().iterator();
            while (iterator.hasNext()) {
                PortModel portModel = (PortModel)iterator.next();
                TdmLineModel tdmLineModel = (TdmLineModel)portModel.getInterfaceModel();
                this._interfaceContainers.put(tdmLineModel, (PpmModel)((Object)observable));
            }
            this.lineModels = this.moduleModel.getTdmLineModels();
            this.getOM().addObservable((Observable[])this.lineModels);
            list.add(new OcnLineUpdate(this.lineModels, (PpmModel)((Object)observable)));
        } else {
            list = super.addModel(observable);
        }
        return list;
    }

    protected List removeModel(Observable observable) {
        List<OcnLineUpdate> list = new ArrayList();
        if (observable instanceof TdmLineModel) {
            PpmModel ppmModel = (PpmModel)this._interfaceContainers.remove(observable);
            this.lineModels = this.moduleModel.getTdmLineModels();
            this.getOM().removeObservable(observable);
            list.add(new OcnLineUpdate(this.lineModels, ppmModel));
        } else {
            list = super.removeModel(observable);
        }
        return list;
    }

    public Pane getProvTab() {
        return new MrcProvPane("Provisioning", this, this.lineModels);
    }

    public Pane getMaintenanceTab() {
        return new MrcMaintenancePane("Maintenance", this, this.lineModels);
    }

    public Pane getPerformanceTab() {
        return new TdmPmPane("Performance", this, this.lineModels);
    }
}

