/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ms.RackViewPanel;
import cerent.cms.ui.ms.ShelfBehavior;
import cerent.cms.ui.ms.ShelfTransferHandler;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.GridBagPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class BayViewPanel
extends GridBagPanel
implements ActionListener,
Observer {
    public static final Dimension GRAPHIC_VIEW_DIM = new Dimension(210, 118);
    private IChassisModel chassis = null;
    private AbstractShelfLayout asl = null;
    private RackViewPanel parent;
    private short bayNumber;
    private JPopupMenu popup;
    private ActionOrganizer actOrg;
    private ShelfBehavior behavior;
    protected static final SDebug db = new SDebug("BayViewPanel");

    public BayViewPanel(RackViewPanel rackViewPanel, short s) {
        this.bayNumber = s;
        this.parent = rackViewPanel;
        db.fine("<init>");
        this.behavior = new ShelfBehavior(rackViewPanel.getNodeModel(), db);
        this.setBackground(Color.white);
        this.setPreferredSize(GRAPHIC_VIEW_DIM);
        this.setMinimumSize(GRAPHIC_VIEW_DIM);
        this.setMaximumSize(GRAPHIC_VIEW_DIM);
        this.gbl.setConstraints(this, this.gbc);
        this.popup = new JPopupMenu();
        this.actOrg = new ActionOrganizer(this);
        this.actOrg.addMenuItem((JComponent)this.popup, null, "Add Shelf", 65);
        this.actOrg.setEnabled("Add Shelf", AbstractPane.isUserAuthorized(rackViewPanel.getNodeModel(), SecurityLevel.PROVISIONING));
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.setTransferHandler(new ShelfTransferHandler(rackViewPanel.getNodeModel().getChassisModelsInstance(), rackViewPanel.getMVP()));
    }

    public synchronized boolean isEmpty() {
        return this.chassis == null;
    }

    public RackViewPanel getRVP() {
        return this.parent;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Add Shelf") {
            Object object;
            IEntityModel[] iEntityModelArray = this.parent.getNodeModel().getChassisModels();
            int[] nArray = new int[iEntityModelArray.length];
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                object = (IChassisModel)iEntityModelArray[i];
                nArray[i] = object.getShelfId();
            }
            Object[] objectArray = this.getAvailableShelfIds(nArray);
            if (objectArray.length > 0) {
                object = JOptionPane.showInputDialog(this, "Choose a Shelf ID", "Shelf ID Selection", 1, null, objectArray, objectArray[0]);
                if (object != null) {
                    this.behavior.addShelf(this, (short)((Integer)object).intValue(), this.parent.getRackNum(), this.bayNumber);
                }
            } else {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_MAX_PROVISIONED_SHELVES);
            }
        }
    }

    private Object[] getAvailableShelfIds(int[] nArray) {
        boolean[] blArray = new boolean[8];
        int n = 0;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            blArray[nArray[n] - 1] = true;
        }
        Object[] objectArray = new Integer[8 - nArray.length];
        for (n = 0; n < 8; ++n) {
            if (blArray[n]) continue;
            objectArray[n2++] = new Integer(n + 1);
        }
        return objectArray;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof IChassisModel) {
            IChassisModel iChassisModel = (IChassisModel)((Object)observable);
            if (object == ModelUpdateType.DELETED) {
                db.fine("update(" + iChassisModel + ", " + "DELETED");
                if (iChassisModel == this.chassis) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BayViewPanel.this.bayRemoved();
                        }
                    });
                } else {
                    db.severe("ERROR! Received DELETED update from wrong ChassisModel!");
                }
            } else if (object == ModelUpdateType.ADDED) {
                AbstractShelfLayout abstractShelfLayout;
                db.fine("update(" + observable + ", " + "ADDED");
                if (this.chassis != null) {
                    this.chassis.deleteObserver(this);
                    this.removeAll();
                }
                this.chassis = iChassisModel;
                this.actOrg.getMenuItem("Add Shelf").setEnabled(false);
                this.asl = abstractShelfLayout = iChassisModel.getPlatform().getMsShelfLayout(iChassisModel, this.parent.getViewController(), this);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BayViewPanel.this.add((Component)abstractShelfLayout, 0, 0);
                        BayViewPanel.this.revalidate();
                    }
                });
                this.parent.update((Observable)((Object)iChassisModel), ModelUpdateType.ADDED);
                this.chassis.addObserver(this);
            } else if (object != ModelUpdateType.CHANGED && object != ModelUpdateType.STRUCTURE_CHANGED) {
                db.warning("Received multipled ADDEDs for " + this.chassis);
            }
        }
    }

    void alertUserToChange() {
        if (this.asl != null) {
            this.asl.highlight();
        }
    }

    void bayRemoved() {
        if (this.asl != null) {
            this.removeAll();
            this.repaint(this.getVisibleRect());
            this.asl.destroy();
            this.asl = null;
            this.chassis = null;
            this.parent.update((Observable)((Object)this.chassis), ModelUpdateType.DELETED);
            this.actOrg.getMenuItem("Add Shelf").setEnabled(true);
        }
    }

    IChassisModel getChassis() {
        return this.chassis;
    }

    public short getBayNum() {
        return this.bayNumber;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
            BayViewPanel.this.parent.getMVP().setSelectedShelf(null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                BayViewPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

