/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.ms.ShelfBehavior;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.SDebug;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MsCardGraphic
extends CardGraphic {
    protected ShelfBehavior shelfBehavior;
    protected int max_slot_size = 1;

    public MsCardGraphic(IEntityModel iEntityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(iEntityModel, abstractShelfLayout, sDebug);
        this.shelfBehavior = new ShelfBehavior(this.nodeModel, sDebug);
    }

    protected void initialize() {
        super.initialize();
    }

    public void rightMouseClicked(Point point, CardPanel cardPanel) {
        this.db.println("rightMouseClicked");
        JPopupMenu jPopupMenu = null;
        int n = this.getModel().getSlot();
        Object var5_5 = null;
        jPopupMenu = new JPopupMenu("Action");
        JMenuItem jMenuItem = null;
        IChassisModel iChassisModel = ((EntityModel)this.getModel()).getChassis();
        eEqState eEqState2 = ((ChassisModel)iChassisModel).getState();
        this.db.println(iChassisModel + " state is " + ElementDefaults.eqStateToString(eEqState2));
        if (eEqState2.value() == 6) {
            jMenuItem = this.makeMenuAction("Undelete Shelf", AbstractPane.isUserAuthorized((IModel)iChassisModel, SecurityLevel.PROVISIONING));
            jMenuItem.setMnemonic('U');
            jPopupMenu.add(jMenuItem);
        } else {
            jMenuItem = this.makeMenuAction("Open Shelf", true);
            jMenuItem.setMnemonic('O');
            jPopupMenu.add(jMenuItem);
            jMenuItem = this.makeMenuAction("Delete Shelf", AbstractPane.isUserAuthorized((IModel)iChassisModel, SecurityLevel.PROVISIONING));
            jMenuItem.setMnemonic('D');
            jPopupMenu.add(jMenuItem);
        }
        this.addCustomMenuItems(jPopupMenu);
        jPopupMenu.show(cardPanel, point.x, point.y);
    }

    public void openShelf() {
        if (!this.isDisabled()) {
            IChassisModel iChassisModel = ((EntityModel)this.getModel()).getChassis();
            ViewName viewName = new ViewName(new int[]{this.nodeId, iChassisModel.getNodeModel().isMultishelf() ? iChassisModel.getShelfId() : 0});
            if (this.db.on()) {
                this.db.fine("Transitioning to view " + viewName);
            }
            this.parent.getViewController().tryJumpView(viewName);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Open Shelf")) {
                this.openShelf();
            } else if (string.equals("Delete Shelf")) {
                boolean bl = this.shelfBehavior.deleteShelf(this.parent, ((EntityModel)this.getModel()).getChassis());
                this.setDisabled(bl);
            } else if (string.equals("Undelete Shelf")) {
                this.shelfBehavior.unDeleteShelf(this.parent, ((EntityModel)this.getModel()).getChassis());
            }
        }
    }

    public ICardPainter getCardPainter() {
        return ((EntityModel)this.getModel()).getChassis().getPlatform().getMsCardPainter(this);
    }
}

