/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.sShelfInfoSubset;
import cerent.cms.idl.Equipment.sShelfPosition;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.ms.NppMultishelfLayoutPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class MultishelfLayoutEditDialog
extends UDialog
implements ActionListener {
    private static String TITLE = "Edit Shelf Locations";
    private JButton okButton;
    private JButton cancelButton;
    private JSpinner[] rackSP;
    private JSpinner[] baySP;
    private sShelfInfoSubset[] sis;
    private NppMultishelfLayoutPane pane;

    public static MultishelfLayoutEditDialog instance(NppMultishelfLayoutPane nppMultishelfLayoutPane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)nppMultishelfLayoutPane));
        return new MultishelfLayoutEditDialog(frame, nppMultishelfLayoutPane);
    }

    private MultishelfLayoutEditDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.pane = (NppMultishelfLayoutPane)object;
        this.sis = this.pane.getShelfLayoutInfo();
        jPanel.add((Component)this.createAttributesPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public sShelfInfoSubset[] getShelfLayoutInfo() {
        sShelfInfoSubset[] sShelfInfoSubsetArray = this.sis;
        if (this.sis != null) {
            this.sis = null;
        }
        return sShelfInfoSubsetArray;
    }

    public void dispose() {
        this.sis = null;
        this.pane = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.sanityCheck();
                this.apply();
                this.dispose();
            }
            catch (InvalidData invalidData) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_FAIL_MULTISHELF_LAYOUT_PARAM_1, (Object)invalidData.getMessage());
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_FAIL_MULTISHELF_LAYOUT_PARAM_1, (Object)provisionError.getMessage());
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_FAIL_MULTISHELF_LAYOUT_PARAM_1, (Object)exception.getMessage());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private void apply() throws InvalidData, ProvisionError {
        sShelfInfoSubset[] sShelfInfoSubsetArray = new sShelfInfoSubset[this.sis.length];
        for (int i = 0; i < this.sis.length; ++i) {
            sShelfInfoSubsetArray[i] = new sShelfInfoSubset(this.sis[i].chassisIndex, new sShelfPosition(((Number)this.rackSP[i].getValue()).shortValue(), ((Number)this.baySP[i].getValue()).shortValue()));
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.pane.getUiModel().getNodeModel();
        ChassisModels chassisModels = nodeModelDelegate.getChassisModelsInstance();
        chassisModels.setShelfInfoList(sShelfInfoSubsetArray);
    }

    private void sanityCheck() throws Exception {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.pane.getUiModel().getNodeModel();
        ChassisModels chassisModels = nodeModelDelegate.getChassisModelsInstance();
        for (int i = 0; i < this.sis.length; ++i) {
            for (int j = 0; j < this.sis.length; ++j) {
                if (i == j || ((Number)this.rackSP[i].getValue()).shortValue() != ((Number)this.rackSP[j].getValue()).shortValue() || ((Number)this.baySP[i].getValue()).shortValue() != ((Number)this.baySP[j].getValue()).shortValue()) continue;
                throw new Exception("Duplicate positions for Shelf " + chassisModels.getShelfIdByChassisIndex(this.sis[i].chassisIndex) + " and Shelf " + chassisModels.getShelfIdByChassisIndex(this.sis[j].chassisIndex) + "!");
            }
        }
    }

    private JPanel createAttributesPanel() {
        JPanel jPanel = new JPanel(new GridLayout(this.sis.length, 3));
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.pane.getUiModel().getNodeModel();
        ChassisModels chassisModels = nodeModelDelegate.getChassisModelsInstance();
        this.rackSP = new JSpinner[this.sis.length];
        this.baySP = new JSpinner[this.sis.length];
        for (int i = 0; i < this.sis.length; ++i) {
            sShelfInfoSubset sShelfInfoSubset2 = this.sis[i];
            this.rackSP[i] = new JSpinner(new SpinnerNumberModel(this.sis[i].position.rackNumber, 1, 8, 1));
            SpinnerNumberModel spinnerNumberModel = null;
            spinnerNumberModel = nodeModelDelegate.isSdh() ? new SpinnerNumberModel(this.sis[i].position.positionInRack, 1, 3, 1) : new SpinnerNumberModel(this.sis[i].position.positionInRack, 1, 4, 1);
            this.baySP[i] = new JSpinner(spinnerNumberModel);
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel2.add(new JLabel("Shelf " + chassisModels.getShelfIdByChassisIndex(sShelfInfoSubset2.chassisIndex)));
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel3.add(new JLabel("Rack "));
            jPanel3.add(this.rackSP[i]);
            jPanel.add(jPanel3);
            JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel4.add(new JLabel("Position "));
            jPanel4.add(this.baySP[i]);
            jPanel.add(jPanel4);
        }
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

