/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.sShelfInfoSubset;
import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.MultishelfViewController;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.RackViewPanel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class MultishelfViewPanel
extends JPanel
implements ActionListener,
Observer {
    private JPopupMenu popup;
    private MultishelfViewController msvc;
    private NodeModelDelegate nmd;
    private ChassisModels cms;
    private IUiToolkit uiToolkit;
    private HashMap rackMap = new HashMap(8);
    private HashMap bundleMap = new HashMap(8);
    private ActionOrganizer actOrg;
    private AbstractShelfLayout selectedShelf = null;
    private static final String CMD_UP = "Go To Parent View";
    private static final String CMD_ADD_RACK = "Add Rack";
    private static final int BORDER_SPACE = 22;
    protected static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 3);
    protected static final Border UNSELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    protected static final SDebug db = new SDebug("MultishelfViewPanel");

    public MultishelfViewPanel(MultishelfViewController multishelfViewController, NodeModelDelegate nodeModelDelegate, IUiToolkit iUiToolkit) {
        if (db.on()) {
            db.println("<init>");
        }
        this.msvc = multishelfViewController;
        this.nmd = nodeModelDelegate;
        this.cms = nodeModelDelegate.getChassisModelsInstance();
        this.uiToolkit = iUiToolkit;
        this.cms.addObserver(this);
        this.setBorder(BorderFactory.createEmptyBorder(22, 22, 22, 22));
        this.setLayout(new BoxLayout(this, 0));
        this.popup = new JPopupMenu();
        this.actOrg = new ActionOrganizer(this);
        this.actOrg.addMenuItem((JComponent)this.popup, null, CMD_UP, 85);
        this.actOrg.addMenuItem((JComponent)this.popup, null, CMD_ADD_RACK, 65);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.buildPane();
    }

    public NodeModelDelegate getNodeModel() {
        return this.nmd;
    }

    public AbstractViewController getViewController() {
        return this.msvc;
    }

    public IUiToolkit getUiToolkit() {
        return this.uiToolkit;
    }

    private synchronized void buildPane() {
        short s;
        Object object;
        sShelfInfoSubset[] sShelfInfoSubsetArray = this.cms.getShelfInfoList();
        ArrayList<RackViewPanel> arrayList = new ArrayList<RackViewPanel>();
        for (int i = 0; i < sShelfInfoSubsetArray.length; ++i) {
            BayViewPanel bayViewPanel;
            RackViewPanel rackViewPanel;
            int n = this.cms.getShelfIdByChassisIndex(sShelfInfoSubsetArray[i].chassisIndex);
            object = this.cms.getChassisByShelfId(n);
            s = sShelfInfoSubsetArray[i].position.rackNumber;
            short s2 = sShelfInfoSubsetArray[i].position.positionInRack;
            if (this.rackMapContainsKey(s)) {
                rackViewPanel = this.getRack(s);
                bayViewPanel = rackViewPanel.getBay(s2);
                if (bayViewPanel.getChassis() == object) continue;
                bayViewPanel.update((Observable)object, ModelUpdateType.ADDED);
                continue;
            }
            rackViewPanel = new RackViewPanel(this, this.nmd.isSdh(), s);
            bayViewPanel = rackViewPanel.getBay(s2);
            bayViewPanel.update((Observable)object, ModelUpdateType.ADDED);
            this.addToRackMap(s, rackViewPanel);
            arrayList.add(rackViewPanel);
        }
        Iterator<Object> iterator = this.rackMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            object = (RackViewPanel)this.rackMap.get(n);
            for (s = 0; s < ((RackViewPanel)object).MAX_BAYS; ++s) {
                BayViewPanel bayViewPanel = ((RackViewPanel)object).getBay(s + 1);
                if (bayViewPanel.isEmpty()) continue;
                boolean bl = false;
                for (int i = 0; i < sShelfInfoSubsetArray.length; ++i) {
                    if (sShelfInfoSubsetArray[i].position.rackNumber != ((RackViewPanel)object).getRackNum() || sShelfInfoSubsetArray[i].position.positionInRack != s + 1) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                bayViewPanel.bayRemoved();
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RackViewPanel rackViewPanel = (RackViewPanel)iterator.next();
            object = new JPanel();
            ((Container)object).add(rackViewPanel);
            RackBundle rackBundle = new RackBundle();
            this.add((Component)object);
            rackBundle.add((Component)object);
            if (iterator.hasNext()) {
                Component component = Box.createHorizontalGlue();
                this.add(component);
                rackBundle.add(component);
                component = Box.createHorizontalStrut(Math.round(11.0f));
                this.add(component);
                rackBundle.add(component);
                component = Box.createHorizontalGlue();
                this.add(component);
                rackBundle.add(component);
            }
            this.addToBundleMap(rackViewPanel.getRackNum(), rackBundle);
        }
        this.actOrg.getMenuItem(CMD_ADD_RACK).setEnabled(this.getRackMapSize() < 8);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_UP) {
            this.msvc.tryJumpView(this.msvc.getParentVC().getViewName());
        } else if (string == CMD_ADD_RACK) {
            this.addRack((short)0);
        }
    }

    private synchronized void addToBundleMap(int n, RackBundle rackBundle) {
        this.bundleMap.put(new Integer(n), rackBundle);
    }

    private synchronized RackBundle getFromBundleMap(int n) {
        return (RackBundle)this.bundleMap.get(new Integer(n));
    }

    private synchronized void removeFromBundleMap(int n) {
        this.bundleMap.remove(new Integer(n));
    }

    private synchronized void clearBundleMap() {
        this.bundleMap.clear();
    }

    private synchronized void addToRackMap(int n, RackViewPanel rackViewPanel) {
        this.rackMap.put(new Integer(n), rackViewPanel);
    }

    private synchronized boolean rackMapContainsKey(int n) {
        return this.rackMap.containsKey(new Integer(n));
    }

    public synchronized RackViewPanel getRack(int n) {
        return (RackViewPanel)this.rackMap.get(new Integer(n));
    }

    private synchronized void removeFromRackMap(int n) {
        this.rackMap.remove(new Integer(n));
    }

    private synchronized int getRackMapSize() {
        return this.rackMap.size();
    }

    private void addRack(short s) {
        final short s2 = s < 1 ? this.nextAvailRackNum() : s;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (s2 > 0) {
                    JPanel jPanel = new JPanel();
                    RackViewPanel rackViewPanel = new RackViewPanel(MultishelfViewPanel.this, MultishelfViewPanel.this.nmd.isSdh(), s2);
                    MultishelfViewPanel.this.addToRackMap(s2, rackViewPanel);
                    jPanel.add(rackViewPanel);
                    RackBundle rackBundle = new RackBundle();
                    Component component = Box.createHorizontalGlue();
                    MultishelfViewPanel.this.add(component);
                    rackBundle.add(component);
                    component = Box.createHorizontalStrut(Math.round(11.0f));
                    MultishelfViewPanel.this.add(component);
                    rackBundle.add(component);
                    component = Box.createHorizontalGlue();
                    MultishelfViewPanel.this.add(component);
                    rackBundle.add(component);
                    rackBundle.add(jPanel);
                    MultishelfViewPanel.this.addToBundleMap(rackViewPanel.getRackNum(), rackBundle);
                    MultishelfViewPanel.this.add(jPanel);
                }
                MultishelfViewPanel.this.actOrg.getMenuItem(MultishelfViewPanel.CMD_ADD_RACK).setEnabled(MultishelfViewPanel.this.getRackMapSize() < 8);
                MultishelfViewPanel.this.revalidate();
            }
        });
    }

    void removeRack(final RackViewPanel rackViewPanel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                short s = rackViewPanel.getRackNum();
                MultishelfViewPanel.this.removeFromRackMap(s);
                RackBundle rackBundle = MultishelfViewPanel.this.getFromBundleMap(s);
                Iterator iterator = rackBundle.iterator();
                while (iterator.hasNext()) {
                    Component component = (Component)iterator.next();
                    MultishelfViewPanel.this.remove(component);
                }
                MultishelfViewPanel.this.removeFromBundleMap(s);
                MultishelfViewPanel.this.actOrg.getMenuItem(MultishelfViewPanel.CMD_ADD_RACK).setEnabled(MultishelfViewPanel.this.getRackMapSize() < 8);
                MultishelfViewPanel.this.revalidate();
            }
        });
    }

    private short nextAvailRackNum() {
        short s = -1;
        for (int n = 0; n < 8; n = (int)((short)(n + 1))) {
            if (this.rackMapContainsKey(n + 1)) continue;
            s = (short)(n + 1);
            break;
        }
        return s;
    }

    public IChassisModel getSelectedShelf() {
        if (this.selectedShelf != null) {
            return this.selectedShelf.getChassis();
        }
        return null;
    }

    public void update(Observable observable, Object object) {
        db.fine("update(" + observable + ", " + object + ")");
        int n = -1;
        IChassisModel iChassisModel = null;
        short s = -1;
        int n2 = -1;
        if (observable instanceof ChassisModels) {
            Object object2;
            if (object instanceof ChassisModelUpdate) {
                object2 = (ChassisModelUpdate)object;
                iChassisModel = ((ChassisModelUpdate)object2).getChassisModel();
                s = ((ChassisModelUpdate)object2).getRackNum();
                n2 = ((ChassisModelUpdate)object2).getRackPos();
                n = 2;
            } else {
                n = (Integer)object;
            }
            switch (n) {
                case 2: {
                    Object object3;
                    if (iChassisModel == null) break;
                    db.fine("ADDED " + iChassisModel);
                    object2 = null;
                    if (this.rackMapContainsKey(s)) {
                        object2 = this.getRack(s);
                    } else {
                        object3 = object2 = new RackViewPanel(this, this.nmd.isSdh(), s);
                        SwingUtilities.invokeLater(new Runnable((RackViewPanel)object3){
                            private final /* synthetic */ RackViewPanel val$newRack;
                            {
                                this.val$newRack = rackViewPanel;
                            }

                            public void run() {
                                JPanel jPanel = new JPanel();
                                MultishelfViewPanel.this.addToRackMap(this.val$newRack.getRackNum(), this.val$newRack);
                                jPanel.add(this.val$newRack);
                                RackBundle rackBundle = new RackBundle();
                                Component component = Box.createHorizontalGlue();
                                MultishelfViewPanel.this.add(component);
                                rackBundle.add(component);
                                component = Box.createHorizontalStrut(Math.round(11.0f));
                                MultishelfViewPanel.this.add(component);
                                rackBundle.add(component);
                                component = Box.createHorizontalGlue();
                                MultishelfViewPanel.this.add(component);
                                rackBundle.add(component);
                                rackBundle.add(jPanel);
                                MultishelfViewPanel.this.addToBundleMap(this.val$newRack.getRackNum(), rackBundle);
                                MultishelfViewPanel.this.add(jPanel);
                                MultishelfViewPanel.this.revalidate();
                            }
                        });
                    }
                    object3 = ((RackViewPanel)object2).getBay(n2);
                    ((BayViewPanel)object3).update((Observable)((Object)iChassisModel), ModelUpdateType.ADDED);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    db.fine("Received CHANGED, rebuilding everything ...");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MultishelfViewPanel.this.buildPane();
                            MultishelfViewPanel.this.revalidate();
                            MultishelfViewPanel.this.repaint(MultishelfViewPanel.this.getVisibleRect());
                        }
                    });
                    break;
                }
                default: {
                    db.severe("Unknown update type " + n);
                }
            }
        }
    }

    public void setSelectedShelf(AbstractShelfLayout abstractShelfLayout) {
        db.fine("setSelectedShelf(" + abstractShelfLayout + ")");
        if (this.selectedShelf != null && this.selectedShelf != abstractShelfLayout) {
            this.selectedShelf.setBorder(UNSELECTED_BORDER);
        }
        this.selectedShelf = abstractShelfLayout;
        if (this.selectedShelf != null) {
            this.selectedShelf.setBorder(SELECTED_BORDER);
            AbstractViewController.setActiveObject((Object)this.selectedShelf);
        }
    }

    private class RackBundle {
        private List components = new ArrayList();

        public Iterator iterator() {
            return this.components.iterator();
        }

        public void add(Component component) {
            this.components.add(component);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MultishelfViewPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

